% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsCSTe}
\alias{NumArcsCSTe}
\title{Number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) - standard
equilateral triangle case}
\usage{
NumArcsCSTe(dat, t, M = c(1, 1, 1))
}
\arguments{
\item{dat}{A set of 2D points which constitute the vertices of the digraph.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates.
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
Number of arcs for the CS-PCD with vertices being 2D data set, \code{dat}, in \eqn{T_e}
with expansion parameter, \eqn{t>0}, and center of mass CM. CS proximity regions are defined only
for \code{dat} points inside \eqn{T_e}, i.e., arcs are possible for such points only.
}
\description{
Returns the number of arcs of Central Similarity Proximity Catch Digraphs (CS-PCDs) whose vertices are the
given 2D numerical data set, \code{dat}.

CS proximity region \eqn{N_{CS}(x,t)} is defined with respect to the standard
equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with expansion parameter \eqn{t>0}
and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
For the number of arcs, loops are not allowed so
arcs are only possible for points inside \eqn{T_e} for this function.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
n<-10  #try also n<-20

set.seed(1)
dat<-runifTe(n)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

NumArcsCSTe(dat,t=.5,M)
NumArcsCSTe(dat,t=3,M)
NumArcsCSTe(dat,t=1.5,M)

NumArcsCSTe(rbind(dat,c(0,1)),t=2,M)
NumArcsCSTe(c(.4,.2),t=.5,M)

NumArcsCSTe(dat,t=1.5,M);

NumArcsCSTe(rbind(dat,dat),t=1.5,M)

dat.fr<-data.frame(a=dat)
NumArcsCSTe(dat.fr,t=1.5,M);

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsCStri}}, \code{\link{NumArcsCSMT}}, and \code{\link{NumArcsPETe}},
}
\author{
Elvan Ceyhan
}
