% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam2AStri}
\alias{Gam2AStri}
\title{The indicator for two points constituting a dominating set for Arc Slice Proximity Catch Digraphs
(AS-PCDs) - one triangle case}
\usage{
Gam2AStri(
  pt1,
  pt2,
  Dt,
  tri,
  M = "CC",
  rv1 = NULL,
  rv2 = NULL,
  ch.data.pnts = FALSE
)
}
\arguments{
\item{pt1, pt2}{Two 2D points to be tested for constituting a dominating set of the AS-PCD.}

\item{Dt}{A set of 2D points which constitutes the vertices of the AS-PCD.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or
a 3D point in  barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M="CC"} i.e., the circumcenter of \code{tri}.}

\item{rv1, rv2}{The indices of the vertices whose regions contains \code{pt1} and \code{pt2}, respectively.
They take the vertex labels as \eqn{1,2,3} as in the row order of the vertices in \code{tri}
(default is \code{NULL} for both).}

\item{ch.data.pnts}{A logical argument for checking whether points \code{pt1} and \code{pt2} are data points in \code{Dt} or not
(default is \code{FALSE}).}
}
\value{
\eqn{I(}\{\code{pt1,pt2}\} is a dominating set of the AS-PCD\eqn{)} where vertices of the AS-PCD are the 2D data set \code{Dt}),
that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of AS-PCD, returns 0 otherwise
}
\description{
Returns \eqn{I(}\{\code{pt1,pt2}\} is a dominating set of the AS-PCD\eqn{)} where vertices of the AS-PCD are
the 2D data set \code{Dt}), that is, returns 1 if \{\code{pt1,pt2}\} is a dominating set of AS-PCD, returns 0 otherwise.

AS proximity regions are defined with respect to the triangle \code{tri}.
Point, \code{pt1}, is in the region of vertex \code{rv1} (default is \code{NULL})
and point, \code{pt2}, is in the region of vertex \code{rv2} (default is \code{NULL}); vertices (and hence \code{rv1} and \code{rv2})
are labeled as \eqn{1,2,3} in the order they are stacked row-wise in \code{tri}.

Vertex regions are based on
the center \code{M="CC"} for circumcenter of \code{tri}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri};
default is \code{M="CC"} the circumcenter of \code{tri}.

\code{ch.data.pnts} is for checking whether points \code{pt1} and \code{pt2} are data
points in \code{Dt} or not (default is \code{FALSE}), so by default this function checks whether the points \code{pt1} and \code{pt2}
would constitute dominating set if they actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.2)

Gam2AStri(dat[1,],dat[2,],dat,Tr,M)
Gam2AStri(dat[1,],dat[1,],dat,Tr,M)  #same two points cannot be a dominating set of size 2

Gam2AStri(c(.2,.4),dat[2,],dat,Tr,M)
Gam2AStri(c(.2,.4),c(.2,.5),dat,Tr,M)
Gam2AStri(c(.2,.4),c(.2,.5),rbind(c(.2,.4),c(.2,.5)),Tr,M)

#or try
rv1<-rv.triCC(c(.2,.4),Tr)$rv
rv2<-rv.triCC(c(.2,.5),Tr)$rv
Gam2AStri(c(.2,.4),c(.2,.5),rbind(c(.2,.4),c(.2,.5)),Tr,M,rv1,rv2)

ind.gam2<-vector()
for (i in 1:(n-1))
  for (j in (i+1):n)
  {if (Gam2AStri(dat[i,],dat[j,],dat,Tr,M)==1)
   ind.gam2<-rbind(ind.gam2,c(i,j))}
ind.gam2

#or try
rv1<-rv.triCC(dat[1,],Tr)$rv
rv2<-rv.triCC(dat[2,],Tr)$rv
Gam2AStri(dat[1,],dat[2,],dat,Tr,M,rv1,rv2)

#or try
rv1<-rv.triCC(dat[1,],Tr)$rv
Gam2AStri(dat[1,],dat[2,],dat,Tr,M,rv1)

#or try
Rv2<-rv.triCC(dat[2,],Tr)$rv
Gam2AStri(dat[1,],dat[2,],dat,Tr,M,rv2=Rv2)

Gam2AStri(c(1.3,1.2),c(1.35,1.25),dat,Tr,M)

dat.fr<-data.frame(a=dat)
Gam2AStri(c(.3,.2),c(.35,.25),dat.fr,Tr,M)

dat.fr<-data.frame(a=Tr)
Gam2AStri(c(.3,.2),c(.35,.25),dat,dat.fr,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam2ASbastri}}
}
\author{
Elvan Ceyhan
}
