% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{int.2lines}
\alias{int.2lines}
\title{The point of intersection of two lines}
\usage{
int.2lines(p1, q1, p2, q2)
}
\arguments{
\item{p1, q1}{2D points that determine the first straight line (i.e., through which the first straight line
passes)}

\item{p2, q2}{2D points that determine the second straight line (i.e., through which the second straight line
passes)}
}
\value{
The coordinates of the point of intersection of the two lines, first passing through points
\code{p1} and \code{q1} and second passing through points \code{p2} and \code{q2}.
}
\description{
Returns the intersection of two lines, first line passing through points \code{p1} and \code{q1}
and second line passing through points \code{p2} and \code{q2}. The points are chosen so that lines are well
defined.
}
\examples{
A<-c(-1.22,-2.33); B<-c(2.55,3.75); C<-c(0,6); D<-c(3,-2)

ip<-int.2lines(A,B,C,D)
ip
pts<-rbind(A,B,C,D,ip)
xr<-range(pts)
xf<-abs(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=20)  #try also l=100
lnAB<-Line(A,B,x)
lnCD<-Line(C,D,x)

y1<-lnAB$y
y2<-lnCD$y
Xlim<-range(x,pts)
Ylim<-range(y1,y2,pts)
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
pf<-c(xd,-yd)*.025

#plot of the line joining A and B
plot(rbind(A,B,C,D),pch=1,xlab="x",ylab="y",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
lines(x,y1,lty=1,col=1)
lines(x,y2,lty=1,col=2)
text(rbind(A+pf,B+pf),c("A","B"))
text(rbind(C+pf,D+pf),c("C","D"))
text(rbind(ip+pf),c("intersection\n point"))

int.2lines(c(1,2),c(1,3),C,D)

}
\seealso{
\code{\link{int.circ.line}} and \code{\link{dp2l}}
}
