% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam1PEtri}
\alias{Gam1PEtri}
\title{The indicator for a point being a dominating point for Proportional Edge Proximity Catch Digraphs (PE-PCDs)
- one triangle case}
\usage{
Gam1PEtri(p, Dt, tri, r, M = c(1, 1, 1), rv = NULL, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point or not of the PE-PCD}

\item{Dt}{A set of 2D points which constitutes the vertices of the PE-PCD}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}

\item{r}{A positive real number which serves as the expansion parameter in PE proximity region; must be \eqn{\ge 1}}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}}

\item{rv}{Index of the vertex whose region contains point \code{p}, \code{rv} takes the vertex labels as 1,2,3 as
in the row order of the vertices in \code{tri}}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Dt} or not (default is \code{FALSE})}
}
\value{
I(\code{p} is a dominating point of the PE-PCD) where the vertices of the PE-PCD are the 2D data set \code{Dt},
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns I(\code{p} is a dominating point of the PE-PCD) where the vertices of the PE-PCD are the 2D data set \code{Dt} in the triangle \code{tri}, that is,
returns 1 if \code{p} is a dominating point of PE-PCD, returns 0 otherwise.

Point, \code{p}, is in the vertex region of vertex \code{rv} (default is \code{NULL}); vertices are labeled as 1,2,3
in the order they are stacked row-wise in \code{tri}.

PE proximity region is constructed with respect to the triangle \code{tri} with expansion parameter \eqn{r \ge 1}
and vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian coordinates or
\eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of the triangle \code{tri}
or based on the circumcenter of \code{tri}; default is \eqn{M=(1,1,1)} i.e. the center of mass of \code{tri}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Dt} or not (default is \code{FALSE}),
so by default this function checks whether the point \code{p} would be a dominating point
if it actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10  #try also n<-20

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

r<-1.5  #try also r<-2

Gam1PEtri(c(1.4,1),c(1.4,1),Tr,r,M)
Gam1PEtri(dat[1,],dat,Tr,r,M)
Gam1PEtri(c(1,2),dat,Tr,r,M)

Gam1PEtri(c(1,2),c(1,2),Tr,r,M)
Gam1PEtri(c(1,2),c(1,2),Tr,r,M,ch.data.pnt = TRUE)

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Gam1PEtri(dat[i,],dat,Tr,r,M))}

ind.gam1<-which(gam.vec==1)
ind.gam1

#or try
Rv<-rv.tri.cent(dat[1,],Tr,M)$rv
Gam1PEtri(dat[1,],dat,Tr,r,M,Rv)

Ds<-cp2e.tri(Tr,M)

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

Xlim<-range(Tr[,1],dat[,1],M[1])
Ylim<-range(Tr[,2],dat[,2],M[2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(dat,pch=1,col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(rbind(dat[ind.gam1,]),pch=4,col=2)
#rbind is to insert the points correctly if there is only one dominating point

txt<-rbind(Tr,M,Ds)
xc<-txt[,1]+c(-.02,.03,.02,-.02,.04,-.03,.0)
yc<-txt[,2]+c(.02,.02,.05,-.03,.04,.06,-.07)
txt.str<-c("A","B","C","M","D1","D2","D3")
text(xc,yc,txt.str)

P<-c(1.4,1)
Gam1PEtri(P,P,Tr,r,M)
Gam1PEtri(dat[1,],dat,Tr,r,M)

dat.fr<-data.frame(a=dat)
Gam1PEtri(P,dat.fr,Tr,r,M)

dat.fr<-data.frame(a=Tr)
Gam1PEtri(P,dat,dat.fr,r,M)

\dontrun{
Gam1PEtri(c(1,2),dat,Tr,r,M,ch.data.pnt = TRUE)
#gives an error message since p is not a data point
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam1PEbastri}} and \code{\link{Gam1AStri}}
}
