\name{wgtMatrix}
\alias{wgtMatrix}
\title{
Compute weight matrix of simulated DAG.
}
\description{
Transform a DAG that was generated by \code{\link{randomDAG}} to a
weight matrix. 
}
\usage{
wgtMatrix(g, transpose = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{g}{Graph object containing the DAG.
}
  \item{transpose}{Transpose weight matrix (see details).
    }
}
\details{
When generating a DAG (e.g. using \code{\link{randomDAG}}), a graph
object is usually generated and edge weights are usually specified. This
function extracts the edge weights and arranges them in a matrix M.

If \code{transpose} is \code{TRUE} (default), M[i,j] is the weight of
the edge from j to i. If \code{transpose} is \code{FALSE} (default),
M[i,j] is the weight of the edge from i to j. 
}
\value{
Weight matrix.
}
\author{
Markus Kalisch
}
\note{
Not that this function can \emph{not} be used to estimate the edge
weights in an estimated DAG / CPDAG.
}

\seealso{
\code{\link{randomDAG}} for generating a random DAG;
\code{\link{rmvDAG}} for simulating data from a generated DAG.
}
\examples{
set.seed(123)
g <- randomDAG(n = 5, prob = 0.3) ## generate random DAG
if(require(Rgraphviz)) {
plot(g)
}

## edge weights as matrix
wgtMatrix(g)

## for comparison: edge weights in graph object
g@edgeData@data 
}
\keyword{misc}

