% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{corpca}
\alias{corpca}
\title{Principal Components Analysis}
\usage{
corpca(data, K)
}
\arguments{
\item{data}{a data matrix or a data frame.}

\item{K}{an integer specifying the number of principal components that are retained.}
}
\description{
\code{corpca} performs a principal components analysis on a dataset, and returns an object \code{x}
which contains the loadings, the scores and the singular values of the \code{K} first principal components.
It handles missing values in a dataset and actually computes the eigen elements of the rather small \code{n x n}
covariance matrix. All these variables are accesible using
the dollar sign (example : \code{stds <- x$neutral_sdev}).
}
\examples{
x <- read4pcadapt("geno3pops",option="example")
y <- pcadapt(x,K=3)
}

