% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/iccplot.CRSM.R, R/iccplot.DRM.R, R/iccplot.MPRM.R, R/iccplot.R
\name{iccplot.CRSM}
\alias{iccplot}
\alias{iccplot.CRSM}
\alias{iccplot.DRM}
\alias{iccplot.MPRM}
\title{Item Characteristic Curve}
\usage{
\method{iccplot}{CRSM}(object, ...)

\method{iccplot}{DRM}(object, ...)

\method{iccplot}{MPRM}(object, ...)

iccplot(object, ...)
}
\arguments{
\item{object}{Object of class \code{CRSM} for ICC of the
CRSM or object of class \code{MPRM} for graphical model check of the MPRM}

\item{\dots}{\dots{}}
}
\description{
The item characteristic curve is performed for the multidimensional polytomous
Rasch model or the continuous Rating Scale Model.
}
\details{
The item characteristic curve (ICC) plots the response probability depending on person and item parameter.
For plotting the ICC, the object resulting from MPRM \code{\link{MPRM}} or CRSM \code{\link{CRSM}} is the input for the \code{iccplot} function.
}
\examples{
#estimate CRSM for the first three items
data(analog)
res_cr <- CRSM(extraversion, low=-10, high=10)

#ICC plot
iccplot(res_cr)
}
\author{
Christine Hohensinn
}
\seealso{
\code{\link{LRT}} \code{\link{CRSM}}
}
\keyword{characteristic}
\keyword{curve,}
\keyword{function}
\keyword{item}

