% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_read_any_json.R
\name{f_read_any_json}
\alias{f_read_any_json}
\title{Read a '.json' File in the '.pbix' Collection of Files}
\usage{
f_read_any_json(input_file_pbix, input_file, gsub1, gsub2)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}

\item{input_file}{Path of '.json' file in collection of files.}

\item{gsub1}{Text to select for replacement (i.e. text to exclude).}

\item{gsub2}{Text to replace selected text (i.e. text to include).}
}
\value{
Layout as '.json'.
}
\description{
The byte sequence of a '.json' file within a '.pbix' is
retrieved, cleaned by removing ASCII control characters and written to
a temporary file. An attempt is made to read the temporary file as '.json'.
If reading the temporary file as '.json' fails, a second attempt is made.
For the second attempt, specific data within the '.json' file is included
and a temporary file is written. The temporary file is read as '.json'.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

# Run the function
gsub__1 <- paste0(".*sections")
gsub__2 <- "\{\"id\":0,\"sections"
test <- f_read_any_json(pathFileSample, "Report/Layout",
                        gsub__1, gsub__2)
  }
}
\seealso{
Uses: \code{\link{f_get_pbix_fir}}.
}
\author{
Don Diproto
}
