% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpc.r
\name{rpc}
\alias{rpc}
\title{Remote Procedure Call}
\usage{
rpc(cmd = "whoami", exec.type = .pbd_env$RPC.LI$exec.type,
  args = .pbd_env$RPC.LI$args, pport = .pbd_env$RPC.LI$pport,
  user = .pbd_env$RPC.LI$user, hostname = .pbd_env$RPC.LI$hostname,
  priv.key = .pbd_env$RPC.LI$priv.key,
  priv.key.ppk = .pbd_env$RPC.LI$priv.key.ppk,
  intern = .pbd_env$RPC.CT$intern, wait = .pbd_env$RPC.CT$wait)
}
\arguments{
\item{cmd}{the command to be executed on the server.}

\item{exec.type}{either "ssh" or "plink" in character. Windows will force to use "plink".}

\item{args}{further arguments to "ssh" or "plink" for connecting to the server
in addition to port, user id, and host name.}

\item{pport}{ssh port opened on the server.}

\item{user}{user id for logging to the server.}

\item{hostname}{the server ip or host name.}

\item{priv.key, priv.key.ppk}{location of the private key for user authentication, the file will be
checked first then \code{-i priv.key} will be added to \code{args}
when the file exists.
\code{priv.key.ppk} is only used when \code{plink} is called.}

\item{intern, wait}{arguments passed to \code{system()} or \code{shell()}
whereever they are applicable.}
}
\value{
Mainly the message received from the command line of server
may be returned but may not be captured by R.

For example, Windows with \code{plink} will not capture the return because
currently the authentication is not working. A windows \code{bat} file is
launched by \code{shell.exec()} in an additional \code{cmd.exe} window
to avoid saving password inside R.
}
\description{
Launch a command via ssh or plink on a (remote) server.
}
\details{
Using either \code{ssh} or \code{plink} to launch a command on a (remote)
server.
Authentication is working currently for \code{ssh}.

NO further input from \code{stdin} is expected.
Outputs or errors may not be captured by R.
}
\examples{
\dontrun{
library(pbdRPC, quietly = TRUE)
rpcopt_set(user = "snoweye", hostname = "192.168.56.101")

### see start_rr(), check_rr(), and kill_rr() for more examples.
rpc()
rpc("ls")
rpc("ls ~/work-my")
rpc("cat ~/work-my/00_set_devel_R")

### see ssh(), plink(), and run_args() for lower level examples.

### Local port forwarding
rpc(args = "-N -T -L 55555:localhost:55555")
start_rr()

library(remoter)
client()    # equivalent to client(addr = "192.168.56.101")
}

}
\seealso{
\code{\link{start_rr}()},
         \code{\link{check_rr}()}, \code{\link{kill_rr}()},
         \code{\link{ssh}()}, and \code{\link{plink}()}.
}

