% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.r
\docType{methods}
\name{Accessors}
\alias{Accessors}
\alias{ICTXT}
\alias{ICTXT,ddmatrix-method}
\alias{NCOL}
\alias{NCOL,ddmatrix-method}
\alias{NROW}
\alias{NROW,ddmatrix-method}
\alias{bldim}
\alias{bldim,ddmatrix-method}
\alias{dim,ddmatrix-method}
\alias{ldim}
\alias{ldim,ddmatrix-method}
\alias{length,ddmatrix-method}
\alias{ncol}
\alias{ncol,ddmatrix-method}
\alias{nrow}
\alias{nrow,ddmatrix-method}
\alias{submatrix}
\alias{submatrix,Linalg-method}
\alias{submatrix,ddmatrix-method}
\title{Accessor Functions for Distributed Matrix Slots}
\usage{
nrow(x)

\S4method{nrow}{ddmatrix}(x)

NROW(x)

\S4method{NROW}{ddmatrix}(x)

ncol(x)

\S4method{ncol}{ddmatrix}(x)

NCOL(x)

\S4method{NCOL}{ddmatrix}(x)

submatrix(x, ...)

\S4method{submatrix}{ddmatrix}(x)

\S4method{submatrix}{Linalg}(x)

ldim(x, ...)

\S4method{ldim}{ddmatrix}(x)

bldim(x, ...)

\S4method{bldim}{ddmatrix}(x)

ICTXT(x, ...)

\S4method{ICTXT}{ddmatrix}(x)

\S4method{dim}{ddmatrix}(x)

\S4method{length}{ddmatrix}(x)
}
\arguments{
\item{x}{numeric distributed matrix}

\item{...}{Extra arguments.}

\item{dim}{global dimension.}

\item{bldim}{blocking dimension.}

\item{ICTXT}{BLACS context.}
}
\value{
Each of \code{dim()}, \code{ldim()}, \code{bldim()} return a length
2 vector.

Each of \code{nrow()}, \code{ncol()}, and \code{length()} return a length 1
vector. Likewise, so does \code{ICTXT()}.

\code{submatrix()} returns a matrix; namely, \code{submatrix(x)} returns a
matrix of dimensions \code{ldim(x)}.
}
\description{
Functions to get dimension information, local storage, or current BLACS
context from a distributed matrix.
}
\details{
The functions \code{nrow()}, \code{ncol()}, \code{length()} and \code{dim()}
are the natural extensions of their ordinary matrix counterparts.

\code{ldim()} will give the dimension of the matrix stored locally on the
process which runs the function. This is a local value, so its return is
process-dependent.  For example, if the 3x3 global matrix \code{x} is
distributed as the \code{ddmatrix} \code{dx} across two processors with
process 0 owning the first two rows and process 1 owning the third, then
\code{ldim(dx)} will return \code{2 3} on process 0 and \code{1 3} on
process 1.

\code{bldim()} will give the blocking dimension that was used to
block-cyclically distribute the distributed matrix.

\code{submatrix()} will give the local storage for the requested object.

\code{ICTXT()} will give the current BLACS context (slot ICTXT) for the
requested object.

\code{ownany()} is intended mostly for developers.  It answers the question
"do I own any of the data?".  The user can either pass a distributed matrix
object or the dim, bldim, and ICTXT of one.
}
\section{Methods}{
 \describe{ \item{list("signature(x = \"ddmatrix\")")}{} }
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

x <- ddmatrix(1:9, 3, bldim=2)

y <- list(dim=dim(x), ldim=ldim(x), bldim=bldim(x))
comm.print(y)

finalize()
}

}
\keyword{Methods}

