% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_chol2inv.r
\docType{methods}
\name{chol2inv}
\alias{chol2inv}
\alias{chol2inv,ddmatrix-method}
\alias{chol2inv-method}
\title{Inverse from Choleski (or QR) Decomposition}
\usage{
\S4method{chol2inv}{ddmatrix}(x, size = NCOL(x))
}
\arguments{
\item{x}{numeric distributed matrices for}

\item{size}{number of columns of \code{x} containing the Choleski
factorization.}
}
\value{
A numeric distributed matrix.
}
\description{
\code{qr()} takes the QR decomposition.
}
\details{
The function returns the inverse of a choleski factored matrix, or the
inverse of \code{crossprod(x)} if \code{qr.R(qr(x))} is passed.
}
\section{Methods}{
 \describe{ \item{list("signature(x = \"ddmatrix\")")}{}
\item{list("signature(x = \"ANY\")")}{} }
}
\examples{

\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

comm.set.seed(diff=T)
x <- ddmatrix("rnorm", 3, 3, bldim=2)

R <- qr.R(qr(x))
xtx.inv <- chol2inv(R)

id <- as.matrix(xtx.inv \%*\% crossprod(x))

comm.print(id)

finalize()
}

}
\keyword{Algebra}
\keyword{Linear}
\keyword{Methods}

