% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist.r
\name{base.redist}
\alias{base.redist}
\title{base.redist}
\usage{
base.redist(desc, A)
}
\arguments{
\item{desc}{ScaLAPACK descriptor array.}

\item{A}{Matrix.}
}
\value{
A block cyclic matrix of the input matrix A from rank 0.
}
\description{
Redistribute a matrix from rank 0 to all ranks in block cyclic
fashion.
}
\examples{
spmd.code <- "
  suppressMessages(library(pbdMPI))
  suppressMessages(library(pbdBASE))
  init.grid()

  ### Set data matrix A and desc.
  A <- matrix(as.double(1:30), nrow = 6, ncol = 5)
  if (comm.rank() != 0)
    A <- matrix(as.double(0), nrow = 6, ncol = 5)
  dim <- dim(A)
  bldim <- c(3L, 3L)
  ldim <- base.numroc(dim = dim, bldim = bldim)
  desc <- base.descinit(dim = dim, bldim = bldim, ldim = ldim)

  ### Redistribute from rank 0.
  dA <- base.redist(desc, A)
  comm.print(dA, all.rank = TRUE)

  finalize()
"
pbdMPI::execmpi(spmd.code = spmd.code, nranks = 2L)

}
