% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_object_versions}
\alias{s3_list_object_versions}
\title{This operation is not supported by directory buckets}
\usage{
s3_list_object_versions(
  Bucket,
  Delimiter = NULL,
  EncodingType = NULL,
  KeyMarker = NULL,
  MaxKeys = NULL,
  Prefix = NULL,
  VersionIdMarker = NULL,
  ExpectedBucketOwner = NULL,
  RequestPayer = NULL,
  OptionalObjectAttributes = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name that contains the objects.}

\item{Delimiter}{A delimiter is a character that you specify to group keys. All keys that
contain the same string between the \code{prefix} and the first occurrence of
the delimiter are grouped under a single result element in
\code{CommonPrefixes}. These groups are counted as one result against the
\code{max-keys} limitation. These keys are not returned elsewhere in the
response.}

\item{EncodingType}{}

\item{KeyMarker}{Specifies the key to start with when listing objects in a bucket.}

\item{MaxKeys}{Sets the maximum number of keys returned in the response. By default,
the action returns up to 1,000 key names. The response might contain
fewer keys but will never contain more. If additional keys satisfy the
search criteria, but were not returned because \code{max-keys} was exceeded,
the response contains \verb{<isTruncated>true</isTruncated>}. To return the
additional keys, see \code{key-marker} and \code{version-id-marker}.}

\item{Prefix}{Use this parameter to select only those keys that begin with the
specified prefix. You can use prefixes to separate a bucket into
different groupings of keys. (You can think of using \code{prefix} to make
groups in the same way that you'd use a folder in a file system.) You
can use \code{prefix} with \code{delimiter} to roll up numerous objects into a
single result under \code{CommonPrefixes}.}

\item{VersionIdMarker}{Specifies the object version you want to start listing from.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}

\item{RequestPayer}{}

\item{OptionalObjectAttributes}{Specifies the optional fields that you want returned in the response.
Fields that you do not specify are not returned.}
}
\description{
This operation is not supported by directory buckets.

See \url{https://www.paws-r-sdk.com/docs/s3_list_object_versions/} for full documentation.
}
\keyword{internal}
