% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_bucket_lifecycle_configuration}
\alias{s3control_get_bucket_lifecycle_configuration}
\title{This action gets an Amazon S3 on Outposts bucket's lifecycle
configuration}
\usage{
s3control_get_bucket_lifecycle_configuration(AccountId, Bucket)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the Outposts bucket.}

\item{Bucket}{[required] The Amazon Resource Name (ARN) of the bucket.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the Amazon Web
Services SDK and CLI, you must specify the ARN of the bucket accessed in
the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through Outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}
}
\description{
This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see \code{\link[=s3control_get_bucket_lifecycle_configuration]{get_bucket_lifecycle_configuration}} in the \emph{Amazon S3 API Reference}.

See \url{https://www.paws-r-sdk.com/docs/s3control_get_bucket_lifecycle_configuration/} for full documentation.
}
\keyword{internal}
