% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_cors}
\alias{s3_get_bucket_cors}
\title{Returns the Cross-Origin Resource Sharing (CORS) configuration
information set for the bucket}
\usage{
s3_get_bucket_cors(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the cors configuration.

To use this API operation against an access point, provide the alias of
the access point in place of the bucket name.

To use this API operation against an Object Lambda access point, provide
the alias of the Object Lambda access point in place of the bucket name.
If the Object Lambda access point alias in a request is not valid, the
error code \code{InvalidAccessPointAliasError} is returned. For more
information about \code{InvalidAccessPointAliasError}, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ErrorCodeList}{List of Error Codes}.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Returns the Cross-Origin Resource Sharing (CORS) configuration information set for the bucket.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_cors/} for full documentation.
}
\keyword{internal}
