# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include finspacedata_service.R
NULL

#' Adds a user account to a permission group to grant permissions for
#' actions a user can perform in FinSpace
#'
#' @description
#' Adds a user account to a permission group to grant permissions for actions a user can perform in FinSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_associate_user_to_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_associate_user_to_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group.
#' @param userId &#91;required&#93; The unique identifier for the user.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_associate_user_to_permission_group
finspacedata_associate_user_to_permission_group <- function(permissionGroupId, userId, clientToken = NULL) {
  op <- new_operation(
    name = "AssociateUserToPermissionGroup",
    http_method = "POST",
    http_path = "/permission-group/{permissionGroupId}/users/{userId}",
    paginator = list()
  )
  input <- .finspacedata$associate_user_to_permission_group_input(permissionGroupId = permissionGroupId, userId = userId, clientToken = clientToken)
  output <- .finspacedata$associate_user_to_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$associate_user_to_permission_group <- finspacedata_associate_user_to_permission_group

#' Creates a new Changeset in a FinSpace Dataset
#'
#' @description
#' Creates a new Changeset in a FinSpace Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_create_changeset/](https://www.paws-r-sdk.com/docs/finspacedata_create_changeset/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetId &#91;required&#93; The unique identifier for the FinSpace Dataset where the Changeset will
#' be created.
#' @param changeType &#91;required&#93; The option to indicate how a Changeset will be applied to a Dataset.
#' 
#' -   `REPLACE` – Changeset will be considered as a replacement to all
#'     prior loaded Changesets.
#' 
#' -   `APPEND` – Changeset will be considered as an addition to the end of
#'     all prior loaded Changesets.
#' 
#' -   `MODIFY` – Changeset is considered as a replacement to a specific
#'     prior ingested Changeset.
#' @param sourceParams &#91;required&#93; Options that define the location of the data being ingested
#' (`s3SourcePath`) and the source of the changeset (`sourceType`).
#' 
#' Both `s3SourcePath` and `sourceType` are required attributes.
#' 
#' Here is an example of how you could specify the `sourceParams`:
#' 
#' ` "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } `
#' 
#' The S3 path that you specify must allow the FinSpace role access. To do
#' that, you first need to configure the IAM policy on S3 bucket. For more
#' information, see [Loading data from an Amazon S3 Bucket using the
#' FinSpace
#' API](https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets)
#' section.
#' @param formatParams &#91;required&#93; Options that define the structure of the source file(s) including the
#' format type (`formatType`), header row (`withHeader`), data separation
#' character (`separator`) and the type of compression (`compression`).
#' 
#' `formatType` is a required attribute and can have the following values:
#' 
#' -   `PARQUET` – Parquet source file format.
#' 
#' -   `CSV` – CSV source file format.
#' 
#' -   `JSON` – JSON source file format.
#' 
#' -   `XML` – XML source file format.
#' 
#' Here is an example of how you could specify the `formatParams`:
#' 
#' ` "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } `
#' 
#' Note that if you only provide `formatType` as `CSV`, the rest of the
#' attributes will automatically default to CSV values as following:
#' 
#' ` { "withHeader": "true", "separator": "," } `
#' 
#' For more information about supported file formats, see [Supported Data
#' Types and File
#' Formats](https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html)
#' in the FinSpace User Guide.
#'
#' @keywords internal
#'
#' @rdname finspacedata_create_changeset
finspacedata_create_changeset <- function(clientToken = NULL, datasetId, changeType, sourceParams, formatParams) {
  op <- new_operation(
    name = "CreateChangeset",
    http_method = "POST",
    http_path = "/datasets/{datasetId}/changesetsv2",
    paginator = list()
  )
  input <- .finspacedata$create_changeset_input(clientToken = clientToken, datasetId = datasetId, changeType = changeType, sourceParams = sourceParams, formatParams = formatParams)
  output <- .finspacedata$create_changeset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$create_changeset <- finspacedata_create_changeset

#' Creates a Dataview for a Dataset
#'
#' @description
#' Creates a Dataview for a Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_create_data_view/](https://www.paws-r-sdk.com/docs/finspacedata_create_data_view/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetId &#91;required&#93; The unique Dataset identifier that is used to create a Dataview.
#' @param autoUpdate Flag to indicate Dataview should be updated automatically.
#' @param sortColumns Columns to be used for sorting the data.
#' @param partitionColumns Ordered set of column names used to partition data.
#' @param asOfTimestamp Beginning time to use for the Dataview. The value is determined as epoch
#' time in milliseconds. For example, the value for Monday, November 1,
#' 2021 12:00:00 PM UTC is specified as 1635768000000.
#' @param destinationTypeParams &#91;required&#93; Options that define the destination type for the Dataview.
#'
#' @keywords internal
#'
#' @rdname finspacedata_create_data_view
finspacedata_create_data_view <- function(clientToken = NULL, datasetId, autoUpdate = NULL, sortColumns = NULL, partitionColumns = NULL, asOfTimestamp = NULL, destinationTypeParams) {
  op <- new_operation(
    name = "CreateDataView",
    http_method = "POST",
    http_path = "/datasets/{datasetId}/dataviewsv2",
    paginator = list()
  )
  input <- .finspacedata$create_data_view_input(clientToken = clientToken, datasetId = datasetId, autoUpdate = autoUpdate, sortColumns = sortColumns, partitionColumns = partitionColumns, asOfTimestamp = asOfTimestamp, destinationTypeParams = destinationTypeParams)
  output <- .finspacedata$create_data_view_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$create_data_view <- finspacedata_create_data_view

#' Creates a new FinSpace Dataset
#'
#' @description
#' Creates a new FinSpace Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_create_dataset/](https://www.paws-r-sdk.com/docs/finspacedata_create_dataset/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetTitle &#91;required&#93; Display title for a FinSpace Dataset.
#' @param kind &#91;required&#93; The format in which Dataset data is structured.
#' 
#' -   `TABULAR` – Data is structured in a tabular format.
#' 
#' -   `NON_TABULAR` – Data is structured in a non-tabular format.
#' @param datasetDescription Description of a Dataset.
#' @param ownerInfo Contact information for a Dataset owner.
#' @param permissionGroupParams &#91;required&#93; Permission group parameters for Dataset permissions.
#' @param alias The unique resource identifier for a Dataset.
#' @param schemaDefinition Definition for a schema on a tabular Dataset.
#'
#' @keywords internal
#'
#' @rdname finspacedata_create_dataset
finspacedata_create_dataset <- function(clientToken = NULL, datasetTitle, kind, datasetDescription = NULL, ownerInfo = NULL, permissionGroupParams, alias = NULL, schemaDefinition = NULL) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/datasetsv2",
    paginator = list()
  )
  input <- .finspacedata$create_dataset_input(clientToken = clientToken, datasetTitle = datasetTitle, kind = kind, datasetDescription = datasetDescription, ownerInfo = ownerInfo, permissionGroupParams = permissionGroupParams, alias = alias, schemaDefinition = schemaDefinition)
  output <- .finspacedata$create_dataset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$create_dataset <- finspacedata_create_dataset

#' Creates a group of permissions for various actions that a user can
#' perform in FinSpace
#'
#' @description
#' Creates a group of permissions for various actions that a user can perform in FinSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_create_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_create_permission_group/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the permission group.
#' @param description A brief description for the permission group.
#' @param applicationPermissions &#91;required&#93; The option to indicate FinSpace application permissions that are granted
#' to a specific group.
#' 
#' When assigning application permissions, be aware that the permission
#' `ManageUsersAndGroups` allows users to grant themselves or others access
#' to any functionality in their FinSpace environment's application. It
#' should only be granted to trusted users.
#' 
#' -   [`create_dataset`][finspacedata_create_dataset] – Group members can
#'     create new datasets.
#' 
#' -   `ManageClusters` – Group members can manage Apache Spark clusters
#'     from FinSpace notebooks.
#' 
#' -   `ManageUsersAndGroups` – Group members can manage users and
#'     permission groups. This is a privileged permission that allows users
#'     to grant themselves or others access to any functionality in the
#'     application. It should only be granted to trusted users.
#' 
#' -   `ManageAttributeSets` – Group members can manage attribute sets.
#' 
#' -   `ViewAuditData` – Group members can view audit data.
#' 
#' -   `AccessNotebooks` – Group members will have access to FinSpace
#'     notebooks.
#' 
#' -   `GetTemporaryCredentials` – Group members can get temporary API
#'     credentials.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_create_permission_group
finspacedata_create_permission_group <- function(name, description = NULL, applicationPermissions, clientToken = NULL) {
  op <- new_operation(
    name = "CreatePermissionGroup",
    http_method = "POST",
    http_path = "/permission-group",
    paginator = list()
  )
  input <- .finspacedata$create_permission_group_input(name = name, description = description, applicationPermissions = applicationPermissions, clientToken = clientToken)
  output <- .finspacedata$create_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$create_permission_group <- finspacedata_create_permission_group

#' Creates a new user in FinSpace
#'
#' @description
#' Creates a new user in FinSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_create_user/](https://www.paws-r-sdk.com/docs/finspacedata_create_user/) for full documentation.
#'
#' @param emailAddress &#91;required&#93; The email address of the user that you want to register. The email
#' address serves as a uniquer identifier for each user and cannot be
#' changed after it's created.
#' @param type &#91;required&#93; The option to indicate the type of user. Use one of the following
#' options to specify this parameter:
#' 
#' -   `SUPER_USER` – A user with permission to all the functionality and
#'     data in FinSpace.
#' 
#' -   `APP_USER` – A user with specific permissions in FinSpace. The users
#'     are assigned permissions by adding them to a permission group.
#' @param firstName The first name of the user that you want to register.
#' @param lastName The last name of the user that you want to register.
#' @param ApiAccess The option to indicate whether the user can use the
#' [`get_programmatic_access_credentials`][finspacedata_get_programmatic_access_credentials]
#' API to obtain credentials that can then be used to access other FinSpace
#' Data API operations.
#' 
#' -   `ENABLED` – The user has permissions to use the APIs.
#' 
#' -   `DISABLED` – The user does not have permissions to use any APIs.
#' @param apiAccessPrincipalArn The ARN identifier of an AWS user or role that is allowed to call the
#' [`get_programmatic_access_credentials`][finspacedata_get_programmatic_access_credentials]
#' API to obtain a credentials token for a specific FinSpace user. This
#' must be an IAM role within your FinSpace account.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_create_user
finspacedata_create_user <- function(emailAddress, type, firstName = NULL, lastName = NULL, ApiAccess = NULL, apiAccessPrincipalArn = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/user",
    paginator = list()
  )
  input <- .finspacedata$create_user_input(emailAddress = emailAddress, type = type, firstName = firstName, lastName = lastName, ApiAccess = ApiAccess, apiAccessPrincipalArn = apiAccessPrincipalArn, clientToken = clientToken)
  output <- .finspacedata$create_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$create_user <- finspacedata_create_user

#' Deletes a FinSpace Dataset
#'
#' @description
#' Deletes a FinSpace Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_delete_dataset/](https://www.paws-r-sdk.com/docs/finspacedata_delete_dataset/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetId &#91;required&#93; The unique identifier of the Dataset to be deleted.
#'
#' @keywords internal
#'
#' @rdname finspacedata_delete_dataset
finspacedata_delete_dataset <- function(clientToken = NULL, datasetId) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "DELETE",
    http_path = "/datasetsv2/{datasetId}",
    paginator = list()
  )
  input <- .finspacedata$delete_dataset_input(clientToken = clientToken, datasetId = datasetId)
  output <- .finspacedata$delete_dataset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$delete_dataset <- finspacedata_delete_dataset

#' Deletes a permission group
#'
#' @description
#' Deletes a permission group. This action is irreversible.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_delete_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_delete_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group that you want to delete.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_delete_permission_group
finspacedata_delete_permission_group <- function(permissionGroupId, clientToken = NULL) {
  op <- new_operation(
    name = "DeletePermissionGroup",
    http_method = "DELETE",
    http_path = "/permission-group/{permissionGroupId}",
    paginator = list()
  )
  input <- .finspacedata$delete_permission_group_input(permissionGroupId = permissionGroupId, clientToken = clientToken)
  output <- .finspacedata$delete_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$delete_permission_group <- finspacedata_delete_permission_group

#' Denies access to the FinSpace web application and API for the specified
#' user
#'
#' @description
#' Denies access to the FinSpace web application and API for the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_disable_user/](https://www.paws-r-sdk.com/docs/finspacedata_disable_user/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier for the user account that you want to disable.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_disable_user
finspacedata_disable_user <- function(userId, clientToken = NULL) {
  op <- new_operation(
    name = "DisableUser",
    http_method = "POST",
    http_path = "/user/{userId}/disable",
    paginator = list()
  )
  input <- .finspacedata$disable_user_input(userId = userId, clientToken = clientToken)
  output <- .finspacedata$disable_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$disable_user <- finspacedata_disable_user

#' Removes a user account from a permission group
#'
#' @description
#' Removes a user account from a permission group.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_disassociate_user_from_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_disassociate_user_from_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group.
#' @param userId &#91;required&#93; The unique identifier for the user.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_disassociate_user_from_permission_group
finspacedata_disassociate_user_from_permission_group <- function(permissionGroupId, userId, clientToken = NULL) {
  op <- new_operation(
    name = "DisassociateUserFromPermissionGroup",
    http_method = "DELETE",
    http_path = "/permission-group/{permissionGroupId}/users/{userId}",
    paginator = list()
  )
  input <- .finspacedata$disassociate_user_from_permission_group_input(permissionGroupId = permissionGroupId, userId = userId, clientToken = clientToken)
  output <- .finspacedata$disassociate_user_from_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$disassociate_user_from_permission_group <- finspacedata_disassociate_user_from_permission_group

#' Allows the specified user to access the FinSpace web application and API
#'
#' @description
#' Allows the specified user to access the FinSpace web application and API.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_enable_user/](https://www.paws-r-sdk.com/docs/finspacedata_enable_user/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier for the user account that you want to enable.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_enable_user
finspacedata_enable_user <- function(userId, clientToken = NULL) {
  op <- new_operation(
    name = "EnableUser",
    http_method = "POST",
    http_path = "/user/{userId}/enable",
    paginator = list()
  )
  input <- .finspacedata$enable_user_input(userId = userId, clientToken = clientToken)
  output <- .finspacedata$enable_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$enable_user <- finspacedata_enable_user

#' Get information about a Changeset
#'
#' @description
#' Get information about a Changeset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_changeset/](https://www.paws-r-sdk.com/docs/finspacedata_get_changeset/) for full documentation.
#'
#' @param datasetId &#91;required&#93; The unique identifier for the FinSpace Dataset where the Changeset is
#' created.
#' @param changesetId &#91;required&#93; The unique identifier of the Changeset for which to get data.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_changeset
finspacedata_get_changeset <- function(datasetId, changesetId) {
  op <- new_operation(
    name = "GetChangeset",
    http_method = "GET",
    http_path = "/datasets/{datasetId}/changesetsv2/{changesetId}",
    paginator = list()
  )
  input <- .finspacedata$get_changeset_input(datasetId = datasetId, changesetId = changesetId)
  output <- .finspacedata$get_changeset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_changeset <- finspacedata_get_changeset

#' Gets information about a Dataview
#'
#' @description
#' Gets information about a Dataview.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_data_view/](https://www.paws-r-sdk.com/docs/finspacedata_get_data_view/) for full documentation.
#'
#' @param dataViewId &#91;required&#93; The unique identifier for the Dataview.
#' @param datasetId &#91;required&#93; The unique identifier for the Dataset used in the Dataview.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_data_view
finspacedata_get_data_view <- function(dataViewId, datasetId) {
  op <- new_operation(
    name = "GetDataView",
    http_method = "GET",
    http_path = "/datasets/{datasetId}/dataviewsv2/{dataviewId}",
    paginator = list()
  )
  input <- .finspacedata$get_data_view_input(dataViewId = dataViewId, datasetId = datasetId)
  output <- .finspacedata$get_data_view_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_data_view <- finspacedata_get_data_view

#' Returns information about a Dataset
#'
#' @description
#' Returns information about a Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_dataset/](https://www.paws-r-sdk.com/docs/finspacedata_get_dataset/) for full documentation.
#'
#' @param datasetId &#91;required&#93; The unique identifier for a Dataset.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_dataset
finspacedata_get_dataset <- function(datasetId) {
  op <- new_operation(
    name = "GetDataset",
    http_method = "GET",
    http_path = "/datasetsv2/{datasetId}",
    paginator = list()
  )
  input <- .finspacedata$get_dataset_input(datasetId = datasetId)
  output <- .finspacedata$get_dataset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_dataset <- finspacedata_get_dataset

#' Returns the credentials to access the external Dataview from an S3
#' location
#'
#' @description
#' Returns the credentials to access the external Dataview from an S3 location. To call this API:
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_external_data_view_access_details/](https://www.paws-r-sdk.com/docs/finspacedata_get_external_data_view_access_details/) for full documentation.
#'
#' @param dataViewId &#91;required&#93; The unique identifier for the Dataview that you want to access.
#' @param datasetId &#91;required&#93; The unique identifier for the Dataset.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_external_data_view_access_details
finspacedata_get_external_data_view_access_details <- function(dataViewId, datasetId) {
  op <- new_operation(
    name = "GetExternalDataViewAccessDetails",
    http_method = "POST",
    http_path = "/datasets/{datasetId}/dataviewsv2/{dataviewId}/external-access-details",
    paginator = list()
  )
  input <- .finspacedata$get_external_data_view_access_details_input(dataViewId = dataViewId, datasetId = datasetId)
  output <- .finspacedata$get_external_data_view_access_details_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_external_data_view_access_details <- finspacedata_get_external_data_view_access_details

#' Retrieves the details of a specific permission group
#'
#' @description
#' Retrieves the details of a specific permission group.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_get_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_permission_group
finspacedata_get_permission_group <- function(permissionGroupId) {
  op <- new_operation(
    name = "GetPermissionGroup",
    http_method = "GET",
    http_path = "/permission-group/{permissionGroupId}",
    paginator = list()
  )
  input <- .finspacedata$get_permission_group_input(permissionGroupId = permissionGroupId)
  output <- .finspacedata$get_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_permission_group <- finspacedata_get_permission_group

#' Request programmatic credentials to use with FinSpace SDK
#'
#' @description
#' Request programmatic credentials to use with FinSpace SDK.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_programmatic_access_credentials/](https://www.paws-r-sdk.com/docs/finspacedata_get_programmatic_access_credentials/) for full documentation.
#'
#' @param durationInMinutes The time duration in which the credentials remain valid.
#' @param environmentId &#91;required&#93; The FinSpace environment identifier.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_programmatic_access_credentials
finspacedata_get_programmatic_access_credentials <- function(durationInMinutes = NULL, environmentId) {
  op <- new_operation(
    name = "GetProgrammaticAccessCredentials",
    http_method = "GET",
    http_path = "/credentials/programmatic",
    paginator = list()
  )
  input <- .finspacedata$get_programmatic_access_credentials_input(durationInMinutes = durationInMinutes, environmentId = environmentId)
  output <- .finspacedata$get_programmatic_access_credentials_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_programmatic_access_credentials <- finspacedata_get_programmatic_access_credentials

#' Retrieves details for a specific user
#'
#' @description
#' Retrieves details for a specific user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_user/](https://www.paws-r-sdk.com/docs/finspacedata_get_user/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier of the user to get data for.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_user
finspacedata_get_user <- function(userId) {
  op <- new_operation(
    name = "GetUser",
    http_method = "GET",
    http_path = "/user/{userId}",
    paginator = list()
  )
  input <- .finspacedata$get_user_input(userId = userId)
  output <- .finspacedata$get_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_user <- finspacedata_get_user

#' A temporary Amazon S3 location, where you can copy your files from a
#' source location to stage or use as a scratch space in FinSpace notebook
#'
#' @description
#' A temporary Amazon S3 location, where you can copy your files from a source location to stage or use as a scratch space in FinSpace notebook.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_get_working_location/](https://www.paws-r-sdk.com/docs/finspacedata_get_working_location/) for full documentation.
#'
#' @param locationType Specify the type of the working location.
#' 
#' -   `SAGEMAKER` – Use the Amazon S3 location as a temporary location to
#'     store data content when working with FinSpace Notebooks that run on
#'     SageMaker studio.
#' 
#' -   `INGESTION` – Use the Amazon S3 location as a staging location to
#'     copy your data content and then use the location with the Changeset
#'     creation operation.
#'
#' @keywords internal
#'
#' @rdname finspacedata_get_working_location
finspacedata_get_working_location <- function(locationType = NULL) {
  op <- new_operation(
    name = "GetWorkingLocation",
    http_method = "POST",
    http_path = "/workingLocationV1",
    paginator = list()
  )
  input <- .finspacedata$get_working_location_input(locationType = locationType)
  output <- .finspacedata$get_working_location_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$get_working_location <- finspacedata_get_working_location

#' Lists the FinSpace Changesets for a Dataset
#'
#' @description
#' Lists the FinSpace Changesets for a Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_changesets/](https://www.paws-r-sdk.com/docs/finspacedata_list_changesets/) for full documentation.
#'
#' @param datasetId &#91;required&#93; The unique identifier for the FinSpace Dataset to which the Changeset
#' belongs.
#' @param maxResults The maximum number of results per page.
#' @param nextToken A token that indicates where a results page should begin.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_changesets
finspacedata_list_changesets <- function(datasetId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListChangesets",
    http_method = "GET",
    http_path = "/datasets/{datasetId}/changesetsv2",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "changesets")
  )
  input <- .finspacedata$list_changesets_input(datasetId = datasetId, maxResults = maxResults, nextToken = nextToken)
  output <- .finspacedata$list_changesets_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_changesets <- finspacedata_list_changesets

#' Lists all available Dataviews for a Dataset
#'
#' @description
#' Lists all available Dataviews for a Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_data_views/](https://www.paws-r-sdk.com/docs/finspacedata_list_data_views/) for full documentation.
#'
#' @param datasetId &#91;required&#93; The unique identifier of the Dataset for which to retrieve Dataviews.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_data_views
finspacedata_list_data_views <- function(datasetId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDataViews",
    http_method = "GET",
    http_path = "/datasets/{datasetId}/dataviewsv2",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "dataViews")
  )
  input <- .finspacedata$list_data_views_input(datasetId = datasetId, nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_data_views_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_data_views <- finspacedata_list_data_views

#' Lists all of the active Datasets that a user has access to
#'
#' @description
#' Lists all of the active Datasets that a user has access to.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_datasets/](https://www.paws-r-sdk.com/docs/finspacedata_list_datasets/) for full documentation.
#'
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_datasets
finspacedata_list_datasets <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "GET",
    http_path = "/datasetsv2",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "datasets")
  )
  input <- .finspacedata$list_datasets_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_datasets_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_datasets <- finspacedata_list_datasets

#' Lists all available permission groups in FinSpace
#'
#' @description
#' Lists all available permission groups in FinSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_permission_groups/](https://www.paws-r-sdk.com/docs/finspacedata_list_permission_groups/) for full documentation.
#'
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults &#91;required&#93; The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_permission_groups
finspacedata_list_permission_groups <- function(nextToken = NULL, maxResults) {
  op <- new_operation(
    name = "ListPermissionGroups",
    http_method = "GET",
    http_path = "/permission-group",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "permissionGroups")
  )
  input <- .finspacedata$list_permission_groups_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_permission_groups_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_permission_groups <- finspacedata_list_permission_groups

#' Lists all the permission groups that are associated with a specific user
#' account
#'
#' @description
#' Lists all the permission groups that are associated with a specific user account.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_permission_groups_by_user/](https://www.paws-r-sdk.com/docs/finspacedata_list_permission_groups_by_user/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier for the user.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults &#91;required&#93; The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_permission_groups_by_user
finspacedata_list_permission_groups_by_user <- function(userId, nextToken = NULL, maxResults) {
  op <- new_operation(
    name = "ListPermissionGroupsByUser",
    http_method = "GET",
    http_path = "/user/{userId}/permission-groups",
    paginator = list()
  )
  input <- .finspacedata$list_permission_groups_by_user_input(userId = userId, nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_permission_groups_by_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_permission_groups_by_user <- finspacedata_list_permission_groups_by_user

#' Lists all available user accounts in FinSpace
#'
#' @description
#' Lists all available user accounts in FinSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_users/](https://www.paws-r-sdk.com/docs/finspacedata_list_users/) for full documentation.
#'
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults &#91;required&#93; The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_users
finspacedata_list_users <- function(nextToken = NULL, maxResults) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/user",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "users")
  )
  input <- .finspacedata$list_users_input(nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_users_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_users <- finspacedata_list_users

#' Lists details of all the users in a specific permission group
#'
#' @description
#' Lists details of all the users in a specific permission group.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_list_users_by_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_list_users_by_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group.
#' @param nextToken A token that indicates where a results page should begin.
#' @param maxResults &#91;required&#93; The maximum number of results per page.
#'
#' @keywords internal
#'
#' @rdname finspacedata_list_users_by_permission_group
finspacedata_list_users_by_permission_group <- function(permissionGroupId, nextToken = NULL, maxResults) {
  op <- new_operation(
    name = "ListUsersByPermissionGroup",
    http_method = "GET",
    http_path = "/permission-group/{permissionGroupId}/users",
    paginator = list()
  )
  input <- .finspacedata$list_users_by_permission_group_input(permissionGroupId = permissionGroupId, nextToken = nextToken, maxResults = maxResults)
  output <- .finspacedata$list_users_by_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$list_users_by_permission_group <- finspacedata_list_users_by_permission_group

#' Resets the password for a specified user ID and generates a temporary
#' one
#'
#' @description
#' Resets the password for a specified user ID and generates a temporary one. Only a superuser can reset password for other users. Resetting the password immediately invalidates the previous password associated with the user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_reset_user_password/](https://www.paws-r-sdk.com/docs/finspacedata_reset_user_password/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier of the user that a temporary password is requested
#' for.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_reset_user_password
finspacedata_reset_user_password <- function(userId, clientToken = NULL) {
  op <- new_operation(
    name = "ResetUserPassword",
    http_method = "POST",
    http_path = "/user/{userId}/password",
    paginator = list()
  )
  input <- .finspacedata$reset_user_password_input(userId = userId, clientToken = clientToken)
  output <- .finspacedata$reset_user_password_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$reset_user_password <- finspacedata_reset_user_password

#' Updates a FinSpace Changeset
#'
#' @description
#' Updates a FinSpace Changeset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_update_changeset/](https://www.paws-r-sdk.com/docs/finspacedata_update_changeset/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetId &#91;required&#93; The unique identifier for the FinSpace Dataset in which the Changeset is
#' created.
#' @param changesetId &#91;required&#93; The unique identifier for the Changeset to update.
#' @param sourceParams &#91;required&#93; Options that define the location of the data being ingested
#' (`s3SourcePath`) and the source of the changeset (`sourceType`).
#' 
#' Both `s3SourcePath` and `sourceType` are required attributes.
#' 
#' Here is an example of how you could specify the `sourceParams`:
#' 
#' ` "sourceParams": { "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" } `
#' 
#' The S3 path that you specify must allow the FinSpace role access. To do
#' that, you first need to configure the IAM policy on S3 bucket. For more
#' information, see [Loading data from an Amazon S3 Bucket using the
#' FinSpace
#' API](https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets)section.
#' @param formatParams &#91;required&#93; Options that define the structure of the source file(s) including the
#' format type (`formatType`), header row (`withHeader`), data separation
#' character (`separator`) and the type of compression (`compression`).
#' 
#' `formatType` is a required attribute and can have the following values:
#' 
#' -   `PARQUET` – Parquet source file format.
#' 
#' -   `CSV` – CSV source file format.
#' 
#' -   `JSON` – JSON source file format.
#' 
#' -   `XML` – XML source file format.
#' 
#' Here is an example of how you could specify the `formatParams`:
#' 
#' ` "formatParams": { "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" } `
#' 
#' Note that if you only provide `formatType` as `CSV`, the rest of the
#' attributes will automatically default to CSV values as following:
#' 
#' ` { "withHeader": "true", "separator": "," } `
#' 
#' For more information about supported file formats, see [Supported Data
#' Types and File
#' Formats](https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html)
#' in the FinSpace User Guide.
#'
#' @keywords internal
#'
#' @rdname finspacedata_update_changeset
finspacedata_update_changeset <- function(clientToken = NULL, datasetId, changesetId, sourceParams, formatParams) {
  op <- new_operation(
    name = "UpdateChangeset",
    http_method = "PUT",
    http_path = "/datasets/{datasetId}/changesetsv2/{changesetId}",
    paginator = list()
  )
  input <- .finspacedata$update_changeset_input(clientToken = clientToken, datasetId = datasetId, changesetId = changesetId, sourceParams = sourceParams, formatParams = formatParams)
  output <- .finspacedata$update_changeset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$update_changeset <- finspacedata_update_changeset

#' Updates a FinSpace Dataset
#'
#' @description
#' Updates a FinSpace Dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_update_dataset/](https://www.paws-r-sdk.com/docs/finspacedata_update_dataset/) for full documentation.
#'
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#' @param datasetId &#91;required&#93; The unique identifier for the Dataset to update.
#' @param datasetTitle &#91;required&#93; A display title for the Dataset.
#' @param kind &#91;required&#93; The format in which the Dataset data is structured.
#' 
#' -   `TABULAR` – Data is structured in a tabular format.
#' 
#' -   `NON_TABULAR` – Data is structured in a non-tabular format.
#' @param datasetDescription A description for the Dataset.
#' @param alias The unique resource identifier for a Dataset.
#' @param schemaDefinition Definition for a schema on a tabular Dataset.
#'
#' @keywords internal
#'
#' @rdname finspacedata_update_dataset
finspacedata_update_dataset <- function(clientToken = NULL, datasetId, datasetTitle, kind, datasetDescription = NULL, alias = NULL, schemaDefinition = NULL) {
  op <- new_operation(
    name = "UpdateDataset",
    http_method = "PUT",
    http_path = "/datasetsv2/{datasetId}",
    paginator = list()
  )
  input <- .finspacedata$update_dataset_input(clientToken = clientToken, datasetId = datasetId, datasetTitle = datasetTitle, kind = kind, datasetDescription = datasetDescription, alias = alias, schemaDefinition = schemaDefinition)
  output <- .finspacedata$update_dataset_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$update_dataset <- finspacedata_update_dataset

#' Modifies the details of a permission group
#'
#' @description
#' Modifies the details of a permission group. You cannot modify a `permissionGroupID`.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_update_permission_group/](https://www.paws-r-sdk.com/docs/finspacedata_update_permission_group/) for full documentation.
#'
#' @param permissionGroupId &#91;required&#93; The unique identifier for the permission group to update.
#' @param name The name of the permission group.
#' @param description A brief description for the permission group.
#' @param applicationPermissions The permissions that are granted to a specific group for accessing the
#' FinSpace application.
#' 
#' When assigning application permissions, be aware that the permission
#' `ManageUsersAndGroups` allows users to grant themselves or others access
#' to any functionality in their FinSpace environment's application. It
#' should only be granted to trusted users.
#' 
#' -   [`create_dataset`][finspacedata_create_dataset] – Group members can
#'     create new datasets.
#' 
#' -   `ManageClusters` – Group members can manage Apache Spark clusters
#'     from FinSpace notebooks.
#' 
#' -   `ManageUsersAndGroups` – Group members can manage users and
#'     permission groups. This is a privileged permission that allows users
#'     to grant themselves or others access to any functionality in the
#'     application. It should only be granted to trusted users.
#' 
#' -   `ManageAttributeSets` – Group members can manage attribute sets.
#' 
#' -   `ViewAuditData` – Group members can view audit data.
#' 
#' -   `AccessNotebooks` – Group members will have access to FinSpace
#'     notebooks.
#' 
#' -   `GetTemporaryCredentials` – Group members can get temporary API
#'     credentials.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_update_permission_group
finspacedata_update_permission_group <- function(permissionGroupId, name = NULL, description = NULL, applicationPermissions = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdatePermissionGroup",
    http_method = "PUT",
    http_path = "/permission-group/{permissionGroupId}",
    paginator = list()
  )
  input <- .finspacedata$update_permission_group_input(permissionGroupId = permissionGroupId, name = name, description = description, applicationPermissions = applicationPermissions, clientToken = clientToken)
  output <- .finspacedata$update_permission_group_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$update_permission_group <- finspacedata_update_permission_group

#' Modifies the details of the specified user account
#'
#' @description
#' Modifies the details of the specified user account. You cannot update the `userId` for a user.
#'
#' See [https://www.paws-r-sdk.com/docs/finspacedata_update_user/](https://www.paws-r-sdk.com/docs/finspacedata_update_user/) for full documentation.
#'
#' @param userId &#91;required&#93; The unique identifier for the user account to update.
#' @param type The option to indicate the type of user.
#' 
#' -   `SUPER_USER`– A user with permission to all the functionality and
#'     data in FinSpace.
#' 
#' -   `APP_USER` – A user with specific permissions in FinSpace. The users
#'     are assigned permissions by adding them to a permission group.
#' @param firstName The first name of the user.
#' @param lastName The last name of the user.
#' @param apiAccess The option to indicate whether the user can use the
#' [`get_programmatic_access_credentials`][finspacedata_get_programmatic_access_credentials]
#' API to obtain credentials that can then be used to access other FinSpace
#' Data API operations.
#' 
#' -   `ENABLED` – The user has permissions to use the APIs.
#' 
#' -   `DISABLED` – The user does not have permissions to use any APIs.
#' @param apiAccessPrincipalArn The ARN identifier of an AWS user or role that is allowed to call the
#' [`get_programmatic_access_credentials`][finspacedata_get_programmatic_access_credentials]
#' API to obtain a credentials token for a specific FinSpace user. This
#' must be an IAM role within your FinSpace account.
#' @param clientToken A token that ensures idempotency. This token expires in 10 minutes.
#'
#' @keywords internal
#'
#' @rdname finspacedata_update_user
finspacedata_update_user <- function(userId, type = NULL, firstName = NULL, lastName = NULL, apiAccess = NULL, apiAccessPrincipalArn = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PUT",
    http_path = "/user/{userId}",
    paginator = list()
  )
  input <- .finspacedata$update_user_input(userId = userId, type = type, firstName = firstName, lastName = lastName, apiAccess = apiAccess, apiAccessPrincipalArn = apiAccessPrincipalArn, clientToken = clientToken)
  output <- .finspacedata$update_user_output()
  config <- get_config()
  svc <- .finspacedata$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.finspacedata$operations$update_user <- finspacedata_update_user
