% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recyclebin_service.R
\name{recyclebin}
\alias{recyclebin}
\title{Amazon Recycle Bin}
\usage{
recyclebin(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This is the \emph{Recycle Bin API Reference}. This documentation provides
descriptions and syntax for each of the actions and data types in
Recycle Bin.

Recycle Bin is a resource recovery feature that enables you to restore
accidentally deleted snapshots and EBS-backed AMIs. When using Recycle
Bin, if your resources are deleted, they are retained in the Recycle Bin
for a time period that you specify.

You can restore a resource from the Recycle Bin at any time before its
retention period expires. After you restore a resource from the Recycle
Bin, the resource is removed from the Recycle Bin, and you can then use
it in the same way you use any other resource of that type in your
account. If the retention period expires and the resource is not
restored, the resource is permanently deleted from the Recycle Bin and
is no longer available for recovery. For more information about Recycle
Bin, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/}{Recycle Bin} in the
\emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- recyclebin(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=recyclebin_create_rule]{create_rule} \tab Creates a Recycle Bin retention rule\cr
\link[=recyclebin_delete_rule]{delete_rule} \tab Deletes a Recycle Bin retention rule\cr
\link[=recyclebin_get_rule]{get_rule} \tab Gets information about a Recycle Bin retention rule\cr
\link[=recyclebin_list_rules]{list_rules} \tab Lists the Recycle Bin retention rules in the Region\cr
\link[=recyclebin_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags assigned to a retention rule\cr
\link[=recyclebin_tag_resource]{tag_resource} \tab Assigns tags to the specified retention rule\cr
\link[=recyclebin_untag_resource]{untag_resource} \tab Unassigns a tag from a retention rule\cr
\link[=recyclebin_update_rule]{update_rule} \tab Updates an existing Recycle Bin retention rule
}
}

\examples{
\dontrun{
svc <- recyclebin()
svc$create_rule(
  Foo = 123
)
}

}
