% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_upload_multipart_part}
\alias{glacier_upload_multipart_part}
\title{This operation uploads a part of an archive}
\usage{
glacier_upload_multipart_part(
  accountId,
  vaultName,
  uploadId,
  checksum = NULL,
  range = NULL,
  body = NULL
)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{uploadId}{[required] The upload ID of the multipart upload.}

\item{checksum}{The SHA256 tree hash of the data being uploaded.}

\item{range}{Identifies the range of bytes in the assembled archive that will be
uploaded in this part. Amazon S3 Glacier uses this information to
assemble the archive in the proper sequence. The format of this header
follows RFC 2616. An example header is Content-Range:bytes 0-4194303/*.}

\item{body}{The data to upload.}
}
\description{
This operation uploads a part of an archive. You can upload archive parts in any order. You can also upload them in parallel. You can upload up to 10,000 parts for a multipart upload.

See \url{https://paws-r.github.io/docs/glacier/upload_multipart_part.html} for full documentation.
}
\keyword{internal}
