% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_lock_configuration}
\alias{s3_put_object_lock_configuration}
\title{Places an Object Lock configuration on the specified bucket}
\usage{
s3_put_object_lock_configuration(Bucket, ObjectLockConfiguration,
  RequestPayer, Token, ContentMD5)
}
\arguments{
\item{Bucket}{[required] The bucket whose Object Lock configuration you want to create or
replace.}

\item{ObjectLockConfiguration}{The Object Lock configuration that you want to apply to the specified
bucket.}

\item{RequestPayer}{}

\item{Token}{A token to allow Object Lock to be enabled for an existing bucket.}

\item{ContentMD5}{The MD5 hash for the request body.}
}
\description{
Places an Object Lock configuration on the specified bucket. The rule
specified in the Object Lock configuration will be applied by default to
every new object placed in the specified bucket.
}
\details{
\code{DefaultRetention} requires either Days or Years. You can\'t specify
both at the same time.

\strong{Related Resources}
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lock.html}{Locking Objects}
}
}
\section{Request syntax}{
\preformatted{svc$put_object_lock_configuration(
  Bucket = "string",
  ObjectLockConfiguration = list(
    ObjectLockEnabled = "Enabled",
    Rule = list(
      DefaultRetention = list(
        Mode = "GOVERNANCE"|"COMPLIANCE",
        Days = 123,
        Years = 123
      )
    )
  ),
  RequestPayer = "requester",
  Token = "string",
  ContentMD5 = "string"
)
}
}

\keyword{internal}
