% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_object_tagging}
\alias{s3_delete_object_tagging}
\title{Removes the tag-set from an existing object}
\usage{
s3_delete_object_tagging(Bucket, Key, VersionId)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{VersionId}{The versionId of the object that the tag-set will be removed from.}
}
\description{
Removes the tag-set from an existing object.
}
\section{Request syntax}{
\preformatted{svc$delete_object_tagging(
  Bucket = "string",
  Key = "string",
  VersionId = "string"
)
}
}

\examples{
# The following example removes tag set associated with the specified
# object. If the bucket is versioning enabled, the operation removes tag
# set from the latest object version.
\donttest{svc$delete_object_tagging(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)}

# The following example removes tag set associated with the specified
# object version. The request specifies both the object key and object
# version.
\donttest{svc$delete_object_tagging(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  VersionId = "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI"
)}

}
\keyword{internal}
