# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include s3_service.R
NULL

#' Aborts a multipart upload
#'
#' Aborts a multipart upload.
#' 
#' To verify that all parts have been removed, so you don\'t get charged
#' for the part storage, you should call the List Parts operation and
#' ensure the parts list is empty.
#'
#' @usage
#' s3_abort_multipart_upload(Bucket, Key, UploadId, RequestPayer)
#'
#' @param Bucket &#91;required&#93; Name of the bucket to which the multipart upload was initiated.
#' @param Key &#91;required&#93; Key of the object for which the multipart upload was initiated.
#' @param UploadId &#91;required&#93; Upload ID that identifies the multipart upload.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$abort_multipart_upload(
#'   Bucket = "string",
#'   Key = "string",
#'   UploadId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example aborts a multipart upload.
#' \donttest{svc$abort_multipart_upload(
#'   Bucket = "examplebucket",
#'   Key = "bigobject",
#'   UploadId = "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_abort_multipart_upload
s3_abort_multipart_upload <- function(Bucket, Key, UploadId, RequestPayer = NULL) {
  op <- new_operation(
    name = "AbortMultipartUpload",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$abort_multipart_upload_input(Bucket = Bucket, Key = Key, UploadId = UploadId, RequestPayer = RequestPayer)
  output <- .s3$abort_multipart_upload_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$abort_multipart_upload <- s3_abort_multipart_upload

#' Completes a multipart upload by assembling previously uploaded parts
#'
#' Completes a multipart upload by assembling previously uploaded parts.
#'
#' @usage
#' s3_complete_multipart_upload(Bucket, Key, MultipartUpload, UploadId,
#'   RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param MultipartUpload 
#' @param UploadId &#91;required&#93; 
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$complete_multipart_upload(
#'   Bucket = "string",
#'   Key = "string",
#'   MultipartUpload = list(
#'     Parts = list(
#'       list(
#'         ETag = "string",
#'         PartNumber = 123
#'       )
#'     )
#'   ),
#'   UploadId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example completes a multipart upload.
#' \donttest{svc$complete_multipart_upload(
#'   Bucket = "examplebucket",
#'   Key = "bigobject",
#'   MultipartUpload = list(
#'     Parts = list(
#'       list(
#'         ETag = "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
#'         PartNumber = "1"
#'       ),
#'       list(
#'         ETag = "\"d8c2eafd90c266e19ab9dcacc479f8af\"",
#'         PartNumber = "2"
#'       )
#'     )
#'   ),
#'   UploadId = "7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP3WA60CE..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_complete_multipart_upload
s3_complete_multipart_upload <- function(Bucket, Key, MultipartUpload = NULL, UploadId, RequestPayer = NULL) {
  op <- new_operation(
    name = "CompleteMultipartUpload",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$complete_multipart_upload_input(Bucket = Bucket, Key = Key, MultipartUpload = MultipartUpload, UploadId = UploadId, RequestPayer = RequestPayer)
  output <- .s3$complete_multipart_upload_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$complete_multipart_upload <- s3_complete_multipart_upload

#' Creates a copy of an object that is already stored in Amazon S3
#'
#' Creates a copy of an object that is already stored in Amazon S3.
#'
#' @usage
#' s3_copy_object(ACL, Bucket, CacheControl, ContentDisposition,
#'   ContentEncoding, ContentLanguage, ContentType, CopySource,
#'   CopySourceIfMatch, CopySourceIfModifiedSince, CopySourceIfNoneMatch,
#'   CopySourceIfUnmodifiedSince, Expires, GrantFullControl, GrantRead,
#'   GrantReadACP, GrantWriteACP, Key, Metadata, MetadataDirective,
#'   TaggingDirective, ServerSideEncryption, StorageClass,
#'   WebsiteRedirectLocation, SSECustomerAlgorithm, SSECustomerKey,
#'   SSECustomerKeyMD5, SSEKMSKeyId, SSEKMSEncryptionContext,
#'   CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey,
#'   CopySourceSSECustomerKeyMD5, RequestPayer, Tagging, ObjectLockMode,
#'   ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus)
#'
#' @param ACL The canned ACL to apply to the object.
#' @param Bucket &#91;required&#93; 
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param CopySource &#91;required&#93; The name of the source bucket and key name of the source object,
#' separated by a slash (/). Must be URL-encoded.
#' @param CopySourceIfMatch Copies the object if its entity tag (ETag) matches the specified tag.
#' @param CopySourceIfModifiedSince Copies the object if it has been modified since the specified time.
#' @param CopySourceIfNoneMatch Copies the object if its entity tag (ETag) is different than the
#' specified ETag.
#' @param CopySourceIfUnmodifiedSince Copies the object if it hasn\'t been modified since the specified time.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param GrantFullControl Gives the grantee READ, READ\\_ACP, and WRITE\\_ACP permissions on the
#' object.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' @param Key &#91;required&#93; 
#' @param Metadata A map of metadata to store with the object in S3.
#' @param MetadataDirective Specifies whether the metadata is copied from the source object or
#' replaced with metadata provided in the request.
#' @param TaggingDirective Specifies whether the object tag-set are copied from the source object
#' or replaced with tag-set provided in the request.
#' @param ServerSideEncryption The Server-side encryption algorithm used when storing this object in S3
#' (e.g., AES256, aws:kms).
#' @param StorageClass The type of storage to use for the object. Defaults to \'STANDARD\'.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param SSEKMSKeyId Specifies the AWS KMS key ID to use for object encryption. All GET and
#' PUT requests for an object protected by AWS KMS will fail if not made
#' via SSL or using SigV4. Documentation on configuring any of the
#' officially supported AWS SDKs and CLI can be found at
#' http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\\#specify-signature-version
#' @param SSEKMSEncryptionContext Specifies the AWS KMS Encryption Context to use for object encryption.
#' The value of this header is a base64-encoded UTF-8 string holding JSON
#' with the encryption context key-value pairs.
#' @param CopySourceSSECustomerAlgorithm Specifies the algorithm to use when decrypting the source object (e.g.,
#' AES256).
#' @param CopySourceSSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use to
#' decrypt the source object. The encryption key provided in this header
#' must be one that was used when the source object was created.
#' @param CopySourceSSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object destination object this value must be used in
#' conjunction with the TaggingDirective. The tag-set must be encoded as
#' URL Query parameters
#' @param ObjectLockMode The object lock mode that you want to apply to the copied object.
#' @param ObjectLockRetainUntilDate The date and time when you want the copied object\'s object lock to
#' expire.
#' @param ObjectLockLegalHoldStatus Specifies whether you want to apply a Legal Hold to the copied object.
#'
#' @section Request syntax:
#' ```
#' svc$copy_object(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'   Bucket = "string",
#'   CacheControl = "string",
#'   ContentDisposition = "string",
#'   ContentEncoding = "string",
#'   ContentLanguage = "string",
#'   ContentType = "string",
#'   CopySource = "string",
#'   CopySourceIfMatch = "string",
#'   CopySourceIfModifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CopySourceIfNoneMatch = "string",
#'   CopySourceIfUnmodifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Expires = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWriteACP = "string",
#'   Key = "string",
#'   Metadata = list(
#'     "string"
#'   ),
#'   MetadataDirective = "COPY"|"REPLACE",
#'   TaggingDirective = "COPY"|"REPLACE",
#'   ServerSideEncryption = "AES256"|"aws:kms",
#'   StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
#'   WebsiteRedirectLocation = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   SSEKMSKeyId = "string",
#'   SSEKMSEncryptionContext = "string",
#'   CopySourceSSECustomerAlgorithm = "string",
#'   CopySourceSSECustomerKey = raw,
#'   CopySourceSSECustomerKeyMD5 = "string",
#'   RequestPayer = "requester",
#'   Tagging = "string",
#'   ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
#'   ObjectLockRetainUntilDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ObjectLockLegalHoldStatus = "ON"|"OFF"
#' )
#' ```
#'
#' @examples
#' # The following example copies an object from one bucket to another.
#' \donttest{svc$copy_object(
#'   Bucket = "destinationbucket",
#'   CopySource = "/sourcebucket/HappyFacejpg",
#'   Key = "HappyFaceCopyjpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_copy_object
s3_copy_object <- function(ACL = NULL, Bucket, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentType = NULL, CopySource, CopySourceIfMatch = NULL, CopySourceIfModifiedSince = NULL, CopySourceIfNoneMatch = NULL, CopySourceIfUnmodifiedSince = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, MetadataDirective = NULL, TaggingDirective = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, CopySourceSSECustomerAlgorithm = NULL, CopySourceSSECustomerKey = NULL, CopySourceSSECustomerKeyMD5 = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL) {
  op <- new_operation(
    name = "CopyObject",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$copy_object_input(ACL = ACL, Bucket = Bucket, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentType = ContentType, CopySource = CopySource, CopySourceIfMatch = CopySourceIfMatch, CopySourceIfModifiedSince = CopySourceIfModifiedSince, CopySourceIfNoneMatch = CopySourceIfNoneMatch, CopySourceIfUnmodifiedSince = CopySourceIfUnmodifiedSince, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, MetadataDirective = MetadataDirective, TaggingDirective = TaggingDirective, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, CopySourceSSECustomerAlgorithm = CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey = CopySourceSSECustomerKey, CopySourceSSECustomerKeyMD5 = CopySourceSSECustomerKeyMD5, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus)
  output <- .s3$copy_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$copy_object <- s3_copy_object

#' Creates a new bucket
#'
#' Creates a new bucket.
#'
#' @usage
#' s3_create_bucket(ACL, Bucket, CreateBucketConfiguration,
#'   GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
#'   ObjectLockEnabledForBucket)
#'
#' @param ACL The canned ACL to apply to the bucket.
#' @param Bucket &#91;required&#93; 
#' @param CreateBucketConfiguration 
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' @param GrantWrite Allows grantee to create, overwrite, and delete any object in the
#' bucket.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' @param ObjectLockEnabledForBucket Specifies whether you want Amazon S3 object lock to be enabled for the
#' new bucket.
#'
#' @section Request syntax:
#' ```
#' svc$create_bucket(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read",
#'   Bucket = "string",
#'   CreateBucketConfiguration = list(
#'     LocationConstraint = "EU"|"eu-west-1"|"us-west-1"|"us-west-2"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"|"cn-north-1"|"eu-central-1"
#'   ),
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWrite = "string",
#'   GrantWriteACP = "string",
#'   ObjectLockEnabledForBucket = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example creates a bucket. The request specifies an AWS
#' # region where to create the bucket.
#' \donttest{svc$create_bucket(
#'   Bucket = "examplebucket",
#'   CreateBucketConfiguration = list(
#'     LocationConstraint = "eu-west-1"
#'   )
#' )}
#' 
#' # The following example creates a bucket.
#' \donttest{svc$create_bucket(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_create_bucket
s3_create_bucket <- function(ACL = NULL, Bucket, CreateBucketConfiguration = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, ObjectLockEnabledForBucket = NULL) {
  op <- new_operation(
    name = "CreateBucket",
    http_method = "PUT",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$create_bucket_input(ACL = ACL, Bucket = Bucket, CreateBucketConfiguration = CreateBucketConfiguration, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, ObjectLockEnabledForBucket = ObjectLockEnabledForBucket)
  output <- .s3$create_bucket_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$create_bucket <- s3_create_bucket

#' Initiates a multipart upload and returns an upload ID
#'
#' Initiates a multipart upload and returns an upload ID.
#' 
#' **Note:** After you initiate multipart upload and upload one or more
#' parts, you must either complete or abort multipart upload in order to
#' stop getting charged for storage of the uploaded parts. Only after you
#' either complete or abort multipart upload, Amazon S3 frees up the parts
#' storage and stops charging you for the parts storage.
#'
#' @usage
#' s3_create_multipart_upload(ACL, Bucket, CacheControl,
#'   ContentDisposition, ContentEncoding, ContentLanguage, ContentType,
#'   Expires, GrantFullControl, GrantRead, GrantReadACP, GrantWriteACP, Key,
#'   Metadata, ServerSideEncryption, StorageClass, WebsiteRedirectLocation,
#'   SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5, SSEKMSKeyId,
#'   SSEKMSEncryptionContext, RequestPayer, Tagging, ObjectLockMode,
#'   ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus)
#'
#' @param ACL The canned ACL to apply to the object.
#' @param Bucket &#91;required&#93; 
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param GrantFullControl Gives the grantee READ, READ\\_ACP, and WRITE\\_ACP permissions on the
#' object.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' @param Key &#91;required&#93; 
#' @param Metadata A map of metadata to store with the object in S3.
#' @param ServerSideEncryption The Server-side encryption algorithm used when storing this object in S3
#' (e.g., AES256, aws:kms).
#' @param StorageClass The type of storage to use for the object. Defaults to \'STANDARD\'.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param SSEKMSKeyId Specifies the AWS KMS key ID to use for object encryption. All GET and
#' PUT requests for an object protected by AWS KMS will fail if not made
#' via SSL or using SigV4. Documentation on configuring any of the
#' officially supported AWS SDKs and CLI can be found at
#' http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\\#specify-signature-version
#' @param SSEKMSEncryptionContext Specifies the AWS KMS Encryption Context to use for object encryption.
#' The value of this header is a base64-encoded UTF-8 string holding JSON
#' with the encryption context key-value pairs.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object. The tag-set must be encoded as URL Query
#' parameters
#' @param ObjectLockMode Specifies the object lock mode that you want to apply to the uploaded
#' object.
#' @param ObjectLockRetainUntilDate Specifies the date and time when you want the object lock to expire.
#' @param ObjectLockLegalHoldStatus Specifies whether you want to apply a Legal Hold to the uploaded object.
#'
#' @section Request syntax:
#' ```
#' svc$create_multipart_upload(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'   Bucket = "string",
#'   CacheControl = "string",
#'   ContentDisposition = "string",
#'   ContentEncoding = "string",
#'   ContentLanguage = "string",
#'   ContentType = "string",
#'   Expires = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWriteACP = "string",
#'   Key = "string",
#'   Metadata = list(
#'     "string"
#'   ),
#'   ServerSideEncryption = "AES256"|"aws:kms",
#'   StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
#'   WebsiteRedirectLocation = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   SSEKMSKeyId = "string",
#'   SSEKMSEncryptionContext = "string",
#'   RequestPayer = "requester",
#'   Tagging = "string",
#'   ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
#'   ObjectLockRetainUntilDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ObjectLockLegalHoldStatus = "ON"|"OFF"
#' )
#' ```
#'
#' @examples
#' # The following example initiates a multipart upload.
#' \donttest{svc$create_multipart_upload(
#'   Bucket = "examplebucket",
#'   Key = "largeobject"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_create_multipart_upload
s3_create_multipart_upload <- function(ACL = NULL, Bucket, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentType = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL) {
  op <- new_operation(
    name = "CreateMultipartUpload",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?uploads",
    paginator = list()
  )
  input <- .s3$create_multipart_upload_input(ACL = ACL, Bucket = Bucket, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentType = ContentType, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus)
  output <- .s3$create_multipart_upload_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$create_multipart_upload <- s3_create_multipart_upload

#' Deletes the bucket
#'
#' Deletes the bucket. All objects (including all object versions and
#' Delete Markers) in the bucket must be deleted before the bucket itself
#' can be deleted.
#'
#' @usage
#' s3_delete_bucket(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes the specified bucket.
#' \donttest{svc$delete_bucket(
#'   Bucket = "forrandall2"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket
s3_delete_bucket <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucket",
    http_method = "DELETE",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$delete_bucket_input(Bucket = Bucket)
  output <- .s3$delete_bucket_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket <- s3_delete_bucket

#' Deletes an analytics configuration for the bucket (specified by the
#' analytics configuration ID)
#'
#' Deletes an analytics configuration for the bucket (specified by the
#' analytics configuration ID).
#' 
#' To use this operation, you must have permissions to perform the
#' s3:PutAnalyticsConfiguration action. The bucket owner has this
#' permission by default. The bucket owner can grant this permission to
#' others.
#'
#' @usage
#' s3_delete_bucket_analytics_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which an analytics configuration is deleted.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_analytics_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_analytics_configuration
s3_delete_bucket_analytics_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "DeleteBucketAnalyticsConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$delete_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$delete_bucket_analytics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_analytics_configuration <- s3_delete_bucket_analytics_configuration

#' Deletes the CORS configuration information set for the bucket
#'
#' Deletes the CORS configuration information set for the bucket.
#'
#' @usage
#' s3_delete_bucket_cors(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_cors(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes CORS configuration on a bucket.
#' \donttest{svc$delete_bucket_cors(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_cors
s3_delete_bucket_cors <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketCors",
    http_method = "DELETE",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$delete_bucket_cors_input(Bucket = Bucket)
  output <- .s3$delete_bucket_cors_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_cors <- s3_delete_bucket_cors

#' Deletes the server-side encryption configuration from the bucket
#'
#' Deletes the server-side encryption configuration from the bucket.
#'
#' @usage
#' s3_delete_bucket_encryption(Bucket)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the server-side encryption
#' configuration to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_encryption(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_encryption
s3_delete_bucket_encryption <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketEncryption",
    http_method = "DELETE",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$delete_bucket_encryption_input(Bucket = Bucket)
  output <- .s3$delete_bucket_encryption_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_encryption <- s3_delete_bucket_encryption

#' Deletes an inventory configuration (identified by the inventory ID) from
#' the bucket
#'
#' Deletes an inventory configuration (identified by the inventory ID) from
#' the bucket.
#'
#' @usage
#' s3_delete_bucket_inventory_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configuration to delete.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_inventory_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_inventory_configuration
s3_delete_bucket_inventory_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "DeleteBucketInventoryConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$delete_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$delete_bucket_inventory_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_inventory_configuration <- s3_delete_bucket_inventory_configuration

#' Deletes the lifecycle configuration from the bucket
#'
#' Deletes the lifecycle configuration from the bucket.
#'
#' @usage
#' s3_delete_bucket_lifecycle(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_lifecycle(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes lifecycle configuration on a bucket.
#' \donttest{svc$delete_bucket_lifecycle(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_lifecycle
s3_delete_bucket_lifecycle <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketLifecycle",
    http_method = "DELETE",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$delete_bucket_lifecycle_input(Bucket = Bucket)
  output <- .s3$delete_bucket_lifecycle_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_lifecycle <- s3_delete_bucket_lifecycle

#' Deletes a metrics configuration (specified by the metrics configuration
#' ID) from the bucket
#'
#' Deletes a metrics configuration (specified by the metrics configuration
#' ID) from the bucket.
#'
#' @usage
#' s3_delete_bucket_metrics_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configuration to delete.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_metrics_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_metrics_configuration
s3_delete_bucket_metrics_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "DeleteBucketMetricsConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$delete_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$delete_bucket_metrics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_metrics_configuration <- s3_delete_bucket_metrics_configuration

#' Deletes the policy from the bucket
#'
#' Deletes the policy from the bucket.
#'
#' @usage
#' s3_delete_bucket_policy(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_policy(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes bucket policy on the specified bucket.
#' \donttest{svc$delete_bucket_policy(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_policy
s3_delete_bucket_policy <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketPolicy",
    http_method = "DELETE",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$delete_bucket_policy_input(Bucket = Bucket)
  output <- .s3$delete_bucket_policy_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_policy <- s3_delete_bucket_policy

#' Deletes the replication configuration from the bucket
#'
#' Deletes the replication configuration from the bucket. For information
#' about replication configuration, see [Cross-Region Replication
#' (CRR)](https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html) in the
#' *Amazon S3 Developer Guide*.
#'
#' @usage
#' s3_delete_bucket_replication(Bucket)
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' 
#' It can take a while to propagate the deletion of a replication
#' configuration to all Amazon S3 systems.
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_replication(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes replication configuration set on bucket.
#' \donttest{svc$delete_bucket_replication(
#'   Bucket = "example"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_replication
s3_delete_bucket_replication <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketReplication",
    http_method = "DELETE",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$delete_bucket_replication_input(Bucket = Bucket)
  output <- .s3$delete_bucket_replication_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_replication <- s3_delete_bucket_replication

#' Deletes the tags from the bucket
#'
#' Deletes the tags from the bucket.
#'
#' @usage
#' s3_delete_bucket_tagging(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_tagging(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes bucket tags.
#' \donttest{svc$delete_bucket_tagging(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_tagging
s3_delete_bucket_tagging <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketTagging",
    http_method = "DELETE",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$delete_bucket_tagging_input(Bucket = Bucket)
  output <- .s3$delete_bucket_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_tagging <- s3_delete_bucket_tagging

#' This operation removes the website configuration from the bucket
#'
#' This operation removes the website configuration from the bucket.
#'
#' @usage
#' s3_delete_bucket_website(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$delete_bucket_website(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes bucket website configuration.
#' \donttest{svc$delete_bucket_website(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_website
s3_delete_bucket_website <- function(Bucket) {
  op <- new_operation(
    name = "DeleteBucketWebsite",
    http_method = "DELETE",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$delete_bucket_website_input(Bucket = Bucket)
  output <- .s3$delete_bucket_website_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_website <- s3_delete_bucket_website

#' Removes the null version (if there is one) of an object and inserts a
#' delete marker, which becomes the latest version of the object
#'
#' Removes the null version (if there is one) of an object and inserts a
#' delete marker, which becomes the latest version of the object. If there
#' isn\'t a null version, Amazon S3 does not remove any objects.
#'
#' @usage
#' s3_delete_object(Bucket, Key, MFA, VersionId, RequestPayer,
#'   BypassGovernanceRetention)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param MFA The concatenation of the authentication device\'s serial number, a
#' space, and the value that is displayed on your authentication device.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param RequestPayer 
#' @param BypassGovernanceRetention Indicates whether Amazon S3 object lock should bypass governance-mode
#' restrictions to process this operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_object(
#'   Bucket = "string",
#'   Key = "string",
#'   MFA = "string",
#'   VersionId = "string",
#'   RequestPayer = "requester",
#'   BypassGovernanceRetention = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example deletes an object from a non-versioned bucket.
#' \donttest{svc$delete_object(
#'   Bucket = "ExampleBucket",
#'   Key = "HappyFace.jpg"
#' )}
#' 
#' # The following example deletes an object from an S3 bucket.
#' \donttest{svc$delete_object(
#'   Bucket = "examplebucket",
#'   Key = "objectkey.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_object
s3_delete_object <- function(Bucket, Key, MFA = NULL, VersionId = NULL, RequestPayer = NULL, BypassGovernanceRetention = NULL) {
  op <- new_operation(
    name = "DeleteObject",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$delete_object_input(Bucket = Bucket, Key = Key, MFA = MFA, VersionId = VersionId, RequestPayer = RequestPayer, BypassGovernanceRetention = BypassGovernanceRetention)
  output <- .s3$delete_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_object <- s3_delete_object

#' Removes the tag-set from an existing object
#'
#' Removes the tag-set from an existing object.
#'
#' @usage
#' s3_delete_object_tagging(Bucket, Key, VersionId)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param VersionId The versionId of the object that the tag-set will be removed from.
#'
#' @section Request syntax:
#' ```
#' svc$delete_object_tagging(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example removes tag set associated with the specified
#' # object. If the bucket is versioning enabled, the operation removes tag
#' # set from the latest object version.
#' \donttest{svc$delete_object_tagging(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#' 
#' # The following example removes tag set associated with the specified
#' # object version. The request specifies both the object key and object
#' # version.
#' \donttest{svc$delete_object_tagging(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg",
#'   VersionId = "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_object_tagging
s3_delete_object_tagging <- function(Bucket, Key, VersionId = NULL) {
  op <- new_operation(
    name = "DeleteObjectTagging",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$delete_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId)
  output <- .s3$delete_object_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_object_tagging <- s3_delete_object_tagging

#' This operation enables you to delete multiple objects from a bucket
#' using a single HTTP request
#'
#' This operation enables you to delete multiple objects from a bucket
#' using a single HTTP request. You may specify up to 1000 keys.
#'
#' @usage
#' s3_delete_objects(Bucket, Delete, MFA, RequestPayer,
#'   BypassGovernanceRetention)
#'
#' @param Bucket &#91;required&#93; 
#' @param Delete &#91;required&#93; 
#' @param MFA The concatenation of the authentication device\'s serial number, a
#' space, and the value that is displayed on your authentication device.
#' @param RequestPayer 
#' @param BypassGovernanceRetention Specifies whether you want to delete this object even if it has a
#' Governance-type object lock in place. You must have sufficient
#' permissions to perform this operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_objects(
#'   Bucket = "string",
#'   Delete = list(
#'     Objects = list(
#'       list(
#'         Key = "string",
#'         VersionId = "string"
#'       )
#'     ),
#'     Quiet = TRUE|FALSE
#'   ),
#'   MFA = "string",
#'   RequestPayer = "requester",
#'   BypassGovernanceRetention = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example deletes objects from a bucket. The request
#' # specifies object versions. S3 deletes specific object versions and
#' # returns the key and versions of deleted objects in the response.
#' \donttest{svc$delete_objects(
#'   Bucket = "examplebucket",
#'   Delete = list(
#'     Objects = list(
#'       list(
#'         Key = "HappyFace.jpg",
#'         VersionId = "2LWg7lQLnY41.maGB5Z6SWW.dcq0vx7b"
#'       ),
#'       list(
#'         Key = "HappyFace.jpg",
#'         VersionId = "yoz3HB.ZhCS_tKVEmIOr7qYyyAaZSKVd"
#'       )
#'     ),
#'     Quiet = FALSE
#'   )
#' )}
#' 
#' # The following example deletes objects from a bucket. The bucket is
#' # versioned, and the request does not specify the object version to
#' # delete. In this case, all versions remain in the bucket and S3 adds a
#' # delete marker.
#' \donttest{svc$delete_objects(
#'   Bucket = "examplebucket",
#'   Delete = list(
#'     Objects = list(
#'       list(
#'         Key = "objectkey1"
#'       ),
#'       list(
#'         Key = "objectkey2"
#'       )
#'     ),
#'     Quiet = FALSE
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_delete_objects
s3_delete_objects <- function(Bucket, Delete, MFA = NULL, RequestPayer = NULL, BypassGovernanceRetention = NULL) {
  op <- new_operation(
    name = "DeleteObjects",
    http_method = "POST",
    http_path = "/{Bucket}?delete",
    paginator = list()
  )
  input <- .s3$delete_objects_input(Bucket = Bucket, Delete = Delete, MFA = MFA, RequestPayer = RequestPayer, BypassGovernanceRetention = BypassGovernanceRetention)
  output <- .s3$delete_objects_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_objects <- s3_delete_objects

#' Removes the PublicAccessBlock configuration from an Amazon S3 bucket
#'
#' Removes the `PublicAccessBlock` configuration from an Amazon S3 bucket.
#'
#' @usage
#' s3_delete_public_access_block(Bucket)
#'
#' @param Bucket &#91;required&#93; The Amazon S3 bucket whose `PublicAccessBlock` configuration you want to
#' delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_public_access_block(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_delete_public_access_block
s3_delete_public_access_block <- function(Bucket) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$delete_public_access_block_input(Bucket = Bucket)
  output <- .s3$delete_public_access_block_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_public_access_block <- s3_delete_public_access_block

#' Returns the accelerate configuration of a bucket
#'
#' Returns the accelerate configuration of a bucket.
#'
#' @usage
#' s3_get_bucket_accelerate_configuration(Bucket)
#'
#' @param Bucket &#91;required&#93; Name of the bucket for which the accelerate configuration is retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_accelerate_configuration(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_accelerate_configuration
s3_get_bucket_accelerate_configuration <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketAccelerateConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?accelerate",
    paginator = list()
  )
  input <- .s3$get_bucket_accelerate_configuration_input(Bucket = Bucket)
  output <- .s3$get_bucket_accelerate_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_accelerate_configuration <- s3_get_bucket_accelerate_configuration

#' Gets the access control policy for the bucket
#'
#' Gets the access control policy for the bucket.
#'
#' @usage
#' s3_get_bucket_acl(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_acl(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_acl
s3_get_bucket_acl <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketAcl",
    http_method = "GET",
    http_path = "/{Bucket}?acl",
    paginator = list()
  )
  input <- .s3$get_bucket_acl_input(Bucket = Bucket)
  output <- .s3$get_bucket_acl_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_acl <- s3_get_bucket_acl

#' Gets an analytics configuration for the bucket (specified by the
#' analytics configuration ID)
#'
#' Gets an analytics configuration for the bucket (specified by the
#' analytics configuration ID).
#'
#' @usage
#' s3_get_bucket_analytics_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which an analytics configuration is
#' retrieved.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_analytics_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_analytics_configuration
s3_get_bucket_analytics_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "GetBucketAnalyticsConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$get_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$get_bucket_analytics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_analytics_configuration <- s3_get_bucket_analytics_configuration

#' Returns the CORS configuration for the bucket
#'
#' Returns the CORS configuration for the bucket.
#'
#' @usage
#' s3_get_bucket_cors(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_cors(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns cross-origin resource sharing (CORS)
#' # configuration set on a bucket.
#' \donttest{svc$get_bucket_cors(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_cors
s3_get_bucket_cors <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketCors",
    http_method = "GET",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$get_bucket_cors_input(Bucket = Bucket)
  output <- .s3$get_bucket_cors_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_cors <- s3_get_bucket_cors

#' Returns the server-side encryption configuration of a bucket
#'
#' Returns the server-side encryption configuration of a bucket.
#'
#' @usage
#' s3_get_bucket_encryption(Bucket)
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which the server-side encryption
#' configuration is retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_encryption(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_encryption
s3_get_bucket_encryption <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketEncryption",
    http_method = "GET",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$get_bucket_encryption_input(Bucket = Bucket)
  output <- .s3$get_bucket_encryption_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_encryption <- s3_get_bucket_encryption

#' Returns an inventory configuration (identified by the inventory ID) from
#' the bucket
#'
#' Returns an inventory configuration (identified by the inventory ID) from
#' the bucket.
#'
#' @usage
#' s3_get_bucket_inventory_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configuration to
#' retrieve.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_inventory_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_inventory_configuration
s3_get_bucket_inventory_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "GetBucketInventoryConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$get_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$get_bucket_inventory_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_inventory_configuration <- s3_get_bucket_inventory_configuration

#' No longer used, see the GetBucketLifecycleConfiguration operation
#'
#' No longer used, see the GetBucketLifecycleConfiguration operation.
#'
#' @usage
#' s3_get_bucket_lifecycle(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_lifecycle(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example gets ACL on the specified bucket.
#' \donttest{svc$get_bucket_lifecycle(
#'   Bucket = "acl1"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_lifecycle
s3_get_bucket_lifecycle <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketLifecycle",
    http_method = "GET",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$get_bucket_lifecycle_input(Bucket = Bucket)
  output <- .s3$get_bucket_lifecycle_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_lifecycle <- s3_get_bucket_lifecycle

#' Returns the lifecycle configuration information set on the bucket
#'
#' Returns the lifecycle configuration information set on the bucket.
#'
#' @usage
#' s3_get_bucket_lifecycle_configuration(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_lifecycle_configuration(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves lifecycle configuration on set on a
#' # bucket.
#' \donttest{svc$get_bucket_lifecycle_configuration(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_lifecycle_configuration
s3_get_bucket_lifecycle_configuration <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketLifecycleConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$get_bucket_lifecycle_configuration_input(Bucket = Bucket)
  output <- .s3$get_bucket_lifecycle_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_lifecycle_configuration <- s3_get_bucket_lifecycle_configuration

#' Returns the region the bucket resides in
#'
#' Returns the region the bucket resides in.
#'
#' @usage
#' s3_get_bucket_location(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_location(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns bucket location.
#' \donttest{svc$get_bucket_location(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_location
s3_get_bucket_location <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketLocation",
    http_method = "GET",
    http_path = "/{Bucket}?location",
    paginator = list()
  )
  input <- .s3$get_bucket_location_input(Bucket = Bucket)
  output <- .s3$get_bucket_location_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_location <- s3_get_bucket_location

#' Returns the logging status of a bucket and the permissions users have to
#' view and modify that status
#'
#' Returns the logging status of a bucket and the permissions users have to
#' view and modify that status. To use GET, you must be the bucket owner.
#'
#' @usage
#' s3_get_bucket_logging(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_logging(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_logging
s3_get_bucket_logging <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketLogging",
    http_method = "GET",
    http_path = "/{Bucket}?logging",
    paginator = list()
  )
  input <- .s3$get_bucket_logging_input(Bucket = Bucket)
  output <- .s3$get_bucket_logging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_logging <- s3_get_bucket_logging

#' Gets a metrics configuration (specified by the metrics configuration ID)
#' from the bucket
#'
#' Gets a metrics configuration (specified by the metrics configuration ID)
#' from the bucket.
#'
#' @usage
#' s3_get_bucket_metrics_configuration(Bucket, Id)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configuration to retrieve.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_metrics_configuration(
#'   Bucket = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_metrics_configuration
s3_get_bucket_metrics_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "GetBucketMetricsConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$get_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$get_bucket_metrics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_metrics_configuration <- s3_get_bucket_metrics_configuration

#' No longer used, see the GetBucketNotificationConfiguration operation
#'
#' No longer used, see the GetBucketNotificationConfiguration operation.
#'
#' @usage
#' s3_get_bucket_notification(Bucket)
#'
#' @param Bucket &#91;required&#93; Name of the bucket to get the notification configuration for.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_notification(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns notification configuration set on a
#' # bucket.
#' \donttest{svc$get_bucket_notification(
#'   Bucket = "examplebucket"
#' )}
#' 
#' # The following example returns notification configuration set on a
#' # bucket.
#' \donttest{svc$get_bucket_notification(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_notification
s3_get_bucket_notification <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketNotification",
    http_method = "GET",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$get_bucket_notification_input(Bucket = Bucket)
  output <- .s3$get_bucket_notification_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_notification <- s3_get_bucket_notification

#' Returns the notification configuration of a bucket
#'
#' Returns the notification configuration of a bucket.
#'
#' @usage
#' s3_get_bucket_notification_configuration(Bucket)
#'
#' @param Bucket &#91;required&#93; Name of the bucket to get the notification configuration for.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_notification_configuration(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_notification_configuration
s3_get_bucket_notification_configuration <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketNotificationConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$get_bucket_notification_configuration_input(Bucket = Bucket)
  output <- .s3$get_bucket_notification_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_notification_configuration <- s3_get_bucket_notification_configuration

#' Returns the policy of a specified bucket
#'
#' Returns the policy of a specified bucket.
#'
#' @usage
#' s3_get_bucket_policy(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_policy(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns bucket policy associated with a bucket.
#' \donttest{svc$get_bucket_policy(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_policy
s3_get_bucket_policy <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketPolicy",
    http_method = "GET",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$get_bucket_policy_input(Bucket = Bucket)
  output <- .s3$get_bucket_policy_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_policy <- s3_get_bucket_policy

#' Retrieves the policy status for an Amazon S3 bucket, indicating whether
#' the bucket is public
#'
#' Retrieves the policy status for an Amazon S3 bucket, indicating whether
#' the bucket is public.
#'
#' @usage
#' s3_get_bucket_policy_status(Bucket)
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose policy status you want to
#' retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_policy_status(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_policy_status
s3_get_bucket_policy_status <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketPolicyStatus",
    http_method = "GET",
    http_path = "/{Bucket}?policyStatus",
    paginator = list()
  )
  input <- .s3$get_bucket_policy_status_input(Bucket = Bucket)
  output <- .s3$get_bucket_policy_status_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_policy_status <- s3_get_bucket_policy_status

#' Returns the replication configuration of a bucket
#'
#' Returns the replication configuration of a bucket.
#' 
#' It can take a while to propagate the put or delete a replication
#' configuration to all Amazon S3 systems. Therefore, a get request soon
#' after put or delete can return a wrong result.
#'
#' @usage
#' s3_get_bucket_replication(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_replication(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns replication configuration set on a bucket.
#' \donttest{svc$get_bucket_replication(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_replication
s3_get_bucket_replication <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketReplication",
    http_method = "GET",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$get_bucket_replication_input(Bucket = Bucket)
  output <- .s3$get_bucket_replication_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_replication <- s3_get_bucket_replication

#' Returns the request payment configuration of a bucket
#'
#' Returns the request payment configuration of a bucket.
#'
#' @usage
#' s3_get_bucket_request_payment(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_request_payment(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves bucket versioning configuration.
#' \donttest{svc$get_bucket_request_payment(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_request_payment
s3_get_bucket_request_payment <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketRequestPayment",
    http_method = "GET",
    http_path = "/{Bucket}?requestPayment",
    paginator = list()
  )
  input <- .s3$get_bucket_request_payment_input(Bucket = Bucket)
  output <- .s3$get_bucket_request_payment_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_request_payment <- s3_get_bucket_request_payment

#' Returns the tag set associated with the bucket
#'
#' Returns the tag set associated with the bucket.
#'
#' @usage
#' s3_get_bucket_tagging(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_tagging(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example returns tag set associated with a bucket
#' \donttest{svc$get_bucket_tagging(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_tagging
s3_get_bucket_tagging <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketTagging",
    http_method = "GET",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$get_bucket_tagging_input(Bucket = Bucket)
  output <- .s3$get_bucket_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_tagging <- s3_get_bucket_tagging

#' Returns the versioning state of a bucket
#'
#' Returns the versioning state of a bucket.
#'
#' @usage
#' s3_get_bucket_versioning(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_versioning(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves bucket versioning configuration.
#' \donttest{svc$get_bucket_versioning(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_versioning
s3_get_bucket_versioning <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketVersioning",
    http_method = "GET",
    http_path = "/{Bucket}?versioning",
    paginator = list()
  )
  input <- .s3$get_bucket_versioning_input(Bucket = Bucket)
  output <- .s3$get_bucket_versioning_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_versioning <- s3_get_bucket_versioning

#' Returns the website configuration for a bucket
#'
#' Returns the website configuration for a bucket.
#'
#' @usage
#' s3_get_bucket_website(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_bucket_website(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves website configuration of a bucket.
#' \donttest{svc$get_bucket_website(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_website
s3_get_bucket_website <- function(Bucket) {
  op <- new_operation(
    name = "GetBucketWebsite",
    http_method = "GET",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$get_bucket_website_input(Bucket = Bucket)
  output <- .s3$get_bucket_website_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_website <- s3_get_bucket_website

#' Retrieves objects from Amazon S3
#'
#' Retrieves objects from Amazon S3.
#'
#' @usage
#' s3_get_object(Bucket, IfMatch, IfModifiedSince, IfNoneMatch,
#'   IfUnmodifiedSince, Key, Range, ResponseCacheControl,
#'   ResponseContentDisposition, ResponseContentEncoding,
#'   ResponseContentLanguage, ResponseContentType, ResponseExpires,
#'   VersionId, SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
#'   RequestPayer, PartNumber)
#'
#' @param Bucket &#91;required&#93; 
#' @param IfMatch Return the object only if its entity tag (ETag) is the same as the one
#' specified, otherwise return a 412 (precondition failed).
#' @param IfModifiedSince Return the object only if it has been modified since the specified time,
#' otherwise return a 304 (not modified).
#' @param IfNoneMatch Return the object only if its entity tag (ETag) is different from the
#' one specified, otherwise return a 304 (not modified).
#' @param IfUnmodifiedSince Return the object only if it has not been modified since the specified
#' time, otherwise return a 412 (precondition failed).
#' @param Key &#91;required&#93; 
#' @param Range Downloads the specified range bytes of an object. For more information
#' about the HTTP Range header, go to
#' http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html\\#sec14.35.
#' @param ResponseCacheControl Sets the Cache-Control header of the response.
#' @param ResponseContentDisposition Sets the Content-Disposition header of the response
#' @param ResponseContentEncoding Sets the Content-Encoding header of the response.
#' @param ResponseContentLanguage Sets the Content-Language header of the response.
#' @param ResponseContentType Sets the Content-Type header of the response.
#' @param ResponseExpires Sets the Expires header of the response.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param PartNumber Part number of the object being read. This is a positive integer between
#' 1 and 10,000. Effectively performs a \'ranged\' GET request for the part
#' specified. Useful for downloading just a part of an object.
#'
#' @section Request syntax:
#' ```
#' svc$get_object(
#'   Bucket = "string",
#'   IfMatch = "string",
#'   IfModifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   IfNoneMatch = "string",
#'   IfUnmodifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Key = "string",
#'   Range = "string",
#'   ResponseCacheControl = "string",
#'   ResponseContentDisposition = "string",
#'   ResponseContentEncoding = "string",
#'   ResponseContentLanguage = "string",
#'   ResponseContentType = "string",
#'   ResponseExpires = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   VersionId = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   RequestPayer = "requester",
#'   PartNumber = 123
#' )
#' ```
#'
#' @examples
#' # The following example retrieves an object for an S3 bucket.
#' \donttest{svc$get_object(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#' 
#' # The following example retrieves an object for an S3 bucket. The request
#' # specifies the range header to retrieve a specific byte range.
#' \donttest{svc$get_object(
#'   Bucket = "examplebucket",
#'   Key = "SampleFile.txt",
#'   Range = "bytes=0-9"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_object
s3_get_object <- function(Bucket, IfMatch = NULL, IfModifiedSince = NULL, IfNoneMatch = NULL, IfUnmodifiedSince = NULL, Key, Range = NULL, ResponseCacheControl = NULL, ResponseContentDisposition = NULL, ResponseContentEncoding = NULL, ResponseContentLanguage = NULL, ResponseContentType = NULL, ResponseExpires = NULL, VersionId = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, PartNumber = NULL) {
  op <- new_operation(
    name = "GetObject",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$get_object_input(Bucket = Bucket, IfMatch = IfMatch, IfModifiedSince = IfModifiedSince, IfNoneMatch = IfNoneMatch, IfUnmodifiedSince = IfUnmodifiedSince, Key = Key, Range = Range, ResponseCacheControl = ResponseCacheControl, ResponseContentDisposition = ResponseContentDisposition, ResponseContentEncoding = ResponseContentEncoding, ResponseContentLanguage = ResponseContentLanguage, ResponseContentType = ResponseContentType, ResponseExpires = ResponseExpires, VersionId = VersionId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, PartNumber = PartNumber)
  output <- .s3$get_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object <- s3_get_object

#' Returns the access control list (ACL) of an object
#'
#' Returns the access control list (ACL) of an object.
#'
#' @usage
#' s3_get_object_acl(Bucket, Key, VersionId, RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$get_object_acl(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves access control list (ACL) of an object.
#' \donttest{svc$get_object_acl(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_object_acl
s3_get_object_acl <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "GetObjectAcl",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?acl",
    paginator = list()
  )
  input <- .s3$get_object_acl_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer)
  output <- .s3$get_object_acl_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_acl <- s3_get_object_acl

#' Gets an object's current Legal Hold status
#'
#' Gets an object\'s current Legal Hold status.
#'
#' @usage
#' s3_get_object_legal_hold(Bucket, Key, VersionId, RequestPayer)
#'
#' @param Bucket &#91;required&#93; The bucket containing the object whose Legal Hold status you want to
#' retrieve.
#' @param Key &#91;required&#93; The key name for the object whose Legal Hold status you want to
#' retrieve.
#' @param VersionId The version ID of the object whose Legal Hold status you want to
#' retrieve.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$get_object_legal_hold(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_object_legal_hold
s3_get_object_legal_hold <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "GetObjectLegalHold",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?legal-hold",
    paginator = list()
  )
  input <- .s3$get_object_legal_hold_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer)
  output <- .s3$get_object_legal_hold_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_legal_hold <- s3_get_object_legal_hold

#' Gets the object lock configuration for a bucket
#'
#' Gets the object lock configuration for a bucket. The rule specified in
#' the object lock configuration will be applied by default to every new
#' object placed in the specified bucket.
#'
#' @usage
#' s3_get_object_lock_configuration(Bucket)
#'
#' @param Bucket &#91;required&#93; The bucket whose object lock configuration you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_object_lock_configuration(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_object_lock_configuration
s3_get_object_lock_configuration <- function(Bucket) {
  op <- new_operation(
    name = "GetObjectLockConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?object-lock",
    paginator = list()
  )
  input <- .s3$get_object_lock_configuration_input(Bucket = Bucket)
  output <- .s3$get_object_lock_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_lock_configuration <- s3_get_object_lock_configuration

#' Retrieves an object's retention settings
#'
#' Retrieves an object\'s retention settings.
#'
#' @usage
#' s3_get_object_retention(Bucket, Key, VersionId, RequestPayer)
#'
#' @param Bucket &#91;required&#93; The bucket containing the object whose retention settings you want to
#' retrieve.
#' @param Key &#91;required&#93; The key name for the object whose retention settings you want to
#' retrieve.
#' @param VersionId The version ID for the object whose retention settings you want to
#' retrieve.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$get_object_retention(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_object_retention
s3_get_object_retention <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "GetObjectRetention",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?retention",
    paginator = list()
  )
  input <- .s3$get_object_retention_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer)
  output <- .s3$get_object_retention_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_retention <- s3_get_object_retention

#' Returns the tag-set of an object
#'
#' Returns the tag-set of an object.
#'
#' @usage
#' s3_get_object_tagging(Bucket, Key, VersionId)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param VersionId 
#'
#' @section Request syntax:
#' ```
#' svc$get_object_tagging(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves tag set of an object. The request
#' # specifies object version.
#' \donttest{svc$get_object_tagging(
#'   Bucket = "examplebucket",
#'   Key = "exampleobject",
#'   VersionId = "ydlaNkwWm0SfKJR.T1b1fIdPRbldTYRI"
#' )}
#' 
#' # The following example retrieves tag set of an object.
#' \donttest{svc$get_object_tagging(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_object_tagging
s3_get_object_tagging <- function(Bucket, Key, VersionId = NULL) {
  op <- new_operation(
    name = "GetObjectTagging",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$get_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId)
  output <- .s3$get_object_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_tagging <- s3_get_object_tagging

#' Return torrent files from a bucket
#'
#' Return torrent files from a bucket.
#'
#' @usage
#' s3_get_object_torrent(Bucket, Key, RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$get_object_torrent(
#'   Bucket = "string",
#'   Key = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves torrent files of an object.
#' \donttest{svc$get_object_torrent(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_get_object_torrent
s3_get_object_torrent <- function(Bucket, Key, RequestPayer = NULL) {
  op <- new_operation(
    name = "GetObjectTorrent",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?torrent",
    paginator = list()
  )
  input <- .s3$get_object_torrent_input(Bucket = Bucket, Key = Key, RequestPayer = RequestPayer)
  output <- .s3$get_object_torrent_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_torrent <- s3_get_object_torrent

#' Retrieves the PublicAccessBlock configuration for an Amazon S3 bucket
#'
#' Retrieves the `PublicAccessBlock` configuration for an Amazon S3 bucket.
#'
#' @usage
#' s3_get_public_access_block(Bucket)
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration
#' you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_access_block(
#'   Bucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_get_public_access_block
s3_get_public_access_block <- function(Bucket) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$get_public_access_block_input(Bucket = Bucket)
  output <- .s3$get_public_access_block_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_public_access_block <- s3_get_public_access_block

#' This operation is useful to determine if a bucket exists and you have
#' permission to access it
#'
#' This operation is useful to determine if a bucket exists and you have
#' permission to access it.
#'
#' @usage
#' s3_head_bucket(Bucket)
#'
#' @param Bucket &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$head_bucket(
#'   Bucket = "string"
#' )
#' ```
#'
#' @examples
#' # This operation checks to see if a bucket exists.
#' \donttest{svc$head_bucket(
#'   Bucket = "acl1"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_head_bucket
s3_head_bucket <- function(Bucket) {
  op <- new_operation(
    name = "HeadBucket",
    http_method = "HEAD",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$head_bucket_input(Bucket = Bucket)
  output <- .s3$head_bucket_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$head_bucket <- s3_head_bucket

#' The HEAD operation retrieves metadata from an object without returning
#' the object itself
#'
#' The HEAD operation retrieves metadata from an object without returning
#' the object itself. This operation is useful if you\'re only interested
#' in an object\'s metadata. To use HEAD, you must have READ access to the
#' object.
#'
#' @usage
#' s3_head_object(Bucket, IfMatch, IfModifiedSince, IfNoneMatch,
#'   IfUnmodifiedSince, Key, Range, VersionId, SSECustomerAlgorithm,
#'   SSECustomerKey, SSECustomerKeyMD5, RequestPayer, PartNumber)
#'
#' @param Bucket &#91;required&#93; 
#' @param IfMatch Return the object only if its entity tag (ETag) is the same as the one
#' specified, otherwise return a 412 (precondition failed).
#' @param IfModifiedSince Return the object only if it has been modified since the specified time,
#' otherwise return a 304 (not modified).
#' @param IfNoneMatch Return the object only if its entity tag (ETag) is different from the
#' one specified, otherwise return a 304 (not modified).
#' @param IfUnmodifiedSince Return the object only if it has not been modified since the specified
#' time, otherwise return a 412 (precondition failed).
#' @param Key &#91;required&#93; 
#' @param Range Downloads the specified range bytes of an object. For more information
#' about the HTTP Range header, go to
#' http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html\\#sec14.35.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param PartNumber Part number of the object being read. This is a positive integer between
#' 1 and 10,000. Effectively performs a \'ranged\' HEAD request for the
#' part specified. Useful querying about the size of the part and the
#' number of parts in this object.
#'
#' @section Request syntax:
#' ```
#' svc$head_object(
#'   Bucket = "string",
#'   IfMatch = "string",
#'   IfModifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   IfNoneMatch = "string",
#'   IfUnmodifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Key = "string",
#'   Range = "string",
#'   VersionId = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   RequestPayer = "requester",
#'   PartNumber = 123
#' )
#' ```
#'
#' @examples
#' # The following example retrieves an object metadata.
#' \donttest{svc$head_object(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_head_object
s3_head_object <- function(Bucket, IfMatch = NULL, IfModifiedSince = NULL, IfNoneMatch = NULL, IfUnmodifiedSince = NULL, Key, Range = NULL, VersionId = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, PartNumber = NULL) {
  op <- new_operation(
    name = "HeadObject",
    http_method = "HEAD",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$head_object_input(Bucket = Bucket, IfMatch = IfMatch, IfModifiedSince = IfModifiedSince, IfNoneMatch = IfNoneMatch, IfUnmodifiedSince = IfUnmodifiedSince, Key = Key, Range = Range, VersionId = VersionId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, PartNumber = PartNumber)
  output <- .s3$head_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$head_object <- s3_head_object

#' Lists the analytics configurations for the bucket
#'
#' Lists the analytics configurations for the bucket.
#'
#' @usage
#' s3_list_bucket_analytics_configurations(Bucket, ContinuationToken)
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which analytics configurations are
#' retrieved.
#' @param ContinuationToken The ContinuationToken that represents a placeholder from where this
#' request should begin.
#'
#' @section Request syntax:
#' ```
#' svc$list_bucket_analytics_configurations(
#'   Bucket = "string",
#'   ContinuationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_analytics_configurations
s3_list_bucket_analytics_configurations <- function(Bucket, ContinuationToken = NULL) {
  op <- new_operation(
    name = "ListBucketAnalyticsConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$list_bucket_analytics_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken)
  output <- .s3$list_bucket_analytics_configurations_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_analytics_configurations <- s3_list_bucket_analytics_configurations

#' Returns a list of inventory configurations for the bucket
#'
#' Returns a list of inventory configurations for the bucket.
#'
#' @usage
#' s3_list_bucket_inventory_configurations(Bucket, ContinuationToken)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configurations to
#' retrieve.
#' @param ContinuationToken The marker used to continue an inventory configuration listing that has
#' been truncated. Use the NextContinuationToken from a previously
#' truncated list response to continue the listing. The continuation token
#' is an opaque value that Amazon S3 understands.
#'
#' @section Request syntax:
#' ```
#' svc$list_bucket_inventory_configurations(
#'   Bucket = "string",
#'   ContinuationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_inventory_configurations
s3_list_bucket_inventory_configurations <- function(Bucket, ContinuationToken = NULL) {
  op <- new_operation(
    name = "ListBucketInventoryConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$list_bucket_inventory_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken)
  output <- .s3$list_bucket_inventory_configurations_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_inventory_configurations <- s3_list_bucket_inventory_configurations

#' Lists the metrics configurations for the bucket
#'
#' Lists the metrics configurations for the bucket.
#'
#' @usage
#' s3_list_bucket_metrics_configurations(Bucket, ContinuationToken)
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configurations to
#' retrieve.
#' @param ContinuationToken The marker that is used to continue a metrics configuration listing that
#' has been truncated. Use the NextContinuationToken from a previously
#' truncated list response to continue the listing. The continuation token
#' is an opaque value that Amazon S3 understands.
#'
#' @section Request syntax:
#' ```
#' svc$list_bucket_metrics_configurations(
#'   Bucket = "string",
#'   ContinuationToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_metrics_configurations
s3_list_bucket_metrics_configurations <- function(Bucket, ContinuationToken = NULL) {
  op <- new_operation(
    name = "ListBucketMetricsConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$list_bucket_metrics_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken)
  output <- .s3$list_bucket_metrics_configurations_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_metrics_configurations <- s3_list_bucket_metrics_configurations

#' Returns a list of all buckets owned by the authenticated sender of the
#' request
#'
#' Returns a list of all buckets owned by the authenticated sender of the
#' request.
#'
#' @usage
#' s3_list_buckets()
#'

#'

#'
#' @examples
#' # The following example return versions of an object with specific key
#' # name prefix. The request limits the number of items returned to two. If
#' # there are are more than two object version, S3 returns NextToken in the
#' # response. You can specify this token value in your next request to fetch
#' # next set of object versions.
#' \donttest{svc$list_buckets()}
#'
#' @keywords internal
#'
#' @rdname s3_list_buckets
s3_list_buckets <- function() {
  op <- new_operation(
    name = "ListBuckets",
    http_method = "GET",
    http_path = "/",
    paginator = list()
  )
  input <- .s3$list_buckets_input()
  output <- .s3$list_buckets_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_buckets <- s3_list_buckets

#' This operation lists in-progress multipart uploads
#'
#' This operation lists in-progress multipart uploads.
#'
#' @usage
#' s3_list_multipart_uploads(Bucket, Delimiter, EncodingType, KeyMarker,
#'   MaxUploads, Prefix, UploadIdMarker)
#'
#' @param Bucket &#91;required&#93; 
#' @param Delimiter Character you use to group keys.
#' @param EncodingType 
#' @param KeyMarker Together with upload-id-marker, this parameter specifies the multipart
#' upload after which listing should begin.
#' @param MaxUploads Sets the maximum number of multipart uploads, from 1 to 1,000, to return
#' in the response body. 1,000 is the maximum number of uploads that can be
#' returned in a response.
#' @param Prefix Lists in-progress uploads only for those keys that begin with the
#' specified prefix.
#' @param UploadIdMarker Together with key-marker, specifies the multipart upload after which
#' listing should begin. If key-marker is not specified, the
#' upload-id-marker parameter is ignored.
#'
#' @section Request syntax:
#' ```
#' svc$list_multipart_uploads(
#'   Bucket = "string",
#'   Delimiter = "string",
#'   EncodingType = "url",
#'   KeyMarker = "string",
#'   MaxUploads = 123,
#'   Prefix = "string",
#'   UploadIdMarker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example specifies the upload-id-marker and key-marker from
#' # previous truncated response to retrieve next setup of multipart uploads.
#' \donttest{svc$list_multipart_uploads(
#'   Bucket = "examplebucket",
#'   KeyMarker = "nextkeyfrompreviousresponse",
#'   MaxUploads = "2",
#'   UploadIdMarker = "valuefrompreviousresponse"
#' )}
#' 
#' # The following example lists in-progress multipart uploads on a specific
#' # bucket.
#' \donttest{svc$list_multipart_uploads(
#'   Bucket = "examplebucket"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_list_multipart_uploads
s3_list_multipart_uploads <- function(Bucket, Delimiter = NULL, EncodingType = NULL, KeyMarker = NULL, MaxUploads = NULL, Prefix = NULL, UploadIdMarker = NULL) {
  op <- new_operation(
    name = "ListMultipartUploads",
    http_method = "GET",
    http_path = "/{Bucket}?uploads",
    paginator = list()
  )
  input <- .s3$list_multipart_uploads_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, KeyMarker = KeyMarker, MaxUploads = MaxUploads, Prefix = Prefix, UploadIdMarker = UploadIdMarker)
  output <- .s3$list_multipart_uploads_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_multipart_uploads <- s3_list_multipart_uploads

#' Returns metadata about all of the versions of objects in a bucket
#'
#' Returns metadata about all of the versions of objects in a bucket.
#'
#' @usage
#' s3_list_object_versions(Bucket, Delimiter, EncodingType, KeyMarker,
#'   MaxKeys, Prefix, VersionIdMarker)
#'
#' @param Bucket &#91;required&#93; 
#' @param Delimiter A delimiter is a character you use to group keys.
#' @param EncodingType 
#' @param KeyMarker Specifies the key to start with when listing objects in a bucket.
#' @param MaxKeys Sets the maximum number of keys returned in the response. The response
#' might contain fewer keys but will never contain more.
#' @param Prefix Limits the response to keys that begin with the specified prefix.
#' @param VersionIdMarker Specifies the object version you want to start listing from.
#'
#' @section Request syntax:
#' ```
#' svc$list_object_versions(
#'   Bucket = "string",
#'   Delimiter = "string",
#'   EncodingType = "url",
#'   KeyMarker = "string",
#'   MaxKeys = 123,
#'   Prefix = "string",
#'   VersionIdMarker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example return versions of an object with specific key
#' # name prefix. The request limits the number of items returned to two. If
#' # there are are more than two object version, S3 returns NextToken in the
#' # response. You can specify this token value in your next request to fetch
#' # next set of object versions.
#' \donttest{svc$list_object_versions(
#'   Bucket = "examplebucket",
#'   Prefix = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_list_object_versions
s3_list_object_versions <- function(Bucket, Delimiter = NULL, EncodingType = NULL, KeyMarker = NULL, MaxKeys = NULL, Prefix = NULL, VersionIdMarker = NULL) {
  op <- new_operation(
    name = "ListObjectVersions",
    http_method = "GET",
    http_path = "/{Bucket}?versions",
    paginator = list()
  )
  input <- .s3$list_object_versions_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, KeyMarker = KeyMarker, MaxKeys = MaxKeys, Prefix = Prefix, VersionIdMarker = VersionIdMarker)
  output <- .s3$list_object_versions_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_object_versions <- s3_list_object_versions

#' Returns some or all (up to 1000) of the objects in a bucket
#'
#' Returns some or all (up to 1000) of the objects in a bucket. You can use
#' the request parameters as selection criteria to return a subset of the
#' objects in a bucket.
#'
#' @usage
#' s3_list_objects(Bucket, Delimiter, EncodingType, Marker, MaxKeys,
#'   Prefix, RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Delimiter A delimiter is a character you use to group keys.
#' @param EncodingType 
#' @param Marker Specifies the key to start with when listing objects in a bucket.
#' @param MaxKeys Sets the maximum number of keys returned in the response. The response
#' might contain fewer keys but will never contain more.
#' @param Prefix Limits the response to keys that begin with the specified prefix.
#' @param RequestPayer Confirms that the requester knows that she or he will be charged for the
#' list objects request. Bucket owners need not specify this parameter in
#' their requests.
#'
#' @section Request syntax:
#' ```
#' svc$list_objects(
#'   Bucket = "string",
#'   Delimiter = "string",
#'   EncodingType = "url",
#'   Marker = "string",
#'   MaxKeys = 123,
#'   Prefix = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example list two objects in a bucket.
#' \donttest{svc$list_objects(
#'   Bucket = "examplebucket",
#'   MaxKeys = "2"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_list_objects
s3_list_objects <- function(Bucket, Delimiter = NULL, EncodingType = NULL, Marker = NULL, MaxKeys = NULL, Prefix = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "ListObjects",
    http_method = "GET",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$list_objects_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, Marker = Marker, MaxKeys = MaxKeys, Prefix = Prefix, RequestPayer = RequestPayer)
  output <- .s3$list_objects_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_objects <- s3_list_objects

#' Returns some or all (up to 1000) of the objects in a bucket
#'
#' Returns some or all (up to 1000) of the objects in a bucket. You can use
#' the request parameters as selection criteria to return a subset of the
#' objects in a bucket. Note: ListObjectsV2 is the revised List Objects API
#' and we recommend you use this revised API for new application
#' development.
#'
#' @usage
#' s3_list_objects_v2(Bucket, Delimiter, EncodingType, MaxKeys, Prefix,
#'   ContinuationToken, FetchOwner, StartAfter, RequestPayer)
#'
#' @param Bucket &#91;required&#93; Name of the bucket to list.
#' @param Delimiter A delimiter is a character you use to group keys.
#' @param EncodingType Encoding type used by Amazon S3 to encode object keys in the response.
#' @param MaxKeys Sets the maximum number of keys returned in the response. The response
#' might contain fewer keys but will never contain more.
#' @param Prefix Limits the response to keys that begin with the specified prefix.
#' @param ContinuationToken ContinuationToken indicates Amazon S3 that the list is being continued
#' on this bucket with a token. ContinuationToken is obfuscated and is not
#' a real key
#' @param FetchOwner The owner field is not present in listV2 by default, if you want to
#' return owner field with each key in the result then set the fetch owner
#' field to true
#' @param StartAfter StartAfter is where you want Amazon S3 to start listing from. Amazon S3
#' starts listing after this specified key. StartAfter can be any key in
#' the bucket
#' @param RequestPayer Confirms that the requester knows that she or he will be charged for the
#' list objects request in V2 style. Bucket owners need not specify this
#' parameter in their requests.
#'
#' @section Request syntax:
#' ```
#' svc$list_objects_v2(
#'   Bucket = "string",
#'   Delimiter = "string",
#'   EncodingType = "url",
#'   MaxKeys = 123,
#'   Prefix = "string",
#'   ContinuationToken = "string",
#'   FetchOwner = TRUE|FALSE,
#'   StartAfter = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves object list. The request specifies max
#' # keys to limit response to include only 2 object keys.
#' \donttest{svc$list_objects_v2(
#'   Bucket = "examplebucket",
#'   MaxKeys = "2"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_list_objects_v2
s3_list_objects_v2 <- function(Bucket, Delimiter = NULL, EncodingType = NULL, MaxKeys = NULL, Prefix = NULL, ContinuationToken = NULL, FetchOwner = NULL, StartAfter = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "ListObjectsV2",
    http_method = "GET",
    http_path = "/{Bucket}?list-type=2",
    paginator = list()
  )
  input <- .s3$list_objects_v2_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, MaxKeys = MaxKeys, Prefix = Prefix, ContinuationToken = ContinuationToken, FetchOwner = FetchOwner, StartAfter = StartAfter, RequestPayer = RequestPayer)
  output <- .s3$list_objects_v2_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_objects_v2 <- s3_list_objects_v2

#' Lists the parts that have been uploaded for a specific multipart upload
#'
#' Lists the parts that have been uploaded for a specific multipart upload.
#'
#' @usage
#' s3_list_parts(Bucket, Key, MaxParts, PartNumberMarker, UploadId,
#'   RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param MaxParts Sets the maximum number of parts to return.
#' @param PartNumberMarker Specifies the part after which listing should begin. Only parts with
#' higher part numbers will be listed.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose parts are being listed.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$list_parts(
#'   Bucket = "string",
#'   Key = "string",
#'   MaxParts = 123,
#'   PartNumberMarker = 123,
#'   UploadId = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example lists parts uploaded for a specific multipart
#' # upload.
#' \donttest{svc$list_parts(
#'   Bucket = "examplebucket",
#'   Key = "bigobject",
#'   UploadId = "example7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_list_parts
s3_list_parts <- function(Bucket, Key, MaxParts = NULL, PartNumberMarker = NULL, UploadId, RequestPayer = NULL) {
  op <- new_operation(
    name = "ListParts",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$list_parts_input(Bucket = Bucket, Key = Key, MaxParts = MaxParts, PartNumberMarker = PartNumberMarker, UploadId = UploadId, RequestPayer = RequestPayer)
  output <- .s3$list_parts_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_parts <- s3_list_parts

#' Sets the accelerate configuration of an existing bucket
#'
#' Sets the accelerate configuration of an existing bucket.
#'
#' @usage
#' s3_put_bucket_accelerate_configuration(Bucket, AccelerateConfiguration)
#'
#' @param Bucket &#91;required&#93; Name of the bucket for which the accelerate configuration is set.
#' @param AccelerateConfiguration &#91;required&#93; Specifies the Accelerate Configuration you want to set for the bucket.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_accelerate_configuration(
#'   Bucket = "string",
#'   AccelerateConfiguration = list(
#'     Status = "Enabled"|"Suspended"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_accelerate_configuration
s3_put_bucket_accelerate_configuration <- function(Bucket, AccelerateConfiguration) {
  op <- new_operation(
    name = "PutBucketAccelerateConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?accelerate",
    paginator = list()
  )
  input <- .s3$put_bucket_accelerate_configuration_input(Bucket = Bucket, AccelerateConfiguration = AccelerateConfiguration)
  output <- .s3$put_bucket_accelerate_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_accelerate_configuration <- s3_put_bucket_accelerate_configuration

#' Sets the permissions on a bucket using access control lists (ACL)
#'
#' Sets the permissions on a bucket using access control lists (ACL).
#'
#' @usage
#' s3_put_bucket_acl(ACL, AccessControlPolicy, Bucket, ContentMD5,
#'   GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP)
#'
#' @param ACL The canned ACL to apply to the bucket.
#' @param AccessControlPolicy Contains the elements that set the ACL permissions for an object per
#' grantee.
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' @param GrantWrite Allows grantee to create, overwrite, and delete any object in the
#' bucket.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_acl(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read",
#'   AccessControlPolicy = list(
#'     Grants = list(
#'       list(
#'         Grantee = list(
#'           DisplayName = "string",
#'           EmailAddress = "string",
#'           ID = "string",
#'           Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
#'           URI = "string"
#'         ),
#'         Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
#'       )
#'     ),
#'     Owner = list(
#'       DisplayName = "string",
#'       ID = "string"
#'     )
#'   ),
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWrite = "string",
#'   GrantWriteACP = "string"
#' )
#' ```
#'
#' @examples
#' # The following example replaces existing ACL on a bucket. The ACL grants
#' # the bucket owner (specified using the owner ID) and write permission to
#' # the LogDelivery group. Because this is a replace operation, you must
#' # specify all the grants in your request. To incrementally add or remove
#' # ACL grants, you might use the console.
#' \donttest{svc$put_bucket_acl(
#'   Bucket = "examplebucket",
#'   GrantFullControl = "id=examplee7a2f25102679df27bb0ae12b3f85be6f290b936c4393484",
#'   GrantWrite = "uri=http://acs.amazonaws.com/groups/s3/LogDelivery"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_acl
s3_put_bucket_acl <- function(ACL = NULL, AccessControlPolicy = NULL, Bucket, ContentMD5 = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL) {
  op <- new_operation(
    name = "PutBucketAcl",
    http_method = "PUT",
    http_path = "/{Bucket}?acl",
    paginator = list()
  )
  input <- .s3$put_bucket_acl_input(ACL = ACL, AccessControlPolicy = AccessControlPolicy, Bucket = Bucket, ContentMD5 = ContentMD5, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP)
  output <- .s3$put_bucket_acl_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_acl <- s3_put_bucket_acl

#' Sets an analytics configuration for the bucket (specified by the
#' analytics configuration ID)
#'
#' Sets an analytics configuration for the bucket (specified by the
#' analytics configuration ID).
#'
#' @usage
#' s3_put_bucket_analytics_configuration(Bucket, Id,
#'   AnalyticsConfiguration)
#'
#' @param Bucket &#91;required&#93; The name of the bucket to which an analytics configuration is stored.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#' @param AnalyticsConfiguration &#91;required&#93; The configuration and any analyses for the analytics filter.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_analytics_configuration(
#'   Bucket = "string",
#'   Id = "string",
#'   AnalyticsConfiguration = list(
#'     Id = "string",
#'     Filter = list(
#'       Prefix = "string",
#'       Tag = list(
#'         Key = "string",
#'         Value = "string"
#'       ),
#'       And = list(
#'         Prefix = "string",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     StorageClassAnalysis = list(
#'       DataExport = list(
#'         OutputSchemaVersion = "V_1",
#'         Destination = list(
#'           S3BucketDestination = list(
#'             Format = "CSV",
#'             BucketAccountId = "string",
#'             Bucket = "string",
#'             Prefix = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_analytics_configuration
s3_put_bucket_analytics_configuration <- function(Bucket, Id, AnalyticsConfiguration) {
  op <- new_operation(
    name = "PutBucketAnalyticsConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$put_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id, AnalyticsConfiguration = AnalyticsConfiguration)
  output <- .s3$put_bucket_analytics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_analytics_configuration <- s3_put_bucket_analytics_configuration

#' Sets the CORS configuration for a bucket
#'
#' Sets the CORS configuration for a bucket.
#'
#' @usage
#' s3_put_bucket_cors(Bucket, CORSConfiguration, ContentMD5)
#'
#' @param Bucket &#91;required&#93; 
#' @param CORSConfiguration &#91;required&#93; 
#' @param ContentMD5 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_cors(
#'   Bucket = "string",
#'   CORSConfiguration = list(
#'     CORSRules = list(
#'       list(
#'         AllowedHeaders = list(
#'           "string"
#'         ),
#'         AllowedMethods = list(
#'           "string"
#'         ),
#'         AllowedOrigins = list(
#'           "string"
#'         ),
#'         ExposeHeaders = list(
#'           "string"
#'         ),
#'         MaxAgeSeconds = 123
#'       )
#'     )
#'   ),
#'   ContentMD5 = "string"
#' )
#' ```
#'
#' @examples
#' # The following example enables PUT, POST, and DELETE requests from
#' # www.example.com, and enables GET requests from any domain.
#' \donttest{svc$put_bucket_cors(
#'   Bucket = "",
#'   CORSConfiguration = list(
#'     CORSRules = list(
#'       list(
#'         AllowedHeaders = list(
#'           "*"
#'         ),
#'         AllowedMethods = list(
#'           "PUT",
#'           "POST",
#'           "DELETE"
#'         ),
#'         AllowedOrigins = list(
#'           "http://www.example.com"
#'         ),
#'         ExposeHeaders = list(
#'           "x-amz-server-side-encryption"
#'         ),
#'         MaxAgeSeconds = 3000L
#'       ),
#'       list(
#'         AllowedHeaders = list(
#'           "Authorization"
#'         ),
#'         AllowedMethods = list(
#'           "GET"
#'         ),
#'         AllowedOrigins = list(
#'           "*"
#'         ),
#'         MaxAgeSeconds = 3000L
#'       )
#'     )
#'   ),
#'   ContentMD5 = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_cors
s3_put_bucket_cors <- function(Bucket, CORSConfiguration, ContentMD5 = NULL) {
  op <- new_operation(
    name = "PutBucketCors",
    http_method = "PUT",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$put_bucket_cors_input(Bucket = Bucket, CORSConfiguration = CORSConfiguration, ContentMD5 = ContentMD5)
  output <- .s3$put_bucket_cors_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_cors <- s3_put_bucket_cors

#' Creates a new server-side encryption configuration (or replaces an
#' existing one, if present)
#'
#' Creates a new server-side encryption configuration (or replaces an
#' existing one, if present).
#'
#' @usage
#' s3_put_bucket_encryption(Bucket, ContentMD5,
#'   ServerSideEncryptionConfiguration)
#'
#' @param Bucket &#91;required&#93; Specifies default encryption for a bucket using server-side encryption
#' with Amazon S3-managed keys (SSE-S3) or AWS KMS-managed keys (SSE-KMS).
#' For information about the Amazon S3 default encryption feature, see
#' [Amazon S3 Default Bucket
#' Encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-encryption.html)
#' in the *Amazon Simple Storage Service Developer Guide*.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the server-side encryption
#' configuration. This parameter is auto-populated when using the command
#' from the CLI.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_encryption(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   ServerSideEncryptionConfiguration = list(
#'     Rules = list(
#'       list(
#'         ApplyServerSideEncryptionByDefault = list(
#'           SSEAlgorithm = "AES256"|"aws:kms",
#'           KMSMasterKeyID = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_encryption
s3_put_bucket_encryption <- function(Bucket, ContentMD5 = NULL, ServerSideEncryptionConfiguration) {
  op <- new_operation(
    name = "PutBucketEncryption",
    http_method = "PUT",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$put_bucket_encryption_input(Bucket = Bucket, ContentMD5 = ContentMD5, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration)
  output <- .s3$put_bucket_encryption_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_encryption <- s3_put_bucket_encryption

#' Adds an inventory configuration (identified by the inventory ID) from
#' the bucket
#'
#' Adds an inventory configuration (identified by the inventory ID) from
#' the bucket.
#'
#' @usage
#' s3_put_bucket_inventory_configuration(Bucket, Id,
#'   InventoryConfiguration)
#'
#' @param Bucket &#91;required&#93; The name of the bucket where the inventory configuration will be stored.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#' @param InventoryConfiguration &#91;required&#93; Specifies the inventory configuration.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_inventory_configuration(
#'   Bucket = "string",
#'   Id = "string",
#'   InventoryConfiguration = list(
#'     Destination = list(
#'       S3BucketDestination = list(
#'         AccountId = "string",
#'         Bucket = "string",
#'         Format = "CSV"|"ORC"|"Parquet",
#'         Prefix = "string",
#'         Encryption = list(
#'           SSES3 = list(),
#'           SSEKMS = list(
#'             KeyId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     IsEnabled = TRUE|FALSE,
#'     Filter = list(
#'       Prefix = "string"
#'     ),
#'     Id = "string",
#'     IncludedObjectVersions = "All"|"Current",
#'     OptionalFields = list(
#'       "Size"|"LastModifiedDate"|"StorageClass"|"ETag"|"IsMultipartUploaded"|"ReplicationStatus"|"EncryptionStatus"|"ObjectLockRetainUntilDate"|"ObjectLockMode"|"ObjectLockLegalHoldStatus"
#'     ),
#'     Schedule = list(
#'       Frequency = "Daily"|"Weekly"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_inventory_configuration
s3_put_bucket_inventory_configuration <- function(Bucket, Id, InventoryConfiguration) {
  op <- new_operation(
    name = "PutBucketInventoryConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$put_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id, InventoryConfiguration = InventoryConfiguration)
  output <- .s3$put_bucket_inventory_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_inventory_configuration <- s3_put_bucket_inventory_configuration

#' No longer used, see the PutBucketLifecycleConfiguration operation
#'
#' No longer used, see the PutBucketLifecycleConfiguration operation.
#'
#' @usage
#' s3_put_bucket_lifecycle(Bucket, ContentMD5, LifecycleConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param LifecycleConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_lifecycle(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   LifecycleConfiguration = list(
#'     Rules = list(
#'       list(
#'         Expiration = list(
#'           Date = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           Days = 123,
#'           ExpiredObjectDeleteMarker = TRUE|FALSE
#'         ),
#'         ID = "string",
#'         Prefix = "string",
#'         Status = "Enabled"|"Disabled",
#'         Transition = list(
#'           Date = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           Days = 123,
#'           StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
#'         ),
#'         NoncurrentVersionTransition = list(
#'           NoncurrentDays = 123,
#'           StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
#'         ),
#'         NoncurrentVersionExpiration = list(
#'           NoncurrentDays = 123
#'         ),
#'         AbortIncompleteMultipartUpload = list(
#'           DaysAfterInitiation = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_lifecycle
s3_put_bucket_lifecycle <- function(Bucket, ContentMD5 = NULL, LifecycleConfiguration = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycle",
    http_method = "PUT",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$put_bucket_lifecycle_input(Bucket = Bucket, ContentMD5 = ContentMD5, LifecycleConfiguration = LifecycleConfiguration)
  output <- .s3$put_bucket_lifecycle_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_lifecycle <- s3_put_bucket_lifecycle

#' Sets lifecycle configuration for your bucket
#'
#' Sets lifecycle configuration for your bucket. If a lifecycle
#' configuration exists, it replaces it.
#'
#' @usage
#' s3_put_bucket_lifecycle_configuration(Bucket, LifecycleConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param LifecycleConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_lifecycle_configuration(
#'   Bucket = "string",
#'   LifecycleConfiguration = list(
#'     Rules = list(
#'       list(
#'         Expiration = list(
#'           Date = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           Days = 123,
#'           ExpiredObjectDeleteMarker = TRUE|FALSE
#'         ),
#'         ID = "string",
#'         Prefix = "string",
#'         Filter = list(
#'           Prefix = "string",
#'           Tag = list(
#'             Key = "string",
#'             Value = "string"
#'           ),
#'           And = list(
#'             Prefix = "string",
#'             Tags = list(
#'               list(
#'                 Key = "string",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         ),
#'         Status = "Enabled"|"Disabled",
#'         Transitions = list(
#'           list(
#'             Date = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             Days = 123,
#'             StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
#'           )
#'         ),
#'         NoncurrentVersionTransitions = list(
#'           list(
#'             NoncurrentDays = 123,
#'             StorageClass = "GLACIER"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE"
#'           )
#'         ),
#'         NoncurrentVersionExpiration = list(
#'           NoncurrentDays = 123
#'         ),
#'         AbortIncompleteMultipartUpload = list(
#'           DaysAfterInitiation = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example replaces existing lifecycle configuration, if any,
#' # on the specified bucket.
#' \donttest{svc$put_bucket_lifecycle_configuration(
#'   Bucket = "examplebucket",
#'   LifecycleConfiguration = list(
#'     Rules = list(
#'       list(
#'         Expiration = list(
#'           Days = 3650L
#'         ),
#'         Filter = list(
#'           Prefix = "documents/"
#'         ),
#'         ID = "TestOnly",
#'         Status = "Enabled",
#'         Transitions = list(
#'           list(
#'             Days = 365L,
#'             StorageClass = "GLACIER"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_lifecycle_configuration
s3_put_bucket_lifecycle_configuration <- function(Bucket, LifecycleConfiguration = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$put_bucket_lifecycle_configuration_input(Bucket = Bucket, LifecycleConfiguration = LifecycleConfiguration)
  output <- .s3$put_bucket_lifecycle_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_lifecycle_configuration <- s3_put_bucket_lifecycle_configuration

#' Set the logging parameters for a bucket and to specify permissions for
#' who can view and modify the logging parameters
#'
#' Set the logging parameters for a bucket and to specify permissions for
#' who can view and modify the logging parameters. To set the logging
#' status of a bucket, you must be the bucket owner.
#'
#' @usage
#' s3_put_bucket_logging(Bucket, BucketLoggingStatus, ContentMD5)
#'
#' @param Bucket &#91;required&#93; 
#' @param BucketLoggingStatus &#91;required&#93; 
#' @param ContentMD5 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_logging(
#'   Bucket = "string",
#'   BucketLoggingStatus = list(
#'     LoggingEnabled = list(
#'       TargetBucket = "string",
#'       TargetGrants = list(
#'         list(
#'           Grantee = list(
#'             DisplayName = "string",
#'             EmailAddress = "string",
#'             ID = "string",
#'             Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
#'             URI = "string"
#'           ),
#'           Permission = "FULL_CONTROL"|"READ"|"WRITE"
#'         )
#'       ),
#'       TargetPrefix = "string"
#'     )
#'   ),
#'   ContentMD5 = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets logging policy on a bucket. For the Log
#' # Delivery group to deliver logs to the destination bucket, it needs
#' # permission for the READ_ACP action which the policy grants.
#' \donttest{svc$put_bucket_logging(
#'   Bucket = "sourcebucket",
#'   BucketLoggingStatus = list(
#'     LoggingEnabled = list(
#'       TargetBucket = "targetbucket",
#'       TargetGrants = list(
#'         list(
#'           Grantee = list(
#'             Type = "Group",
#'             URI = "http://acs.amazonaws.com/groups/global/AllUsers"
#'           ),
#'           Permission = "READ"
#'         )
#'       ),
#'       TargetPrefix = "MyBucketLogs/"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_logging
s3_put_bucket_logging <- function(Bucket, BucketLoggingStatus, ContentMD5 = NULL) {
  op <- new_operation(
    name = "PutBucketLogging",
    http_method = "PUT",
    http_path = "/{Bucket}?logging",
    paginator = list()
  )
  input <- .s3$put_bucket_logging_input(Bucket = Bucket, BucketLoggingStatus = BucketLoggingStatus, ContentMD5 = ContentMD5)
  output <- .s3$put_bucket_logging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_logging <- s3_put_bucket_logging

#' Sets a metrics configuration (specified by the metrics configuration ID)
#' for the bucket
#'
#' Sets a metrics configuration (specified by the metrics configuration ID)
#' for the bucket.
#'
#' @usage
#' s3_put_bucket_metrics_configuration(Bucket, Id, MetricsConfiguration)
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which the metrics configuration is set.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#' @param MetricsConfiguration &#91;required&#93; Specifies the metrics configuration.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_metrics_configuration(
#'   Bucket = "string",
#'   Id = "string",
#'   MetricsConfiguration = list(
#'     Id = "string",
#'     Filter = list(
#'       Prefix = "string",
#'       Tag = list(
#'         Key = "string",
#'         Value = "string"
#'       ),
#'       And = list(
#'         Prefix = "string",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_metrics_configuration
s3_put_bucket_metrics_configuration <- function(Bucket, Id, MetricsConfiguration) {
  op <- new_operation(
    name = "PutBucketMetricsConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$put_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id, MetricsConfiguration = MetricsConfiguration)
  output <- .s3$put_bucket_metrics_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_metrics_configuration <- s3_put_bucket_metrics_configuration

#' No longer used, see the PutBucketNotificationConfiguration operation
#'
#' No longer used, see the PutBucketNotificationConfiguration operation.
#'
#' @usage
#' s3_put_bucket_notification(Bucket, ContentMD5,
#'   NotificationConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param NotificationConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_notification(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   NotificationConfiguration = list(
#'     TopicConfiguration = list(
#'       Id = "string",
#'       Events = list(
#'         "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'       ),
#'       Event = "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed",
#'       Topic = "string"
#'     ),
#'     QueueConfiguration = list(
#'       Id = "string",
#'       Event = "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed",
#'       Events = list(
#'         "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'       ),
#'       Queue = "string"
#'     ),
#'     CloudFunctionConfiguration = list(
#'       Id = "string",
#'       Event = "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed",
#'       Events = list(
#'         "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'       ),
#'       CloudFunction = "string",
#'       InvocationRole = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_notification
s3_put_bucket_notification <- function(Bucket, ContentMD5 = NULL, NotificationConfiguration) {
  op <- new_operation(
    name = "PutBucketNotification",
    http_method = "PUT",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$put_bucket_notification_input(Bucket = Bucket, ContentMD5 = ContentMD5, NotificationConfiguration = NotificationConfiguration)
  output <- .s3$put_bucket_notification_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_notification <- s3_put_bucket_notification

#' Enables notifications of specified events for a bucket
#'
#' Enables notifications of specified events for a bucket.
#'
#' @usage
#' s3_put_bucket_notification_configuration(Bucket,
#'   NotificationConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param NotificationConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_notification_configuration(
#'   Bucket = "string",
#'   NotificationConfiguration = list(
#'     TopicConfigurations = list(
#'       list(
#'         Id = "string",
#'         TopicArn = "string",
#'         Events = list(
#'           "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'         ),
#'         Filter = list(
#'           Key = list(
#'             FilterRules = list(
#'               list(
#'                 Name = "prefix"|"suffix",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     QueueConfigurations = list(
#'       list(
#'         Id = "string",
#'         QueueArn = "string",
#'         Events = list(
#'           "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'         ),
#'         Filter = list(
#'           Key = list(
#'             FilterRules = list(
#'               list(
#'                 Name = "prefix"|"suffix",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     LambdaFunctionConfigurations = list(
#'       list(
#'         Id = "string",
#'         LambdaFunctionArn = "string",
#'         Events = list(
#'           "s3:ReducedRedundancyLostObject"|"s3:ObjectCreated:*"|"s3:ObjectCreated:Put"|"s3:ObjectCreated:Post"|"s3:ObjectCreated:Copy"|"s3:ObjectCreated:CompleteMultipartUpload"|"s3:ObjectRemoved:*"|"s3:ObjectRemoved:Delete"|"s3:ObjectRemoved:DeleteMarkerCreated"|"s3:ObjectRestore:Post"|"s3:ObjectRestore:Completed"
#'         ),
#'         Filter = list(
#'           Key = list(
#'             FilterRules = list(
#'               list(
#'                 Name = "prefix"|"suffix",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example sets notification configuration on a bucket to
#' # publish the object created events to an SNS topic.
#' \donttest{svc$put_bucket_notification_configuration(
#'   Bucket = "examplebucket",
#'   NotificationConfiguration = list(
#'     TopicConfigurations = list(
#'       list(
#'         Events = list(
#'           "s3:ObjectCreated:*"
#'         ),
#'         TopicArn = "arn:aws:sns:us-west-2:123456789012:s3-notification-topic"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_notification_configuration
s3_put_bucket_notification_configuration <- function(Bucket, NotificationConfiguration) {
  op <- new_operation(
    name = "PutBucketNotificationConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$put_bucket_notification_configuration_input(Bucket = Bucket, NotificationConfiguration = NotificationConfiguration)
  output <- .s3$put_bucket_notification_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_notification_configuration <- s3_put_bucket_notification_configuration

#' Applies an Amazon S3 bucket policy to an Amazon S3 bucket
#'
#' Applies an Amazon S3 bucket policy to an Amazon S3 bucket.
#'
#' @usage
#' s3_put_bucket_policy(Bucket, ContentMD5, ConfirmRemoveSelfBucketAccess,
#'   Policy)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param ConfirmRemoveSelfBucketAccess Set this parameter to true to confirm that you want to remove your
#' permissions to change this bucket policy in the future.
#' @param Policy &#91;required&#93; The bucket policy as a JSON document.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_policy(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   ConfirmRemoveSelfBucketAccess = TRUE|FALSE,
#'   Policy = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets a permission policy on a bucket.
#' \donttest{svc$put_bucket_policy(
#'   Bucket = "examplebucket",
#'   Policy = "{\"Version\": \"2012-10-17\", \"Statement\": [{ \"Sid\": \"id-1\",\"Effect\": ..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_policy
s3_put_bucket_policy <- function(Bucket, ContentMD5 = NULL, ConfirmRemoveSelfBucketAccess = NULL, Policy) {
  op <- new_operation(
    name = "PutBucketPolicy",
    http_method = "PUT",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$put_bucket_policy_input(Bucket = Bucket, ContentMD5 = ContentMD5, ConfirmRemoveSelfBucketAccess = ConfirmRemoveSelfBucketAccess, Policy = Policy)
  output <- .s3$put_bucket_policy_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_policy <- s3_put_bucket_policy

#' Creates a replication configuration or replaces an existing one
#'
#' Creates a replication configuration or replaces an existing one. For
#' more information, see [Cross-Region Replication
#' (CRR)](https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html) in the
#' *Amazon S3 Developer Guide*.
#'
#' @usage
#' s3_put_bucket_replication(Bucket, ContentMD5, ReplicationConfiguration,
#'   Token)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit.
#' @param ReplicationConfiguration &#91;required&#93; 
#' @param Token A token that allows Amazon S3 object lock to be enabled for an existing
#' bucket.
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_replication(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   ReplicationConfiguration = list(
#'     Role = "string",
#'     Rules = list(
#'       list(
#'         ID = "string",
#'         Priority = 123,
#'         Prefix = "string",
#'         Filter = list(
#'           Prefix = "string",
#'           Tag = list(
#'             Key = "string",
#'             Value = "string"
#'           ),
#'           And = list(
#'             Prefix = "string",
#'             Tags = list(
#'               list(
#'                 Key = "string",
#'                 Value = "string"
#'               )
#'             )
#'           )
#'         ),
#'         Status = "Enabled"|"Disabled",
#'         SourceSelectionCriteria = list(
#'           SseKmsEncryptedObjects = list(
#'             Status = "Enabled"|"Disabled"
#'           )
#'         ),
#'         Destination = list(
#'           Bucket = "string",
#'           Account = "string",
#'           StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
#'           AccessControlTranslation = list(
#'             Owner = "Destination"
#'           ),
#'           EncryptionConfiguration = list(
#'             ReplicaKmsKeyID = "string"
#'           )
#'         ),
#'         DeleteMarkerReplication = list(
#'           Status = "Enabled"|"Disabled"
#'         )
#'       )
#'     )
#'   ),
#'   Token = "string"
#' )
#' ```
#'
#' @examples
#' # The following example sets replication configuration on a bucket.
#' \donttest{svc$put_bucket_replication(
#'   Bucket = "examplebucket",
#'   ReplicationConfiguration = list(
#'     Role = "arn:aws:iam::123456789012:role/examplerole",
#'     Rules = list(
#'       list(
#'         Destination = list(
#'           Bucket = "arn:aws:s3:::destinationbucket",
#'           StorageClass = "STANDARD"
#'         ),
#'         Prefix = "",
#'         Status = "Enabled"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_replication
s3_put_bucket_replication <- function(Bucket, ContentMD5 = NULL, ReplicationConfiguration, Token = NULL) {
  op <- new_operation(
    name = "PutBucketReplication",
    http_method = "PUT",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$put_bucket_replication_input(Bucket = Bucket, ContentMD5 = ContentMD5, ReplicationConfiguration = ReplicationConfiguration, Token = Token)
  output <- .s3$put_bucket_replication_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_replication <- s3_put_bucket_replication

#' Sets the request payment configuration for a bucket
#'
#' Sets the request payment configuration for a bucket. By default, the
#' bucket owner pays for downloads from the bucket. This configuration
#' parameter enables the bucket owner (only) to specify that the person
#' requesting the download will be charged for the download. Documentation
#' on requester pays buckets can be found at
#' http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
#'
#' @usage
#' s3_put_bucket_request_payment(Bucket, ContentMD5,
#'   RequestPaymentConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param RequestPaymentConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_request_payment(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   RequestPaymentConfiguration = list(
#'     Payer = "Requester"|"BucketOwner"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example sets request payment configuration on a bucket so
#' # that person requesting the download is charged.
#' \donttest{svc$put_bucket_request_payment(
#'   Bucket = "examplebucket",
#'   RequestPaymentConfiguration = list(
#'     Payer = "Requester"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_request_payment
s3_put_bucket_request_payment <- function(Bucket, ContentMD5 = NULL, RequestPaymentConfiguration) {
  op <- new_operation(
    name = "PutBucketRequestPayment",
    http_method = "PUT",
    http_path = "/{Bucket}?requestPayment",
    paginator = list()
  )
  input <- .s3$put_bucket_request_payment_input(Bucket = Bucket, ContentMD5 = ContentMD5, RequestPaymentConfiguration = RequestPaymentConfiguration)
  output <- .s3$put_bucket_request_payment_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_request_payment <- s3_put_bucket_request_payment

#' Sets the tags for a bucket
#'
#' Sets the tags for a bucket.
#'
#' @usage
#' s3_put_bucket_tagging(Bucket, ContentMD5, Tagging)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param Tagging &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_tagging(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   Tagging = list(
#'     TagSet = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example sets tags on a bucket. Any existing tags are
#' # replaced.
#' \donttest{svc$put_bucket_tagging(
#'   Bucket = "examplebucket",
#'   Tagging = list(
#'     TagSet = list(
#'       list(
#'         Key = "Key1",
#'         Value = "Value1"
#'       ),
#'       list(
#'         Key = "Key2",
#'         Value = "Value2"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_tagging
s3_put_bucket_tagging <- function(Bucket, ContentMD5 = NULL, Tagging) {
  op <- new_operation(
    name = "PutBucketTagging",
    http_method = "PUT",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$put_bucket_tagging_input(Bucket = Bucket, ContentMD5 = ContentMD5, Tagging = Tagging)
  output <- .s3$put_bucket_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_tagging <- s3_put_bucket_tagging

#' Sets the versioning state of an existing bucket
#'
#' Sets the versioning state of an existing bucket. To set the versioning
#' state, you must be the bucket owner.
#'
#' @usage
#' s3_put_bucket_versioning(Bucket, ContentMD5, MFA,
#'   VersioningConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param MFA The concatenation of the authentication device\'s serial number, a
#' space, and the value that is displayed on your authentication device.
#' @param VersioningConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_versioning(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   MFA = "string",
#'   VersioningConfiguration = list(
#'     MFADelete = "Enabled"|"Disabled",
#'     Status = "Enabled"|"Suspended"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example sets versioning configuration on bucket. The
#' # configuration enables versioning on the bucket.
#' \donttest{svc$put_bucket_versioning(
#'   Bucket = "examplebucket",
#'   VersioningConfiguration = list(
#'     MFADelete = "Disabled",
#'     Status = "Enabled"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_versioning
s3_put_bucket_versioning <- function(Bucket, ContentMD5 = NULL, MFA = NULL, VersioningConfiguration) {
  op <- new_operation(
    name = "PutBucketVersioning",
    http_method = "PUT",
    http_path = "/{Bucket}?versioning",
    paginator = list()
  )
  input <- .s3$put_bucket_versioning_input(Bucket = Bucket, ContentMD5 = ContentMD5, MFA = MFA, VersioningConfiguration = VersioningConfiguration)
  output <- .s3$put_bucket_versioning_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_versioning <- s3_put_bucket_versioning

#' Set the website configuration for a bucket
#'
#' Set the website configuration for a bucket.
#'
#' @usage
#' s3_put_bucket_website(Bucket, ContentMD5, WebsiteConfiguration)
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param WebsiteConfiguration &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_bucket_website(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   WebsiteConfiguration = list(
#'     ErrorDocument = list(
#'       Key = "string"
#'     ),
#'     IndexDocument = list(
#'       Suffix = "string"
#'     ),
#'     RedirectAllRequestsTo = list(
#'       HostName = "string",
#'       Protocol = "http"|"https"
#'     ),
#'     RoutingRules = list(
#'       list(
#'         Condition = list(
#'           HttpErrorCodeReturnedEquals = "string",
#'           KeyPrefixEquals = "string"
#'         ),
#'         Redirect = list(
#'           HostName = "string",
#'           HttpRedirectCode = "string",
#'           Protocol = "http"|"https",
#'           ReplaceKeyPrefixWith = "string",
#'           ReplaceKeyWith = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example adds website configuration to a bucket.
#' \donttest{svc$put_bucket_website(
#'   Bucket = "examplebucket",
#'   ContentMD5 = "",
#'   WebsiteConfiguration = list(
#'     ErrorDocument = list(
#'       Key = "error.html"
#'     ),
#'     IndexDocument = list(
#'       Suffix = "index.html"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_website
s3_put_bucket_website <- function(Bucket, ContentMD5 = NULL, WebsiteConfiguration) {
  op <- new_operation(
    name = "PutBucketWebsite",
    http_method = "PUT",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$put_bucket_website_input(Bucket = Bucket, ContentMD5 = ContentMD5, WebsiteConfiguration = WebsiteConfiguration)
  output <- .s3$put_bucket_website_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_website <- s3_put_bucket_website

#' Adds an object to a bucket
#'
#' Adds an object to a bucket.
#'
#' @usage
#' s3_put_object(ACL, Body, Bucket, CacheControl, ContentDisposition,
#'   ContentEncoding, ContentLanguage, ContentLength, ContentMD5,
#'   ContentType, Expires, GrantFullControl, GrantRead, GrantReadACP,
#'   GrantWriteACP, Key, Metadata, ServerSideEncryption, StorageClass,
#'   WebsiteRedirectLocation, SSECustomerAlgorithm, SSECustomerKey,
#'   SSECustomerKeyMD5, SSEKMSKeyId, SSEKMSEncryptionContext, RequestPayer,
#'   Tagging, ObjectLockMode, ObjectLockRetainUntilDate,
#'   ObjectLockLegalHoldStatus)
#'
#' @param ACL The canned ACL to apply to the object.
#' @param Body Object data.
#' @param Bucket &#91;required&#93; Name of the bucket to which the PUT operation was initiated.
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentLength Size of the body in bytes. This parameter is useful when the size of the
#' body cannot be determined automatically.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the part data. This parameter
#' is auto-populated when using the command from the CLI. This parameted is
#' required if object lock parameters are specified.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param GrantFullControl Gives the grantee READ, READ\\_ACP, and WRITE\\_ACP permissions on the
#' object.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' @param Key &#91;required&#93; Object key for which the PUT operation was initiated.
#' @param Metadata A map of metadata to store with the object in S3.
#' @param ServerSideEncryption The Server-side encryption algorithm used when storing this object in S3
#' (e.g., AES256, aws:kms).
#' @param StorageClass The type of storage to use for the object. Defaults to \'STANDARD\'.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param SSEKMSKeyId Specifies the AWS KMS key ID to use for object encryption. All GET and
#' PUT requests for an object protected by AWS KMS will fail if not made
#' via SSL or using SigV4. Documentation on configuring any of the
#' officially supported AWS SDKs and CLI can be found at
#' http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\\#specify-signature-version
#' @param SSEKMSEncryptionContext Specifies the AWS KMS Encryption Context to use for object encryption.
#' The value of this header is a base64-encoded UTF-8 string holding JSON
#' with the encryption context key-value pairs.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object. The tag-set must be encoded as URL Query
#' parameters. (For example, \"Key1=Value1\")
#' @param ObjectLockMode The object lock mode that you want to apply to this object.
#' @param ObjectLockRetainUntilDate The date and time when you want this object\'s object lock to expire.
#' @param ObjectLockLegalHoldStatus The Legal Hold status that you want to apply to the specified object.
#'
#' @section Request syntax:
#' ```
#' svc$put_object(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'   Body = raw,
#'   Bucket = "string",
#'   CacheControl = "string",
#'   ContentDisposition = "string",
#'   ContentEncoding = "string",
#'   ContentLanguage = "string",
#'   ContentLength = 123,
#'   ContentMD5 = "string",
#'   ContentType = "string",
#'   Expires = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWriteACP = "string",
#'   Key = "string",
#'   Metadata = list(
#'     "string"
#'   ),
#'   ServerSideEncryption = "AES256"|"aws:kms",
#'   StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
#'   WebsiteRedirectLocation = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   SSEKMSKeyId = "string",
#'   SSEKMSEncryptionContext = "string",
#'   RequestPayer = "requester",
#'   Tagging = "string",
#'   ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
#'   ObjectLockRetainUntilDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ObjectLockLegalHoldStatus = "ON"|"OFF"
#' )
#' ```
#'
#' @examples
#' # The following example uploads and object. The request specifies optional
#' # canned ACL (access control list) to all READ access to authenticated
#' # users. If the bucket is versioning enabled, S3 returns version ID in
#' # response.
#' \donttest{svc$put_object(
#'   ACL = "authenticated-read",
#'   Body = "filetoupload",
#'   Bucket = "examplebucket",
#'   Key = "exampleobject"
#' )}
#' 
#' # The following example uploads an object. The request specifies optional
#' # object tags. The bucket is versioned, therefore S3 returns version ID of
#' # the newly created object.
#' \donttest{svc$put_object(
#'   Body = "c:\\HappyFace.jpg",
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg",
#'   Tagging = "key1=value1&key2=value2"
#' )}
#' 
#' # The following example creates an object. The request also specifies
#' # optional metadata. If the bucket is versioning enabled, S3 returns
#' # version ID in response.
#' \donttest{svc$put_object(
#'   Body = "filetoupload",
#'   Bucket = "examplebucket",
#'   Key = "exampleobject",
#'   Metadata = list(
#'     metadata1 = "value1",
#'     metadata2 = "value2"
#'   )
#' )}
#' 
#' # The following example uploads and object. The request specifies the
#' # optional server-side encryption option. The request also specifies
#' # optional object tags. If the bucket is versioning enabled, S3 returns
#' # version ID in response.
#' \donttest{svc$put_object(
#'   Body = "filetoupload",
#'   Bucket = "examplebucket",
#'   Key = "exampleobject",
#'   ServerSideEncryption = "AES256",
#'   Tagging = "key1=value1&key2=value2"
#' )}
#' 
#' # The following example creates an object. If the bucket is versioning
#' # enabled, S3 returns version ID in response.
#' \donttest{svc$put_object(
#'   Body = "filetoupload",
#'   Bucket = "examplebucket",
#'   Key = "objectkey"
#' )}
#' 
#' # The following example uploads an object to a versioning-enabled bucket.
#' # The source file is specified using Windows file syntax. S3 returns
#' # VersionId of the newly created object.
#' \donttest{svc$put_object(
#'   Body = "HappyFace.jpg",
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg"
#' )}
#' 
#' # The following example uploads an object. The request specifies optional
#' # request headers to directs S3 to use specific storage class and use
#' # server-side encryption.
#' \donttest{svc$put_object(
#'   Body = "HappyFace.jpg",
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg",
#'   ServerSideEncryption = "AES256",
#'   StorageClass = "STANDARD_IA"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_object
s3_put_object <- function(ACL = NULL, Body = NULL, Bucket, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentLength = NULL, ContentMD5 = NULL, ContentType = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL) {
  op <- new_operation(
    name = "PutObject",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$put_object_input(ACL = ACL, Body = Body, Bucket = Bucket, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentLength = ContentLength, ContentMD5 = ContentMD5, ContentType = ContentType, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus)
  output <- .s3$put_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object <- s3_put_object

#' uses the acl subresource to set the access control list (ACL)
#' permissions for an object that already exists in a bucket
#'
#' uses the acl subresource to set the access control list (ACL)
#' permissions for an object that already exists in a bucket
#'
#' @usage
#' s3_put_object_acl(ACL, AccessControlPolicy, Bucket, ContentMD5,
#'   GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
#'   Key, RequestPayer, VersionId)
#'
#' @param ACL The canned ACL to apply to the object.
#' @param AccessControlPolicy Contains the elements that set the ACL permissions for an object per
#' grantee.
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' @param GrantWrite Allows grantee to create, overwrite, and delete any object in the
#' bucket.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' @param Key &#91;required&#93; 
#' @param RequestPayer 
#' @param VersionId VersionId used to reference a specific version of the object.
#'
#' @section Request syntax:
#' ```
#' svc$put_object_acl(
#'   ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'   AccessControlPolicy = list(
#'     Grants = list(
#'       list(
#'         Grantee = list(
#'           DisplayName = "string",
#'           EmailAddress = "string",
#'           ID = "string",
#'           Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
#'           URI = "string"
#'         ),
#'         Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
#'       )
#'     ),
#'     Owner = list(
#'       DisplayName = "string",
#'       ID = "string"
#'     )
#'   ),
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   GrantFullControl = "string",
#'   GrantRead = "string",
#'   GrantReadACP = "string",
#'   GrantWrite = "string",
#'   GrantWriteACP = "string",
#'   Key = "string",
#'   RequestPayer = "requester",
#'   VersionId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example adds grants to an object ACL. The first permission
#' # grants user1 and user2 FULL_CONTROL and the AllUsers group READ
#' # permission.
#' \donttest{svc$put_object_acl(
#'   AccessControlPolicy = structure(
#'     list(),
#'     .Names = character(
#'       0
#'     )
#'   ),
#'   Bucket = "examplebucket",
#'   GrantFullControl = "emailaddress=user1@example.com,emailaddress=user2@example.com",
#'   GrantRead = "uri=http://acs.amazonaws.com/groups/global/AllUsers",
#'   Key = "HappyFace.jpg"
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_object_acl
s3_put_object_acl <- function(ACL = NULL, AccessControlPolicy = NULL, Bucket, ContentMD5 = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, Key, RequestPayer = NULL, VersionId = NULL) {
  op <- new_operation(
    name = "PutObjectAcl",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?acl",
    paginator = list()
  )
  input <- .s3$put_object_acl_input(ACL = ACL, AccessControlPolicy = AccessControlPolicy, Bucket = Bucket, ContentMD5 = ContentMD5, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, Key = Key, RequestPayer = RequestPayer, VersionId = VersionId)
  output <- .s3$put_object_acl_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_acl <- s3_put_object_acl

#' Applies a Legal Hold configuration to the specified object
#'
#' Applies a Legal Hold configuration to the specified object.
#'
#' @usage
#' s3_put_object_legal_hold(Bucket, Key, LegalHold, RequestPayer,
#'   VersionId, ContentMD5)
#'
#' @param Bucket &#91;required&#93; The bucket containing the object that you want to place a Legal Hold on.
#' @param Key &#91;required&#93; The key name for the object that you want to place a Legal Hold on.
#' @param LegalHold Container element for the Legal Hold configuration you want to apply to
#' the specified object.
#' @param RequestPayer 
#' @param VersionId The version ID of the object that you want to place a Legal Hold on.
#' @param ContentMD5 The MD5 hash for the request body.
#'
#' @section Request syntax:
#' ```
#' svc$put_object_legal_hold(
#'   Bucket = "string",
#'   Key = "string",
#'   LegalHold = list(
#'     Status = "ON"|"OFF"
#'   ),
#'   RequestPayer = "requester",
#'   VersionId = "string",
#'   ContentMD5 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_object_legal_hold
s3_put_object_legal_hold <- function(Bucket, Key, LegalHold = NULL, RequestPayer = NULL, VersionId = NULL, ContentMD5 = NULL) {
  op <- new_operation(
    name = "PutObjectLegalHold",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?legal-hold",
    paginator = list()
  )
  input <- .s3$put_object_legal_hold_input(Bucket = Bucket, Key = Key, LegalHold = LegalHold, RequestPayer = RequestPayer, VersionId = VersionId, ContentMD5 = ContentMD5)
  output <- .s3$put_object_legal_hold_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_legal_hold <- s3_put_object_legal_hold

#' Places an object lock configuration on the specified bucket
#'
#' Places an object lock configuration on the specified bucket. The rule
#' specified in the object lock configuration will be applied by default to
#' every new object placed in the specified bucket.
#'
#' @usage
#' s3_put_object_lock_configuration(Bucket, ObjectLockConfiguration,
#'   RequestPayer, Token, ContentMD5)
#'
#' @param Bucket &#91;required&#93; The bucket whose object lock configuration you want to create or
#' replace.
#' @param ObjectLockConfiguration The object lock configuration that you want to apply to the specified
#' bucket.
#' @param RequestPayer 
#' @param Token A token to allow Amazon S3 object lock to be enabled for an existing
#' bucket.
#' @param ContentMD5 The MD5 hash for the request body.
#'
#' @section Request syntax:
#' ```
#' svc$put_object_lock_configuration(
#'   Bucket = "string",
#'   ObjectLockConfiguration = list(
#'     ObjectLockEnabled = "Enabled",
#'     Rule = list(
#'       DefaultRetention = list(
#'         Mode = "GOVERNANCE"|"COMPLIANCE",
#'         Days = 123,
#'         Years = 123
#'       )
#'     )
#'   ),
#'   RequestPayer = "requester",
#'   Token = "string",
#'   ContentMD5 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_object_lock_configuration
s3_put_object_lock_configuration <- function(Bucket, ObjectLockConfiguration = NULL, RequestPayer = NULL, Token = NULL, ContentMD5 = NULL) {
  op <- new_operation(
    name = "PutObjectLockConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?object-lock",
    paginator = list()
  )
  input <- .s3$put_object_lock_configuration_input(Bucket = Bucket, ObjectLockConfiguration = ObjectLockConfiguration, RequestPayer = RequestPayer, Token = Token, ContentMD5 = ContentMD5)
  output <- .s3$put_object_lock_configuration_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_lock_configuration <- s3_put_object_lock_configuration

#' Places an Object Retention configuration on an object
#'
#' Places an Object Retention configuration on an object.
#'
#' @usage
#' s3_put_object_retention(Bucket, Key, Retention, RequestPayer, VersionId,
#'   BypassGovernanceRetention, ContentMD5)
#'
#' @param Bucket &#91;required&#93; The bucket that contains the object you want to apply this Object
#' Retention configuration to.
#' @param Key &#91;required&#93; The key name for the object that you want to apply this Object Retention
#' configuration to.
#' @param Retention The container element for the Object Retention configuration.
#' @param RequestPayer 
#' @param VersionId The version ID for the object that you want to apply this Object
#' Retention configuration to.
#' @param BypassGovernanceRetention Indicates whether this operation should bypass Governance-mode
#' restrictions.j
#' @param ContentMD5 The MD5 hash for the request body.
#'
#' @section Request syntax:
#' ```
#' svc$put_object_retention(
#'   Bucket = "string",
#'   Key = "string",
#'   Retention = list(
#'     Mode = "GOVERNANCE"|"COMPLIANCE",
#'     RetainUntilDate = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   RequestPayer = "requester",
#'   VersionId = "string",
#'   BypassGovernanceRetention = TRUE|FALSE,
#'   ContentMD5 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_object_retention
s3_put_object_retention <- function(Bucket, Key, Retention = NULL, RequestPayer = NULL, VersionId = NULL, BypassGovernanceRetention = NULL, ContentMD5 = NULL) {
  op <- new_operation(
    name = "PutObjectRetention",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?retention",
    paginator = list()
  )
  input <- .s3$put_object_retention_input(Bucket = Bucket, Key = Key, Retention = Retention, RequestPayer = RequestPayer, VersionId = VersionId, BypassGovernanceRetention = BypassGovernanceRetention, ContentMD5 = ContentMD5)
  output <- .s3$put_object_retention_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_retention <- s3_put_object_retention

#' Sets the supplied tag-set to an object that already exists in a bucket
#'
#' Sets the supplied tag-set to an object that already exists in a bucket
#'
#' @usage
#' s3_put_object_tagging(Bucket, Key, VersionId, ContentMD5, Tagging)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param VersionId 
#' @param ContentMD5 
#' @param Tagging &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_object_tagging(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string",
#'   ContentMD5 = "string",
#'   Tagging = list(
#'     TagSet = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example adds tags to an existing object.
#' \donttest{svc$put_object_tagging(
#'   Bucket = "examplebucket",
#'   Key = "HappyFace.jpg",
#'   Tagging = list(
#'     TagSet = list(
#'       list(
#'         Key = "Key3",
#'         Value = "Value3"
#'       ),
#'       list(
#'         Key = "Key4",
#'         Value = "Value4"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_put_object_tagging
s3_put_object_tagging <- function(Bucket, Key, VersionId = NULL, ContentMD5 = NULL, Tagging) {
  op <- new_operation(
    name = "PutObjectTagging",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$put_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId, ContentMD5 = ContentMD5, Tagging = Tagging)
  output <- .s3$put_object_tagging_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_tagging <- s3_put_object_tagging

#' Creates or modifies the PublicAccessBlock configuration for an Amazon S3
#' bucket
#'
#' Creates or modifies the `PublicAccessBlock` configuration for an Amazon
#' S3 bucket.
#'
#' @usage
#' s3_put_public_access_block(Bucket, ContentMD5,
#'   PublicAccessBlockConfiguration)
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration
#' you want to set.
#' @param ContentMD5 The MD5 hash of the `PutPublicAccessBlock` request body.
#' @param PublicAccessBlockConfiguration &#91;required&#93; The `PublicAccessBlock` configuration that you want to apply to this
#' Amazon S3 bucket. You can enable the configuration options in any
#' combination. For more information about when Amazon S3 considers a
#' bucket or object public, see [The Meaning of
#' \"Public\"](https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status)
#' in the *Amazon Simple Storage Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$put_public_access_block(
#'   Bucket = "string",
#'   ContentMD5 = "string",
#'   PublicAccessBlockConfiguration = list(
#'     BlockPublicAcls = TRUE|FALSE,
#'     IgnorePublicAcls = TRUE|FALSE,
#'     BlockPublicPolicy = TRUE|FALSE,
#'     RestrictPublicBuckets = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_put_public_access_block
s3_put_public_access_block <- function(Bucket, ContentMD5 = NULL, PublicAccessBlockConfiguration) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$put_public_access_block_input(Bucket = Bucket, ContentMD5 = ContentMD5, PublicAccessBlockConfiguration = PublicAccessBlockConfiguration)
  output <- .s3$put_public_access_block_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_public_access_block <- s3_put_public_access_block

#' Restores an archived copy of an object back into Amazon S3
#'
#' Restores an archived copy of an object back into Amazon S3
#'
#' @usage
#' s3_restore_object(Bucket, Key, VersionId, RestoreRequest, RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param Key &#91;required&#93; 
#' @param VersionId 
#' @param RestoreRequest 
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$restore_object(
#'   Bucket = "string",
#'   Key = "string",
#'   VersionId = "string",
#'   RestoreRequest = list(
#'     Days = 123,
#'     GlacierJobParameters = list(
#'       Tier = "Standard"|"Bulk"|"Expedited"
#'     ),
#'     Type = "SELECT",
#'     Tier = "Standard"|"Bulk"|"Expedited",
#'     Description = "string",
#'     SelectParameters = list(
#'       InputSerialization = list(
#'         CSV = list(
#'           FileHeaderInfo = "USE"|"IGNORE"|"NONE",
#'           Comments = "string",
#'           QuoteEscapeCharacter = "string",
#'           RecordDelimiter = "string",
#'           FieldDelimiter = "string",
#'           QuoteCharacter = "string",
#'           AllowQuotedRecordDelimiter = TRUE|FALSE
#'         ),
#'         CompressionType = "NONE"|"GZIP"|"BZIP2",
#'         JSON = list(
#'           Type = "DOCUMENT"|"LINES"
#'         ),
#'         Parquet = list()
#'       ),
#'       ExpressionType = "SQL",
#'       Expression = "string",
#'       OutputSerialization = list(
#'         CSV = list(
#'           QuoteFields = "ALWAYS"|"ASNEEDED",
#'           QuoteEscapeCharacter = "string",
#'           RecordDelimiter = "string",
#'           FieldDelimiter = "string",
#'           QuoteCharacter = "string"
#'         ),
#'         JSON = list(
#'           RecordDelimiter = "string"
#'         )
#'       )
#'     ),
#'     OutputLocation = list(
#'       S3 = list(
#'         BucketName = "string",
#'         Prefix = "string",
#'         Encryption = list(
#'           EncryptionType = "AES256"|"aws:kms",
#'           KMSKeyId = "string",
#'           KMSContext = "string"
#'         ),
#'         CannedACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'         AccessControlList = list(
#'           list(
#'             Grantee = list(
#'               DisplayName = "string",
#'               EmailAddress = "string",
#'               ID = "string",
#'               Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
#'               URI = "string"
#'             ),
#'             Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
#'           )
#'         ),
#'         Tagging = list(
#'           TagSet = list(
#'             list(
#'               Key = "string",
#'               Value = "string"
#'             )
#'           )
#'         ),
#'         UserMetadata = list(
#'           list(
#'             Name = "string",
#'             Value = "string"
#'           )
#'         ),
#'         StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE"
#'       )
#'     )
#'   ),
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example restores for one day an archived copy of an object
#' # back into Amazon S3 bucket.
#' \donttest{svc$restore_object(
#'   Bucket = "examplebucket",
#'   Key = "archivedobjectkey",
#'   RestoreRequest = list(
#'     Days = 1L,
#'     GlacierJobParameters = list(
#'       Tier = "Expedited"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_restore_object
s3_restore_object <- function(Bucket, Key, VersionId = NULL, RestoreRequest = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "RestoreObject",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?restore",
    paginator = list()
  )
  input <- .s3$restore_object_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RestoreRequest = RestoreRequest, RequestPayer = RequestPayer)
  output <- .s3$restore_object_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$restore_object <- s3_restore_object

#' This operation filters the contents of an Amazon S3 object based on a
#' simple Structured Query Language (SQL) statement
#'
#' This operation filters the contents of an Amazon S3 object based on a
#' simple Structured Query Language (SQL) statement. In the request, along
#' with the SQL expression, you must also specify a data serialization
#' format (JSON or CSV) of the object. Amazon S3 uses this to parse object
#' data into records, and returns only records that match the specified SQL
#' expression. You must also specify the data serialization format for the
#' response.
#'
#' @usage
#' s3_select_object_content(Bucket, Key, SSECustomerAlgorithm,
#'   SSECustomerKey, SSECustomerKeyMD5, Expression, ExpressionType,
#'   RequestProgress, InputSerialization, OutputSerialization)
#'
#' @param Bucket &#91;required&#93; The S3 bucket.
#' @param Key &#91;required&#93; The object key.
#' @param SSECustomerAlgorithm The SSE Algorithm used to encrypt the object. For more information, see
#' [Server-Side Encryption (Using Customer-Provided Encryption
#' Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
#' @param SSECustomerKey The SSE Customer Key. For more information, see [Server-Side Encryption
#' (Using Customer-Provided Encryption
#' Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
#' @param SSECustomerKeyMD5 The SSE Customer Key MD5. For more information, see [Server-Side
#' Encryption (Using Customer-Provided Encryption
#' Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html).
#' @param Expression &#91;required&#93; The expression that is used to query the object.
#' @param ExpressionType &#91;required&#93; The type of the provided expression (for example., SQL).
#' @param RequestProgress Specifies if periodic request progress information should be enabled.
#' @param InputSerialization &#91;required&#93; Describes the format of the data in the object that is being queried.
#' @param OutputSerialization &#91;required&#93; Describes the format of the data that you want Amazon S3 to return in
#' response.
#'
#' @section Request syntax:
#' ```
#' svc$select_object_content(
#'   Bucket = "string",
#'   Key = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   Expression = "string",
#'   ExpressionType = "SQL",
#'   RequestProgress = list(
#'     Enabled = TRUE|FALSE
#'   ),
#'   InputSerialization = list(
#'     CSV = list(
#'       FileHeaderInfo = "USE"|"IGNORE"|"NONE",
#'       Comments = "string",
#'       QuoteEscapeCharacter = "string",
#'       RecordDelimiter = "string",
#'       FieldDelimiter = "string",
#'       QuoteCharacter = "string",
#'       AllowQuotedRecordDelimiter = TRUE|FALSE
#'     ),
#'     CompressionType = "NONE"|"GZIP"|"BZIP2",
#'     JSON = list(
#'       Type = "DOCUMENT"|"LINES"
#'     ),
#'     Parquet = list()
#'   ),
#'   OutputSerialization = list(
#'     CSV = list(
#'       QuoteFields = "ALWAYS"|"ASNEEDED",
#'       QuoteEscapeCharacter = "string",
#'       RecordDelimiter = "string",
#'       FieldDelimiter = "string",
#'       QuoteCharacter = "string"
#'     ),
#'     JSON = list(
#'       RecordDelimiter = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname s3_select_object_content
s3_select_object_content <- function(Bucket, Key, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, Expression, ExpressionType, RequestProgress = NULL, InputSerialization, OutputSerialization) {
  op <- new_operation(
    name = "SelectObjectContent",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?select&select-type=2",
    paginator = list()
  )
  input <- .s3$select_object_content_input(Bucket = Bucket, Key = Key, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, Expression = Expression, ExpressionType = ExpressionType, RequestProgress = RequestProgress, InputSerialization = InputSerialization, OutputSerialization = OutputSerialization)
  output <- .s3$select_object_content_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$select_object_content <- s3_select_object_content

#' Uploads a part in a multipart upload
#'
#' Uploads a part in a multipart upload.
#' 
#' **Note:** After you initiate multipart upload and upload one or more
#' parts, you must either complete or abort multipart upload in order to
#' stop getting charged for storage of the uploaded parts. Only after you
#' either complete or abort multipart upload, Amazon S3 frees up the parts
#' storage and stops charging you for the parts storage.
#'
#' @usage
#' s3_upload_part(Body, Bucket, ContentLength, ContentMD5, Key, PartNumber,
#'   UploadId, SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
#'   RequestPayer)
#'
#' @param Body Object data.
#' @param Bucket &#91;required&#93; Name of the bucket to which the multipart upload was initiated.
#' @param ContentLength Size of the body in bytes. This parameter is useful when the size of the
#' body cannot be determined automatically.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the part data. This parameter
#' is auto-populated when using the command from the CLI. This parameted is
#' required if object lock parameters are specified.
#' @param Key &#91;required&#93; Object key for which the multipart upload was initiated.
#' @param PartNumber &#91;required&#93; Part number of part being uploaded. This is a positive integer between 1
#' and 10,000.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose part is being uploaded.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header. This must be
#' the same encryption key specified in the initiate multipart upload
#' request.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$upload_part(
#'   Body = raw,
#'   Bucket = "string",
#'   ContentLength = 123,
#'   ContentMD5 = "string",
#'   Key = "string",
#'   PartNumber = 123,
#'   UploadId = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example uploads part 1 of a multipart upload. The example
#' # specifies a file name for the part data. The Upload ID is same that is
#' # returned by the initiate multipart upload.
#' \donttest{svc$upload_part(
#'   Body = "fileToUpload",
#'   Bucket = "examplebucket",
#'   Key = "examplelargeobject",
#'   PartNumber = "1",
#'   UploadId = "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_upload_part
s3_upload_part <- function(Body = NULL, Bucket, ContentLength = NULL, ContentMD5 = NULL, Key, PartNumber, UploadId, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "UploadPart",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$upload_part_input(Body = Body, Bucket = Bucket, ContentLength = ContentLength, ContentMD5 = ContentMD5, Key = Key, PartNumber = PartNumber, UploadId = UploadId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer)
  output <- .s3$upload_part_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$upload_part <- s3_upload_part

#' Uploads a part by copying data from an existing object as data source
#'
#' Uploads a part by copying data from an existing object as data source.
#'
#' @usage
#' s3_upload_part_copy(Bucket, CopySource, CopySourceIfMatch,
#'   CopySourceIfModifiedSince, CopySourceIfNoneMatch,
#'   CopySourceIfUnmodifiedSince, CopySourceRange, Key, PartNumber, UploadId,
#'   SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
#'   CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey,
#'   CopySourceSSECustomerKeyMD5, RequestPayer)
#'
#' @param Bucket &#91;required&#93; 
#' @param CopySource &#91;required&#93; The name of the source bucket and key name of the source object,
#' separated by a slash (/). Must be URL-encoded.
#' @param CopySourceIfMatch Copies the object if its entity tag (ETag) matches the specified tag.
#' @param CopySourceIfModifiedSince Copies the object if it has been modified since the specified time.
#' @param CopySourceIfNoneMatch Copies the object if its entity tag (ETag) is different than the
#' specified ETag.
#' @param CopySourceIfUnmodifiedSince Copies the object if it hasn\'t been modified since the specified time.
#' @param CopySourceRange The range of bytes to copy from the source object. The range value must
#' use the form bytes=first-last, where the first and last are the
#' zero-based byte offsets to copy. For example, bytes=0-9 indicates that
#' you want to copy the first ten bytes of the source. You can copy a range
#' only if the source object is greater than 5 MB.
#' @param Key &#91;required&#93; 
#' @param PartNumber &#91;required&#93; Part number of part being copied. This is a positive integer between 1
#' and 10,000.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose part is being copied.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (e.g.,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header. This must be
#' the same encryption key specified in the initiate multipart upload
#' request.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param CopySourceSSECustomerAlgorithm Specifies the algorithm to use when decrypting the source object (e.g.,
#' AES256).
#' @param CopySourceSSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use to
#' decrypt the source object. The encryption key provided in this header
#' must be one that was used when the source object was created.
#' @param CopySourceSSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' the encryption key was transmitted without error.
#' @param RequestPayer 
#'
#' @section Request syntax:
#' ```
#' svc$upload_part_copy(
#'   Bucket = "string",
#'   CopySource = "string",
#'   CopySourceIfMatch = "string",
#'   CopySourceIfModifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CopySourceIfNoneMatch = "string",
#'   CopySourceIfUnmodifiedSince = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CopySourceRange = "string",
#'   Key = "string",
#'   PartNumber = 123,
#'   UploadId = "string",
#'   SSECustomerAlgorithm = "string",
#'   SSECustomerKey = raw,
#'   SSECustomerKeyMD5 = "string",
#'   CopySourceSSECustomerAlgorithm = "string",
#'   CopySourceSSECustomerKey = raw,
#'   CopySourceSSECustomerKeyMD5 = "string",
#'   RequestPayer = "requester"
#' )
#' ```
#'
#' @examples
#' # The following example uploads a part of a multipart upload by copying
#' # data from an existing object as data source.
#' \donttest{svc$upload_part_copy(
#'   Bucket = "examplebucket",
#'   CopySource = "/bucketname/sourceobjectkey",
#'   Key = "examplelargeobject",
#'   PartNumber = "1",
#'   UploadId = "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP..."
#' )}
#' 
#' # The following example uploads a part of a multipart upload by copying a
#' # specified byte range from an existing object as data source.
#' \donttest{svc$upload_part_copy(
#'   Bucket = "examplebucket",
#'   CopySource = "/bucketname/sourceobjectkey",
#'   CopySourceRange = "bytes=1-100000",
#'   Key = "examplelargeobject",
#'   PartNumber = "2",
#'   UploadId = "exampleuoh_10OhKhT7YukE9bjzTPRiuaCotmZM_pFngJFir9OZNrSr5cWa3cq3LZSUsfjI4FI7PkP..."
#' )}
#'
#' @keywords internal
#'
#' @rdname s3_upload_part_copy
s3_upload_part_copy <- function(Bucket, CopySource, CopySourceIfMatch = NULL, CopySourceIfModifiedSince = NULL, CopySourceIfNoneMatch = NULL, CopySourceIfUnmodifiedSince = NULL, CopySourceRange = NULL, Key, PartNumber, UploadId, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, CopySourceSSECustomerAlgorithm = NULL, CopySourceSSECustomerKey = NULL, CopySourceSSECustomerKeyMD5 = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "UploadPartCopy",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$upload_part_copy_input(Bucket = Bucket, CopySource = CopySource, CopySourceIfMatch = CopySourceIfMatch, CopySourceIfModifiedSince = CopySourceIfModifiedSince, CopySourceIfNoneMatch = CopySourceIfNoneMatch, CopySourceIfUnmodifiedSince = CopySourceIfUnmodifiedSince, CopySourceRange = CopySourceRange, Key = Key, PartNumber = PartNumber, UploadId = UploadId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, CopySourceSSECustomerAlgorithm = CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey = CopySourceSSECustomerKey, CopySourceSSECustomerKeyMD5 = CopySourceSSECustomerKeyMD5, RequestPayer = RequestPayer)
  output <- .s3$upload_part_copy_output()
  svc <- .s3$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$upload_part_copy <- s3_upload_part_copy
