% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_select_object_content}
\alias{s3_select_object_content}
\title{This operation filters the contents of an Amazon S3 object based on a
simple Structured Query Language (SQL) statement}
\usage{
s3_select_object_content(Bucket, Key, SSECustomerAlgorithm,
  SSECustomerKey, SSECustomerKeyMD5, Expression, ExpressionType,
  RequestProgress, InputSerialization, OutputSerialization)
}
\arguments{
\item{Bucket}{[required] The S3 bucket.}

\item{Key}{[required] The object key.}

\item{SSECustomerAlgorithm}{The SSE Algorithm used to encrypt the object. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{SSECustomerKey}{The SSE Customer Key. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{SSECustomerKeyMD5}{The SSE Customer Key MD5. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html}{Server-Side Encryption (Using Customer-Provided Encryption Keys}.}

\item{Expression}{[required] The expression that is used to query the object.}

\item{ExpressionType}{[required] The type of the provided expression (for example., SQL).}

\item{RequestProgress}{Specifies if periodic request progress information should be enabled.}

\item{InputSerialization}{[required] Describes the format of the data in the object that is being queried.}

\item{OutputSerialization}{[required] Describes the format of the data that you want Amazon S3 to return in
response.}
}
\description{
This operation filters the contents of an Amazon S3 object based on a
simple Structured Query Language (SQL) statement. In the request, along
with the SQL expression, you must also specify a data serialization
format (JSON or CSV) of the object. Amazon S3 uses this to parse object
data into records, and returns only records that match the specified SQL
expression. You must also specify the data serialization format for the
response.
}
\section{Request syntax}{
\preformatted{svc$select_object_content(
  Bucket = "string",
  Key = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  Expression = "string",
  ExpressionType = "SQL",
  RequestProgress = list(
    Enabled = TRUE|FALSE
  ),
  InputSerialization = list(
    CSV = list(
      FileHeaderInfo = "USE"|"IGNORE"|"NONE",
      Comments = "string",
      QuoteEscapeCharacter = "string",
      RecordDelimiter = "string",
      FieldDelimiter = "string",
      QuoteCharacter = "string",
      AllowQuotedRecordDelimiter = TRUE|FALSE
    ),
    CompressionType = "NONE"|"GZIP"|"BZIP2",
    JSON = list(
      Type = "DOCUMENT"|"LINES"
    ),
    Parquet = list()
  ),
  OutputSerialization = list(
    CSV = list(
      QuoteFields = "ALWAYS"|"ASNEEDED",
      QuoteEscapeCharacter = "string",
      RecordDelimiter = "string",
      FieldDelimiter = "string",
      QuoteCharacter = "string"
    ),
    JSON = list(
      RecordDelimiter = "string"
    )
  )
)
}
}

\keyword{internal}
