% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_request_payment}
\alias{s3_put_bucket_request_payment}
\title{Sets the request payment configuration for a bucket}
\usage{
s3_put_bucket_request_payment(Bucket, ContentMD5,
  RequestPaymentConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{RequestPaymentConfiguration}{[required]}
}
\description{
Sets the request payment configuration for a bucket. By default, the
bucket owner pays for downloads from the bucket. This configuration
parameter enables the bucket owner (only) to specify that the person
requesting the download will be charged for the download. Documentation
on requester pays buckets can be found at
http://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html
}
\section{Request syntax}{
\preformatted{svc$put_bucket_request_payment(
  Bucket = "string",
  ContentMD5 = "string",
  RequestPaymentConfiguration = list(
    Payer = "Requester"|"BucketOwner"
  )
)
}
}

\examples{
# The following example sets request payment configuration on a bucket so
# that person requesting the download is charged.
\donttest{svc$put_bucket_request_payment(
  Bucket = "examplebucket",
  RequestPaymentConfiguration = list(
    Payer = "Requester"
  )
)}

}
\keyword{internal}
