# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include guardduty_service.R
NULL

#' Accepts the invitation to be a member account and get monitored by a
#' GuardDuty administrator account that sent the invitation
#'
#' @description
#' Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent the invitation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_accept_administrator_invitation/](https://www.paws-r-sdk.com/docs/guardduty_accept_administrator_invitation/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param AdministratorId &#91;required&#93; The account ID of the GuardDuty administrator account whose invitation
#' you're accepting.
#' @param InvitationId &#91;required&#93; The value that is used to validate the administrator account to the
#' member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_administrator_invitation
guardduty_accept_administrator_invitation <- function(DetectorId, AdministratorId, InvitationId) {
  op <- new_operation(
    name = "AcceptAdministratorInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/administrator",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$accept_administrator_invitation_input(DetectorId = DetectorId, AdministratorId = AdministratorId, InvitationId = InvitationId)
  output <- .guardduty$accept_administrator_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_administrator_invitation <- guardduty_accept_administrator_invitation

#' Accepts the invitation to be monitored by a GuardDuty administrator
#' account
#'
#' @description
#' Accepts the invitation to be monitored by a GuardDuty administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_accept_invitation/](https://www.paws-r-sdk.com/docs/guardduty_accept_invitation/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MasterId &#91;required&#93; The account ID of the GuardDuty administrator account whose invitation
#' you're accepting.
#' @param InvitationId &#91;required&#93; The value that is used to validate the administrator account to the
#' member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_invitation
guardduty_accept_invitation <- function(DetectorId, MasterId, InvitationId) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$accept_invitation_input(DetectorId = DetectorId, MasterId = MasterId, InvitationId = InvitationId)
  output <- .guardduty$accept_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_invitation <- guardduty_accept_invitation

#' Archives GuardDuty findings that are specified by the list of finding
#' IDs
#'
#' @description
#' Archives GuardDuty findings that are specified by the list of finding IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_archive_findings/](https://www.paws-r-sdk.com/docs/guardduty_archive_findings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to archive.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to archive.
#'
#' @keywords internal
#'
#' @rdname guardduty_archive_findings
guardduty_archive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "ArchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/archive",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$archive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$archive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$archive_findings <- guardduty_archive_findings

#' Creates a single GuardDuty detector
#'
#' @description
#' Creates a single GuardDuty detector. A detector is a resource that represents the GuardDuty service. To start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only one detector per account per Region. All data sources are enabled in a new detector by default.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_detector/](https://www.paws-r-sdk.com/docs/guardduty_create_detector/) for full documentation.
#'
#' @param Enable &#91;required&#93; A Boolean value that specifies whether the detector is to be enabled.
#' @param ClientToken The idempotency token for the create request.
#' @param FindingPublishingFrequency A value that specifies how frequently updated findings are exported.
#' @param DataSources Describes which data sources will be enabled for the detector.
#' 
#' There might be regional differences because some data sources might not
#' be available in all the Amazon Web Services Regions where GuardDuty is
#' presently supported. For more information, see [Regions and
#' endpoints](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html).
#' @param Tags The tags to be added to a new detector resource.
#' @param Features A list of features that will be configured for the detector.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_detector
guardduty_create_detector <- function(Enable, ClientToken = NULL, FindingPublishingFrequency = NULL, DataSources = NULL, Tags = NULL, Features = NULL) {
  op <- new_operation(
    name = "CreateDetector",
    http_method = "POST",
    http_path = "/detector",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_detector_input(Enable = Enable, ClientToken = ClientToken, FindingPublishingFrequency = FindingPublishingFrequency, DataSources = DataSources, Tags = Tags, Features = Features)
  output <- .guardduty$create_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_detector <- guardduty_create_detector

#' Creates a filter using the specified finding criteria
#'
#' @description
#' Creates a filter using the specified finding criteria. The maximum number of saved filters per Amazon Web Services account per Region is 100. For more information, see [Quotas for GuardDuty](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_limits.html).
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_filter/](https://www.paws-r-sdk.com/docs/guardduty_create_filter/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID associated with the GuardDuty account for which you want
#' to create a filter.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param Name &#91;required&#93; The name of the filter. Valid characters include period (.), underscore
#' (_), dash (-), and alphanumeric characters. A whitespace is considered
#' to be an invalid character.
#' @param Description The description of the filter. Valid characters include alphanumeric
#' characters, and special characters such as hyphen, period, colon,
#' underscore, parentheses (`{ }`, `[ ]`, and `( )`), forward slash,
#' horizontal tab, vertical tab, newline, form feed, return, and
#' whitespace.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria &#91;required&#93; Represents the criteria to be used in the filter for querying findings.
#' 
#' You can only use the following attributes to query findings:
#' 
#' -   accountId
#' 
#' -   id
#' 
#' -   region
#' 
#' -   severity
#' 
#'     To filter on the basis of severity, the API and CLI use the
#'     following input list for the
#'     [FindingCriteria](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_FindingCriteria.html)
#'     condition:
#' 
#'     -   **Low**: `["1", "2", "3"]`
#' 
#'     -   **Medium**: `["4", "5", "6"]`
#' 
#'     -   **High**: `["7", "8"]`
#' 
#'     -   **Critical**: `["9", "10"]`
#' 
#'     For more information, see [Findings severity
#'     levels](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings-severity.html)
#'     in the *Amazon GuardDuty User Guide*.
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
#'     YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains
#'     milliseconds.
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.outpostArn
#' 
#' -   resource.resourceType
#' 
#' -   resource.s3BucketDetails.publicAccess.effectivePermissions
#' 
#' -   resource.s3BucketDetails.name
#' 
#' -   resource.s3BucketDetails.tags.key
#' 
#' -   resource.s3BucketDetails.tags.value
#' 
#' -   resource.s3BucketDetails.type
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.errorCode
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV6
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.dnsRequestAction.domainWithSuffix
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV6
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.action.awsApiCallAction.remoteAccountDetails.affiliated
#' 
#' -   service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.kubernetesApiCallAction.remoteIpDetails.ipAddressV6
#' 
#' -   service.action.kubernetesApiCallAction.namespace
#' 
#' -   service.action.kubernetesApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.kubernetesApiCallAction.requestUri
#' 
#' -   service.action.kubernetesApiCallAction.statusCode
#' 
#' -   service.action.networkConnectionAction.localIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.localIpDetails.ipAddressV6
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.awsApiCallAction.remoteAccountDetails.accountId
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   service.resourceRole
#' 
#' -   resource.eksClusterDetails.name
#' 
#' -   resource.kubernetesDetails.kubernetesWorkloadDetails.name
#' 
#' -   resource.kubernetesDetails.kubernetesWorkloadDetails.namespace
#' 
#' -   resource.kubernetesDetails.kubernetesUserDetails.username
#' 
#' -   resource.kubernetesDetails.kubernetesWorkloadDetails.containers.image
#' 
#' -   resource.kubernetesDetails.kubernetesWorkloadDetails.containers.imagePrefix
#' 
#' -   service.ebsVolumeScanDetails.scanId
#' 
#' -   service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.name
#' 
#' -   service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.severity
#' 
#' -   service.ebsVolumeScanDetails.scanDetections.threatDetectedByName.threatNames.filePaths.hash
#' 
#' -   resource.ecsClusterDetails.name
#' 
#' -   resource.ecsClusterDetails.taskDetails.containers.image
#' 
#' -   resource.ecsClusterDetails.taskDetails.definitionArn
#' 
#' -   resource.containerDetails.image
#' 
#' -   resource.rdsDbInstanceDetails.dbInstanceIdentifier
#' 
#' -   resource.rdsDbInstanceDetails.dbClusterIdentifier
#' 
#' -   resource.rdsDbInstanceDetails.engine
#' 
#' -   resource.rdsDbUserDetails.user
#' 
#' -   resource.rdsDbInstanceDetails.tags.key
#' 
#' -   resource.rdsDbInstanceDetails.tags.value
#' 
#' -   service.runtimeDetails.process.executableSha256
#' 
#' -   service.runtimeDetails.process.name
#' 
#' -   service.runtimeDetails.process.name
#' 
#' -   resource.lambdaDetails.functionName
#' 
#' -   resource.lambdaDetails.functionArn
#' 
#' -   resource.lambdaDetails.tags.key
#' 
#' -   resource.lambdaDetails.tags.value
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new filter resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_filter
guardduty_create_filter <- function(DetectorId, Name, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_filter_input(DetectorId = DetectorId, Name = Name, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_filter <- guardduty_create_filter

#' Creates a new IPSet, which is called a trusted IP list in the console
#' user interface
#'
#' @description
#' Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications. GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the administrator account can use this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_ip_set/](https://www.paws-r-sdk.com/docs/guardduty_create_ip_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to create an IPSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param Name &#91;required&#93; The user-friendly name to identify the IPSet.
#' 
#' Allowed characters are alphanumeric, whitespace, dash (-), and
#' underscores (_).
#' @param Format &#91;required&#93; The format of the file that contains the IPSet.
#' @param Location &#91;required&#93; The URI of the file that contains the IPSet.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded IPSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new IP set resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_ip_set
guardduty_create_ip_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_ip_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_ip_set <- guardduty_create_ip_set

#' Creates a new Malware Protection plan for the protected resource
#'
#' @description
#' Creates a new Malware Protection plan for the protected resource.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_malware_protection_plan/](https://www.paws-r-sdk.com/docs/guardduty_create_malware_protection_plan/) for full documentation.
#'
#' @param ClientToken The idempotency token for the create request.
#' @param Role &#91;required&#93; Amazon Resource Name (ARN) of the IAM role that has the permissions to
#' scan and add tags to the associated protected resource.
#' @param ProtectedResource &#91;required&#93; Information about the protected resource that is associated with the
#' created Malware Protection plan. Presently, `S3Bucket` is the only
#' supported protected resource.
#' @param Actions Information about whether the tags will be added to the S3 object after
#' scanning.
#' @param Tags Tags added to the Malware Protection plan resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_malware_protection_plan
guardduty_create_malware_protection_plan <- function(ClientToken = NULL, Role, ProtectedResource, Actions = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMalwareProtectionPlan",
    http_method = "POST",
    http_path = "/malware-protection-plan",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_malware_protection_plan_input(ClientToken = ClientToken, Role = Role, ProtectedResource = ProtectedResource, Actions = Actions, Tags = Tags)
  output <- .guardduty$create_malware_protection_plan_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_malware_protection_plan <- guardduty_create_malware_protection_plan

#' Creates member accounts of the current Amazon Web Services account by
#' specifying a list of Amazon Web Services account IDs
#'
#' @description
#' Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or through an organization.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_members/](https://www.paws-r-sdk.com/docs/guardduty_create_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to associate member accounts.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountDetails &#91;required&#93; A list of account ID and email address pairs of the accounts that you
#' want to associate with the GuardDuty administrator account.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_members
guardduty_create_members <- function(DetectorId, AccountDetails) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_members_input(DetectorId = DetectorId, AccountDetails = AccountDetails)
  output <- .guardduty$create_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_members <- guardduty_create_members

#' Creates a publishing destination where you can export your GuardDuty
#' findings
#'
#' @description
#' Creates a publishing destination where you can export your GuardDuty findings. Before you start exporting the findings, the destination resource must exist.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_publishing_destination/](https://www.paws-r-sdk.com/docs/guardduty_create_publishing_destination/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the GuardDuty detector associated with the publishing
#' destination.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param DestinationType &#91;required&#93; The type of resource for the publishing destination. Currently only
#' Amazon S3 buckets are supported.
#' @param DestinationProperties &#91;required&#93; The properties of the publishing destination, including the ARNs for the
#' destination and the KMS key used for encryption.
#' @param ClientToken The idempotency token for the request.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_publishing_destination
guardduty_create_publishing_destination <- function(DetectorId, DestinationType, DestinationProperties, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_publishing_destination_input(DetectorId = DetectorId, DestinationType = DestinationType, DestinationProperties = DestinationProperties, ClientToken = ClientToken)
  output <- .guardduty$create_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_publishing_destination <- guardduty_create_publishing_destination

#' Generates sample findings of types specified by the list of finding
#' types
#'
#' @description
#' Generates sample findings of types specified by the list of finding types. If 'NULL' is specified for `findingTypes`, the API generates sample findings of all supported finding types.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_sample_findings/](https://www.paws-r-sdk.com/docs/guardduty_create_sample_findings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector for which you need to create sample findings.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingTypes The types of sample findings to generate.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_sample_findings
guardduty_create_sample_findings <- function(DetectorId, FindingTypes = NULL) {
  op <- new_operation(
    name = "CreateSampleFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/create",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_sample_findings_input(DetectorId = DetectorId, FindingTypes = FindingTypes)
  output <- .guardduty$create_sample_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_sample_findings <- guardduty_create_sample_findings

#' Creates a new ThreatIntelSet
#'
#' @description
#' Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_create_threat_intel_set/](https://www.paws-r-sdk.com/docs/guardduty_create_threat_intel_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account for which you
#' want to create a `ThreatIntelSet`.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param Name &#91;required&#93; A user-friendly ThreatIntelSet name displayed in all findings that are
#' generated by activity that involves IP addresses included in this
#' ThreatIntelSet.
#' @param Format &#91;required&#93; The format of the file that contains the ThreatIntelSet.
#' @param Location &#91;required&#93; The URI of the file that contains the ThreatIntelSet.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded ThreatIntelSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new threat list resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_threat_intel_set
guardduty_create_threat_intel_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$create_threat_intel_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_threat_intel_set <- guardduty_create_threat_intel_set

#' Declines invitations sent to the current member account by Amazon Web
#' Services accounts specified by their account IDs
#'
#' @description
#' Declines invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_decline_invitations/](https://www.paws-r-sdk.com/docs/guardduty_decline_invitations/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the Amazon Web Services accounts that sent
#' invitations to the current member account that you want to decline
#' invitations from.
#'
#' @keywords internal
#'
#' @rdname guardduty_decline_invitations
guardduty_decline_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitation/decline",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$decline_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$decline_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$decline_invitations <- guardduty_decline_invitations

#' Deletes an Amazon GuardDuty detector that is specified by the detector
#' ID
#'
#' @description
#' Deletes an Amazon GuardDuty detector that is specified by the detector ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_detector/](https://www.paws-r-sdk.com/docs/guardduty_delete_detector/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to delete.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_detector
guardduty_delete_detector <- function(DetectorId) {
  op <- new_operation(
    name = "DeleteDetector",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_detector_input(DetectorId = DetectorId)
  output <- .guardduty$delete_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_detector <- guardduty_delete_detector

#' Deletes the filter specified by the filter name
#'
#' @description
#' Deletes the filter specified by the filter name.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_filter/](https://www.paws-r-sdk.com/docs/guardduty_delete_filter/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the filter.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FilterName &#91;required&#93; The name of the filter that you want to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_filter
guardduty_delete_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$delete_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_filter <- guardduty_delete_filter

#' Deletes the IPSet specified by the ipSetId
#'
#' @description
#' Deletes the IPSet specified by the `ipSetId`. IPSets are called trusted IP lists in the console user interface.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_ip_set/](https://www.paws-r-sdk.com/docs/guardduty_delete_ip_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the IPSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_ip_set
guardduty_delete_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$delete_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_ip_set <- guardduty_delete_ip_set

#' Deletes invitations sent to the current member account by Amazon Web
#' Services accounts specified by their account IDs
#'
#' @description
#' Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_invitations/](https://www.paws-r-sdk.com/docs/guardduty_delete_invitations/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the Amazon Web Services accounts that sent
#' invitations to the current member account that you want to delete
#' invitations from.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_invitations
guardduty_delete_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitation/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$delete_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_invitations <- guardduty_delete_invitations

#' Deletes the Malware Protection plan ID associated with the Malware
#' Protection plan resource
#'
#' @description
#' Deletes the Malware Protection plan ID associated with the Malware Protection plan resource. Use this API only when you no longer want to protect the resource associated with this Malware Protection plan ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_malware_protection_plan/](https://www.paws-r-sdk.com/docs/guardduty_delete_malware_protection_plan/) for full documentation.
#'
#' @param MalwareProtectionPlanId &#91;required&#93; A unique identifier associated with Malware Protection plan resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_malware_protection_plan
guardduty_delete_malware_protection_plan <- function(MalwareProtectionPlanId) {
  op <- new_operation(
    name = "DeleteMalwareProtectionPlan",
    http_method = "DELETE",
    http_path = "/malware-protection-plan/{malwareProtectionPlanId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_malware_protection_plan_input(MalwareProtectionPlanId = MalwareProtectionPlanId)
  output <- .guardduty$delete_malware_protection_plan_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_malware_protection_plan <- guardduty_delete_malware_protection_plan

#' Deletes GuardDuty member accounts (to the current GuardDuty
#' administrator account) specified by the account IDs
#'
#' @description
#' Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_members/](https://www.paws-r-sdk.com/docs/guardduty_delete_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to delete.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_members
guardduty_delete_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$delete_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_members <- guardduty_delete_members

#' Deletes the publishing definition with the specified destinationId
#'
#' @description
#' Deletes the publishing definition with the specified `destinationId`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_publishing_destination/](https://www.paws-r-sdk.com/docs/guardduty_delete_publishing_destination/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to delete.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_publishing_destination
guardduty_delete_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DeletePublishingDestination",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$delete_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_publishing_destination <- guardduty_delete_publishing_destination

#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' @description
#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_delete_threat_intel_set/](https://www.paws-r-sdk.com/docs/guardduty_delete_threat_intel_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the
#' threatIntelSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_threat_intel_set
guardduty_delete_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "DeleteThreatIntelSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$delete_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$delete_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_threat_intel_set <- guardduty_delete_threat_intel_set

#' Returns a list of malware scans
#'
#' @description
#' Returns a list of malware scans. Each member account can view the malware scans for their own accounts. An administrator can view the malware scans for all the member accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_describe_malware_scans/](https://www.paws-r-sdk.com/docs/guardduty_describe_malware_scans/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the request is associated with.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param FilterCriteria Represents the criteria to be used in the filter for describing scan
#' entries.
#' @param SortCriteria Represents the criteria used for sorting scan entries. The
#' [`attributeName`](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_SortCriteria.html#guardduty-Type-SortCriteria-attributeName)
#' is required and it must be `scanStartTime`.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_malware_scans
guardduty_describe_malware_scans <- function(DetectorId, NextToken = NULL, MaxResults = NULL, FilterCriteria = NULL, SortCriteria = NULL) {
  op <- new_operation(
    name = "DescribeMalwareScans",
    http_method = "POST",
    http_path = "/detector/{detectorId}/malware-scans",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Scans"),
    stream_api = FALSE
  )
  input <- .guardduty$describe_malware_scans_input(DetectorId = DetectorId, NextToken = NextToken, MaxResults = MaxResults, FilterCriteria = FilterCriteria, SortCriteria = SortCriteria)
  output <- .guardduty$describe_malware_scans_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_malware_scans <- guardduty_describe_malware_scans

#' Returns information about the account selected as the delegated
#' administrator for GuardDuty
#'
#' @description
#' Returns information about the account selected as the delegated administrator for GuardDuty.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_describe_organization_configuration/](https://www.paws-r-sdk.com/docs/guardduty_describe_organization_configuration/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID of the delegated administrator for which you need to
#' retrieve the information.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill `nextToken` in the request with the
#' value of `NextToken` from the previous response to continue listing
#' data.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_organization_configuration
guardduty_describe_organization_configuration <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/detector/{detectorId}/admin",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .guardduty$describe_organization_configuration_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$describe_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_organization_configuration <- guardduty_describe_organization_configuration

#' Returns information about the publishing destination specified by the
#' provided destinationId
#'
#' @description
#' Returns information about the publishing destination specified by the provided `destinationId`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_describe_publishing_destination/](https://www.paws-r-sdk.com/docs/guardduty_describe_publishing_destination/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to retrieve.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_publishing_destination
guardduty_describe_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DescribePublishingDestination",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$describe_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$describe_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_publishing_destination <- guardduty_describe_publishing_destination

#' Removes the existing GuardDuty delegated administrator of the
#' organization
#'
#' @description
#' Removes the existing GuardDuty delegated administrator of the organization. Only the organization's management account can run this API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_disable_organization_admin_account/](https://www.paws-r-sdk.com/docs/guardduty_disable_organization_admin_account/) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services Account ID for the organizations account to be
#' disabled as a GuardDuty delegated administrator.
#'
#' @keywords internal
#'
#' @rdname guardduty_disable_organization_admin_account
guardduty_disable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/disable",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$disable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disable_organization_admin_account <- guardduty_disable_organization_admin_account

#' Disassociates the current GuardDuty member account from its
#' administrator account
#'
#' @description
#' Disassociates the current GuardDuty member account from its administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_disassociate_from_administrator_account/](https://www.paws-r-sdk.com/docs/guardduty_disassociate_from_administrator_account/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_administrator_account
guardduty_disassociate_from_administrator_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromAdministratorAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/administrator/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$disassociate_from_administrator_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_administrator_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_administrator_account <- guardduty_disassociate_from_administrator_account

#' Disassociates the current GuardDuty member account from its
#' administrator account
#'
#' @description
#' Disassociates the current GuardDuty member account from its administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_disassociate_from_master_account/](https://www.paws-r-sdk.com/docs/guardduty_disassociate_from_master_account/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_master_account
guardduty_disassociate_from_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$disassociate_from_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_master_account <- guardduty_disassociate_from_master_account

#' Disassociates GuardDuty member accounts (from the current administrator
#' account) specified by the account IDs
#'
#' @description
#' Disassociates GuardDuty member accounts (from the current administrator account) specified by the account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_disassociate_members/](https://www.paws-r-sdk.com/docs/guardduty_disassociate_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to disassociate from the administrator account.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' disassociate from the administrator account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_members
guardduty_disassociate_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$disassociate_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$disassociate_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_members <- guardduty_disassociate_members

#' Designates an Amazon Web Services account within the organization as
#' your GuardDuty delegated administrator
#'
#' @description
#' Designates an Amazon Web Services account within the organization as your GuardDuty delegated administrator. Only the organization's management account can run this API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_enable_organization_admin_account/](https://www.paws-r-sdk.com/docs/guardduty_enable_organization_admin_account/) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services account ID for the organization account to be
#' enabled as a GuardDuty delegated administrator.
#'
#' @keywords internal
#'
#' @rdname guardduty_enable_organization_admin_account
guardduty_enable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/enable",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$enable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$enable_organization_admin_account <- guardduty_enable_organization_admin_account

#' Provides the details of the GuardDuty administrator account associated
#' with the current GuardDuty member account
#'
#' @description
#' Provides the details of the GuardDuty administrator account associated with the current GuardDuty member account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_administrator_account/](https://www.paws-r-sdk.com/docs/guardduty_get_administrator_account/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_administrator_account
guardduty_get_administrator_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetAdministratorAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/administrator",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_administrator_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_administrator_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_administrator_account <- guardduty_get_administrator_account

#' Retrieves aggregated statistics for your account
#'
#' @description
#' Retrieves aggregated statistics for your account. If you are a GuardDuty administrator, you can retrieve the statistics for all the resources associated with the active member accounts in your organization who have enabled Runtime Monitoring and have the GuardDuty security agent running on their resources.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_coverage_statistics/](https://www.paws-r-sdk.com/docs/guardduty_get_coverage_statistics/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the GuardDuty detector.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FilterCriteria Represents the criteria used to filter the coverage statistics.
#' @param StatisticsType &#91;required&#93; Represents the statistics type used to aggregate the coverage details.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_coverage_statistics
guardduty_get_coverage_statistics <- function(DetectorId, FilterCriteria = NULL, StatisticsType) {
  op <- new_operation(
    name = "GetCoverageStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/coverage/statistics",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_coverage_statistics_input(DetectorId = DetectorId, FilterCriteria = FilterCriteria, StatisticsType = StatisticsType)
  output <- .guardduty$get_coverage_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_coverage_statistics <- guardduty_get_coverage_statistics

#' Retrieves a GuardDuty detector specified by the detectorId
#'
#' @description
#' Retrieves a GuardDuty detector specified by the detectorId.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_detector/](https://www.paws-r-sdk.com/docs/guardduty_get_detector/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to get.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_detector
guardduty_get_detector <- function(DetectorId) {
  op <- new_operation(
    name = "GetDetector",
    http_method = "GET",
    http_path = "/detector/{detectorId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_detector_input(DetectorId = DetectorId)
  output <- .guardduty$get_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_detector <- guardduty_get_detector

#' Returns the details of the filter specified by the filter name
#'
#' @description
#' Returns the details of the filter specified by the filter name.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_filter/](https://www.paws-r-sdk.com/docs/guardduty_get_filter/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with this filter.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FilterName &#91;required&#93; The name of the filter you want to get.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_filter
guardduty_get_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "GetFilter",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$get_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_filter <- guardduty_get_filter

#' Describes Amazon GuardDuty findings specified by finding IDs
#'
#' @description
#' Describes Amazon GuardDuty findings specified by finding IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_findings/](https://www.paws-r-sdk.com/docs/guardduty_get_findings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to retrieve.
#' @param SortCriteria Represents the criteria used for sorting findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings
guardduty_get_findings <- function(DetectorId, FindingIds, SortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_findings_input(DetectorId = DetectorId, FindingIds = FindingIds, SortCriteria = SortCriteria)
  output <- .guardduty$get_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings <- guardduty_get_findings

#' Lists GuardDuty findings statistics for the specified detector ID
#'
#' @description
#' Lists GuardDuty findings statistics for the specified detector ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_findings_statistics/](https://www.paws-r-sdk.com/docs/guardduty_get_findings_statistics/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector whose findings statistics you want to retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingStatisticTypes The types of finding statistics to retrieve.
#' @param FindingCriteria Represents the criteria that is used for querying findings.
#' @param GroupBy Displays the findings statistics grouped by one of the listed valid
#' values.
#' @param OrderBy Displays the sorted findings in the requested order. The default value
#' of `orderBy` is `DESC`.
#' 
#' You can use this parameter only with the `groupBy` parameter.
#' @param MaxResults The maximum number of results to be returned in the response. The
#' default value is 25.
#' 
#' You can use this parameter only with the `groupBy` parameter.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings_statistics
guardduty_get_findings_statistics <- function(DetectorId, FindingStatisticTypes = NULL, FindingCriteria = NULL, GroupBy = NULL, OrderBy = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetFindingsStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/statistics",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_findings_statistics_input(DetectorId = DetectorId, FindingStatisticTypes = FindingStatisticTypes, FindingCriteria = FindingCriteria, GroupBy = GroupBy, OrderBy = OrderBy, MaxResults = MaxResults)
  output <- .guardduty$get_findings_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings_statistics <- guardduty_get_findings_statistics

#' Retrieves the IPSet specified by the ipSetId
#'
#' @description
#' Retrieves the IPSet specified by the `ipSetId`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_ip_set/](https://www.paws-r-sdk.com/docs/guardduty_get_ip_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the IPSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to retrieve.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_ip_set
guardduty_get_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$get_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_ip_set <- guardduty_get_ip_set

#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation
#'
#' @description
#' Returns the count of all GuardDuty membership invitations that were sent to the current member account except the currently accepted invitation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_invitations_count/](https://www.paws-r-sdk.com/docs/guardduty_get_invitations_count/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname guardduty_get_invitations_count
guardduty_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitation/count",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_invitations_count_input()
  output <- .guardduty$get_invitations_count_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_invitations_count <- guardduty_get_invitations_count

#' Retrieves the Malware Protection plan details associated with a Malware
#' Protection plan ID
#'
#' @description
#' Retrieves the Malware Protection plan details associated with a Malware Protection plan ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_malware_protection_plan/](https://www.paws-r-sdk.com/docs/guardduty_get_malware_protection_plan/) for full documentation.
#'
#' @param MalwareProtectionPlanId &#91;required&#93; A unique identifier associated with Malware Protection plan resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_malware_protection_plan
guardduty_get_malware_protection_plan <- function(MalwareProtectionPlanId) {
  op <- new_operation(
    name = "GetMalwareProtectionPlan",
    http_method = "GET",
    http_path = "/malware-protection-plan/{malwareProtectionPlanId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_malware_protection_plan_input(MalwareProtectionPlanId = MalwareProtectionPlanId)
  output <- .guardduty$get_malware_protection_plan_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_malware_protection_plan <- guardduty_get_malware_protection_plan

#' Returns the details of the malware scan settings
#'
#' @description
#' Returns the details of the malware scan settings.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_malware_scan_settings/](https://www.paws-r-sdk.com/docs/guardduty_get_malware_scan_settings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with this scan.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_malware_scan_settings
guardduty_get_malware_scan_settings <- function(DetectorId) {
  op <- new_operation(
    name = "GetMalwareScanSettings",
    http_method = "GET",
    http_path = "/detector/{detectorId}/malware-scan-settings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_malware_scan_settings_input(DetectorId = DetectorId)
  output <- .guardduty$get_malware_scan_settings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_malware_scan_settings <- guardduty_get_malware_scan_settings

#' Provides the details for the GuardDuty administrator account associated
#' with the current GuardDuty member account
#'
#' @description
#' Provides the details for the GuardDuty administrator account associated with the current GuardDuty member account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_master_account/](https://www.paws-r-sdk.com/docs/guardduty_get_master_account/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_master_account
guardduty_get_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/master",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_master_account <- guardduty_get_master_account

#' Describes which data sources are enabled for the member account's
#' detector
#'
#' @description
#' Describes which data sources are enabled for the member account's detector.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_member_detectors/](https://www.paws-r-sdk.com/docs/guardduty_get_member_detectors/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID for the administrator account.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of member account IDs.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_member_detectors
guardduty_get_member_detectors <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMemberDetectors",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/detector/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_member_detectors_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_member_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_member_detectors <- guardduty_get_member_detectors

#' Retrieves GuardDuty member accounts (of the current GuardDuty
#' administrator account) specified by the account IDs
#'
#' @description
#' Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_members/](https://www.paws-r-sdk.com/docs/guardduty_get_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' describe.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_members
guardduty_get_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_members <- guardduty_get_members

#' Retrieves how many active member accounts have each feature enabled
#' within GuardDuty
#'
#' @description
#' Retrieves how many active member accounts have each feature enabled within GuardDuty. Only a delegated GuardDuty administrator of an organization can run this API.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_organization_statistics/](https://www.paws-r-sdk.com/docs/guardduty_get_organization_statistics/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname guardduty_get_organization_statistics
guardduty_get_organization_statistics <- function() {
  op <- new_operation(
    name = "GetOrganizationStatistics",
    http_method = "GET",
    http_path = "/organization/statistics",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_organization_statistics_input()
  output <- .guardduty$get_organization_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_organization_statistics <- guardduty_get_organization_statistics

#' Provides the number of days left for each data source used in the free
#' trial period
#'
#' @description
#' Provides the number of days left for each data source used in the free trial period.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_remaining_free_trial_days/](https://www.paws-r-sdk.com/docs/guardduty_get_remaining_free_trial_days/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds A list of account identifiers of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_remaining_free_trial_days
guardduty_get_remaining_free_trial_days <- function(DetectorId, AccountIds = NULL) {
  op <- new_operation(
    name = "GetRemainingFreeTrialDays",
    http_method = "POST",
    http_path = "/detector/{detectorId}/freeTrial/daysRemaining",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_remaining_free_trial_days_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_remaining_free_trial_days_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_remaining_free_trial_days <- guardduty_get_remaining_free_trial_days

#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID
#'
#' @description
#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_threat_intel_set/](https://www.paws-r-sdk.com/docs/guardduty_get_threat_intel_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the
#' threatIntelSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to get.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_threat_intel_set
guardduty_get_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "GetThreatIntelSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$get_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$get_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_threat_intel_set <- guardduty_get_threat_intel_set

#' Lists Amazon GuardDuty usage statistics over the last 30 days for the
#' specified detector ID
#'
#' @description
#' Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For more information, see [Understanding How Usage Costs are Calculated](https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations).
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_get_usage_statistics/](https://www.paws-r-sdk.com/docs/guardduty_get_usage_statistics/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose usage
#' statistics you want to retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param UsageStatisticType &#91;required&#93; The type of usage statistics to retrieve.
#' @param UsageCriteria &#91;required&#93; Represents the criteria used for querying usage.
#' @param Unit The currency unit you would like to view your usage statistics in.
#' Current valid values are USD.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the NextToken value returned from the
#' previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_usage_statistics
guardduty_get_usage_statistics <- function(DetectorId, UsageStatisticType, UsageCriteria, Unit = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUsageStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/usage/statistics",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .guardduty$get_usage_statistics_input(DetectorId = DetectorId, UsageStatisticType = UsageStatisticType, UsageCriteria = UsageCriteria, Unit = Unit, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$get_usage_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_usage_statistics <- guardduty_get_usage_statistics

#' Invites Amazon Web Services accounts to become members of an
#' organization administered by the Amazon Web Services account that
#' invokes this API
#'
#' @description
#' Invites Amazon Web Services accounts to become members of an organization administered by the Amazon Web Services account that invokes this API. If you are using Amazon Web Services Organizations to manage your GuardDuty environment, this step is not needed. For more information, see [Managing accounts with organizations](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_organizations.html).
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_invite_members/](https://www.paws-r-sdk.com/docs/guardduty_invite_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account with which you
#' want to invite members.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of account IDs of the accounts that you want to invite to
#' GuardDuty as members.
#' @param DisableEmailNotification A Boolean value that specifies whether you want to disable email
#' notification to the accounts that you are inviting to GuardDuty as
#' members.
#' @param Message The invitation message that you want to send to the accounts that you're
#' inviting to GuardDuty as members.
#'
#' @keywords internal
#'
#' @rdname guardduty_invite_members
guardduty_invite_members <- function(DetectorId, AccountIds, DisableEmailNotification = NULL, Message = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/invite",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$invite_members_input(DetectorId = DetectorId, AccountIds = AccountIds, DisableEmailNotification = DisableEmailNotification, Message = Message)
  output <- .guardduty$invite_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$invite_members <- guardduty_invite_members

#' Lists coverage details for your GuardDuty account
#'
#' @description
#' Lists coverage details for your GuardDuty account. If you're a GuardDuty administrator, you can retrieve all resources associated with the active member accounts in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_coverage/](https://www.paws-r-sdk.com/docs/guardduty_list_coverage/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector whose coverage details you want to
#' retrieve.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the NextToken value returned from the
#' previous request to continue listing results after the first page.
#' @param MaxResults The maximum number of results to return in the response.
#' @param FilterCriteria Represents the criteria used to filter the coverage details.
#' @param SortCriteria Represents the criteria used to sort the coverage details.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_coverage
guardduty_list_coverage <- function(DetectorId, NextToken = NULL, MaxResults = NULL, FilterCriteria = NULL, SortCriteria = NULL) {
  op <- new_operation(
    name = "ListCoverage",
    http_method = "POST",
    http_path = "/detector/{detectorId}/coverage",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Resources"),
    stream_api = FALSE
  )
  input <- .guardduty$list_coverage_input(DetectorId = DetectorId, NextToken = NextToken, MaxResults = MaxResults, FilterCriteria = FilterCriteria, SortCriteria = SortCriteria)
  output <- .guardduty$list_coverage_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_coverage <- guardduty_list_coverage

#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources
#'
#' @description
#' Lists detectorIds of all the existing Amazon GuardDuty detector resources.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_detectors/](https://www.paws-r-sdk.com/docs/guardduty_list_detectors/) for full documentation.
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_detectors
guardduty_list_detectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDetectors",
    http_method = "GET",
    http_path = "/detector",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DetectorIds"),
    stream_api = FALSE
  )
  input <- .guardduty$list_detectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_detectors <- guardduty_list_detectors

#' Returns a paginated list of the current filters
#'
#' @description
#' Returns a paginated list of the current filters.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_filters/](https://www.paws-r-sdk.com/docs/guardduty_list_filters/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the filter.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_filters
guardduty_list_filters <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FilterNames"),
    stream_api = FALSE
  )
  input <- .guardduty$list_filters_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_filters_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_filters <- guardduty_list_filters

#' Lists GuardDuty findings for the specified detector ID
#'
#' @description
#' Lists GuardDuty findings for the specified detector ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_findings/](https://www.paws-r-sdk.com/docs/guardduty_list_findings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to list.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingCriteria Represents the criteria used for querying findings. Valid values
#' include:
#' 
#' -   JSON field name
#' 
#' -   accountId
#' 
#' -   region
#' 
#' -   confidence
#' 
#' -   id
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.resourceType
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.dnsRequestAction.domainWithSuffix
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   service.archived
#' 
#'     When this attribute is set to 'true', only archived findings are
#'     listed. When it's set to 'false', only unarchived findings are
#'     listed. When this attribute is not set, all existing findings are
#'     listed.
#' 
#' -   service.ebsVolumeScanDetails.scanId
#' 
#' -   service.resourceRole
#' 
#' -   severity
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: Timestamp in Unix Epoch millisecond format: 1486685375000
#' @param SortCriteria Represents the criteria used for sorting findings.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_findings
guardduty_list_findings <- function(DetectorId, FindingCriteria = NULL, SortCriteria = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FindingIds"),
    stream_api = FALSE
  )
  input <- .guardduty$list_findings_input(DetectorId = DetectorId, FindingCriteria = FindingCriteria, SortCriteria = SortCriteria, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_findings <- guardduty_list_findings

#' Lists the IPSets of the GuardDuty service specified by the detector ID
#'
#' @description
#' Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the IPSets returned are the IPSets from the associated administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_ip_sets/](https://www.paws-r-sdk.com/docs/guardduty_list_ip_sets/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with IPSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_ip_sets
guardduty_list_ip_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IpSetIds"),
    stream_api = FALSE
  )
  input <- .guardduty$list_ip_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_ip_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_ip_sets <- guardduty_list_ip_sets

#' Lists all GuardDuty membership invitations that were sent to the current
#' Amazon Web Services account
#'
#' @description
#' Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_invitations/](https://www.paws-r-sdk.com/docs/guardduty_list_invitations/) for full documentation.
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_invitations
guardduty_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitation",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Invitations"),
    stream_api = FALSE
  )
  input <- .guardduty$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_invitations <- guardduty_list_invitations

#' Lists the Malware Protection plan IDs associated with the protected
#' resources in your Amazon Web Services account
#'
#' @description
#' Lists the Malware Protection plan IDs associated with the protected resources in your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_malware_protection_plans/](https://www.paws-r-sdk.com/docs/guardduty_list_malware_protection_plans/) for full documentation.
#'
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of `NextToken` from the previous response to continue listing
#' data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_malware_protection_plans
guardduty_list_malware_protection_plans <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListMalwareProtectionPlans",
    http_method = "GET",
    http_path = "/malware-protection-plan",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$list_malware_protection_plans_input(NextToken = NextToken)
  output <- .guardduty$list_malware_protection_plans_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_malware_protection_plans <- guardduty_list_malware_protection_plans

#' Lists details about all member accounts for the current GuardDuty
#' administrator account
#'
#' @description
#' Lists details about all member accounts for the current GuardDuty administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_members/](https://www.paws-r-sdk.com/docs/guardduty_list_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the member.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param OnlyAssociated Specifies whether to only return associated members or to return all
#' members (including members who haven't been invited yet or have been
#' disassociated). Member accounts must have been previously associated
#' with the GuardDuty administrator account using
#' [`Create Members`](https://docs.aws.amazon.com/guardduty/latest/APIReference/API_CreateMembers.html)
#' .
#'
#' @keywords internal
#'
#' @rdname guardduty_list_members
guardduty_list_members <- function(DetectorId, MaxResults = NULL, NextToken = NULL, OnlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/detector/{detectorId}/member",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Members"),
    stream_api = FALSE
  )
  input <- .guardduty$list_members_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken, OnlyAssociated = OnlyAssociated)
  output <- .guardduty$list_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_members <- guardduty_list_members

#' Lists the accounts designated as GuardDuty delegated administrators
#'
#' @description
#' Lists the accounts designated as GuardDuty delegated administrators. Only the organization's management account can run this API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_organization_admin_accounts/](https://www.paws-r-sdk.com/docs/guardduty_list_organization_admin_accounts/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_organization_admin_accounts
guardduty_list_organization_admin_accounts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "GET",
    http_path = "/admin",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "AdminAccounts"),
    stream_api = FALSE
  )
  input <- .guardduty$list_organization_admin_accounts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_organization_admin_accounts <- guardduty_list_organization_admin_accounts

#' Returns a list of publishing destinations associated with the specified
#' detectorId
#'
#' @description
#' Returns a list of publishing destinations associated with the specified `detectorId`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_publishing_destinations/](https://www.paws-r-sdk.com/docs/guardduty_list_publishing_destinations/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID for which you want to retrieve the publishing
#' destination.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_publishing_destinations
guardduty_list_publishing_destinations <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublishingDestinations",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .guardduty$list_publishing_destinations_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_publishing_destinations_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_publishing_destinations <- guardduty_list_publishing_destinations

#' Lists tags for a resource
#'
#' @description
#' Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, threat intel sets, and publishing destination, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/guardduty_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_tags_for_resource
guardduty_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .guardduty$list_tags_for_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_tags_for_resource <- guardduty_list_tags_for_resource

#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID
#'
#' @description
#' Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the ThreatIntelSets associated with the administrator account are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_list_threat_intel_sets/](https://www.paws-r-sdk.com/docs/guardduty_list_threat_intel_sets/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that is associated with the
#' threatIntelSet.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter to paginate results in the response. Set the
#' value of this parameter to null on your first call to the list action.
#' For subsequent calls to the action, fill nextToken in the request with
#' the value of NextToken from the previous response to continue listing
#' data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_threat_intel_sets
guardduty_list_threat_intel_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListThreatIntelSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ThreatIntelSetIds"),
    stream_api = FALSE
  )
  input <- .guardduty$list_threat_intel_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_threat_intel_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_threat_intel_sets <- guardduty_list_threat_intel_sets

#' Initiates the malware scan
#'
#' @description
#' Initiates the malware scan. Invoking this API will automatically create the [Service-linked role](https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html) in the corresponding account.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_start_malware_scan/](https://www.paws-r-sdk.com/docs/guardduty_start_malware_scan/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Amazon Resource Name (ARN) of the resource for which you invoked the
#' API.
#'
#' @keywords internal
#'
#' @rdname guardduty_start_malware_scan
guardduty_start_malware_scan <- function(ResourceArn) {
  op <- new_operation(
    name = "StartMalwareScan",
    http_method = "POST",
    http_path = "/malware-scan/start",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$start_malware_scan_input(ResourceArn = ResourceArn)
  output <- .guardduty$start_malware_scan_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$start_malware_scan <- guardduty_start_malware_scan

#' Turns on GuardDuty monitoring of the specified member accounts
#'
#' @description
#' Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of accounts that you stopped monitoring with the [`stop_monitoring_members`][guardduty_stop_monitoring_members] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_start_monitoring_members/](https://www.paws-r-sdk.com/docs/guardduty_start_monitoring_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty administrator account
#' associated with the member accounts to monitor.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts to start
#' monitoring.
#'
#' @keywords internal
#'
#' @rdname guardduty_start_monitoring_members
guardduty_start_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StartMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/start",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$start_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$start_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$start_monitoring_members <- guardduty_start_monitoring_members

#' Stops GuardDuty monitoring for the specified member accounts
#'
#' @description
#' Stops GuardDuty monitoring for the specified member accounts. Use the [`start_monitoring_members`][guardduty_start_monitoring_members] operation to restart monitoring for those accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_stop_monitoring_members/](https://www.paws-r-sdk.com/docs/guardduty_stop_monitoring_members/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the GuardDuty
#' administrator account that is monitoring member accounts.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of account IDs for the member accounts to stop monitoring.
#'
#' @keywords internal
#'
#' @rdname guardduty_stop_monitoring_members
guardduty_stop_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StopMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$stop_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$stop_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$stop_monitoring_members <- guardduty_stop_monitoring_members

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_tag_resource/](https://www.paws-r-sdk.com/docs/guardduty_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag
#' to.
#' @param Tags &#91;required&#93; The tags to be added to a resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_tag_resource
guardduty_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .guardduty$tag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$tag_resource <- guardduty_tag_resource

#' Unarchives GuardDuty findings specified by the findingIds
#'
#' @description
#' Unarchives GuardDuty findings specified by the `findingIds`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_unarchive_findings/](https://www.paws-r-sdk.com/docs/guardduty_unarchive_findings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the findings to unarchive.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingIds &#91;required&#93; The IDs of the findings to unarchive.
#'
#' @keywords internal
#'
#' @rdname guardduty_unarchive_findings
guardduty_unarchive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "UnarchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/unarchive",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$unarchive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$unarchive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$unarchive_findings <- guardduty_unarchive_findings

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_untag_resource/](https://www.paws-r-sdk.com/docs/guardduty_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource to remove tags from.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_untag_resource
guardduty_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .guardduty$untag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$untag_resource <- guardduty_untag_resource

#' Updates the GuardDuty detector specified by the detector ID
#'
#' @description
#' Updates the GuardDuty detector specified by the detector ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_detector/](https://www.paws-r-sdk.com/docs/guardduty_update_detector/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector to update.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param Enable Specifies whether the detector is enabled or not enabled.
#' @param FindingPublishingFrequency An enum value that specifies how frequently findings are exported, such
#' as to CloudWatch Events.
#' @param DataSources Describes which data sources will be updated.
#' 
#' There might be regional differences because some data sources might not
#' be available in all the Amazon Web Services Regions where GuardDuty is
#' presently supported. For more information, see [Regions and
#' endpoints](https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html).
#' @param Features Provides the features that will be updated for the detector.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_detector
guardduty_update_detector <- function(DetectorId, Enable = NULL, FindingPublishingFrequency = NULL, DataSources = NULL, Features = NULL) {
  op <- new_operation(
    name = "UpdateDetector",
    http_method = "POST",
    http_path = "/detector/{detectorId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_detector_input(DetectorId = DetectorId, Enable = Enable, FindingPublishingFrequency = FindingPublishingFrequency, DataSources = DataSources, Features = Features)
  output <- .guardduty$update_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_detector <- guardduty_update_detector

#' Updates the filter specified by the filter name
#'
#' @description
#' Updates the filter specified by the filter name.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_filter/](https://www.paws-r-sdk.com/docs/guardduty_update_filter/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update a filter.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FilterName &#91;required&#93; The name of the filter.
#' @param Description The description of the filter. Valid characters include alphanumeric
#' characters, and special characters such as hyphen, period, colon,
#' underscore, parentheses (`{ }`, `[ ]`, and `( )`), forward slash,
#' horizontal tab, vertical tab, newline, form feed, return, and
#' whitespace.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria Represents the criteria to be used in the filter for querying findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_filter
guardduty_update_filter <- function(DetectorId, FilterName, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_filter_input(DetectorId = DetectorId, FilterName = FilterName, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria)
  output <- .guardduty$update_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_filter <- guardduty_update_filter

#' Marks the specified GuardDuty findings as useful or not useful
#'
#' @description
#' Marks the specified GuardDuty findings as useful or not useful.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_findings_feedback/](https://www.paws-r-sdk.com/docs/guardduty_update_findings_feedback/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that is associated with the findings for which
#' you want to update the feedback.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to mark as useful or not useful.
#' @param Feedback &#91;required&#93; The feedback for the finding.
#' @param Comments Additional feedback about the GuardDuty findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_findings_feedback
guardduty_update_findings_feedback <- function(DetectorId, FindingIds, Feedback, Comments = NULL) {
  op <- new_operation(
    name = "UpdateFindingsFeedback",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/feedback",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_findings_feedback_input(DetectorId = DetectorId, FindingIds = FindingIds, Feedback = Feedback, Comments = Comments)
  output <- .guardduty$update_findings_feedback_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_findings_feedback <- guardduty_update_findings_feedback

#' Updates the IPSet specified by the IPSet ID
#'
#' @description
#' Updates the IPSet specified by the IPSet ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_ip_set/](https://www.paws-r-sdk.com/docs/guardduty_update_ip_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose IPSet you want
#' to update.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param IpSetId &#91;required&#93; The unique ID that specifies the IPSet that you want to update.
#' @param Name The unique ID that specifies the IPSet that you want to update.
#' @param Location The updated URI of the file that contains the IPSet.
#' @param Activate The updated Boolean value that specifies whether the IPSet is active or
#' not.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_ip_set
guardduty_update_ip_set <- function(DetectorId, IpSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_ip_set <- guardduty_update_ip_set

#' Updates an existing Malware Protection plan resource
#'
#' @description
#' Updates an existing Malware Protection plan resource.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_malware_protection_plan/](https://www.paws-r-sdk.com/docs/guardduty_update_malware_protection_plan/) for full documentation.
#'
#' @param MalwareProtectionPlanId &#91;required&#93; A unique identifier associated with the Malware Protection plan.
#' @param Role Amazon Resource Name (ARN) of the IAM role with permissions to scan and
#' add tags to the associated protected resource.
#' @param Actions Information about whether the tags will be added to the S3 object after
#' scanning.
#' @param ProtectedResource Information about the protected resource that is associated with the
#' created Malware Protection plan. Presently, `S3Bucket` is the only
#' supported protected resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_malware_protection_plan
guardduty_update_malware_protection_plan <- function(MalwareProtectionPlanId, Role = NULL, Actions = NULL, ProtectedResource = NULL) {
  op <- new_operation(
    name = "UpdateMalwareProtectionPlan",
    http_method = "PATCH",
    http_path = "/malware-protection-plan/{malwareProtectionPlanId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_malware_protection_plan_input(MalwareProtectionPlanId = MalwareProtectionPlanId, Role = Role, Actions = Actions, ProtectedResource = ProtectedResource)
  output <- .guardduty$update_malware_protection_plan_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_malware_protection_plan <- guardduty_update_malware_protection_plan

#' Updates the malware scan settings
#'
#' @description
#' Updates the malware scan settings.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_malware_scan_settings/](https://www.paws-r-sdk.com/docs/guardduty_update_malware_scan_settings/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update scan settings.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param ScanResourceCriteria Represents the criteria to be used in the filter for selecting resources
#' to scan.
#' @param EbsSnapshotPreservation An enum value representing possible snapshot preservation settings.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_malware_scan_settings
guardduty_update_malware_scan_settings <- function(DetectorId, ScanResourceCriteria = NULL, EbsSnapshotPreservation = NULL) {
  op <- new_operation(
    name = "UpdateMalwareScanSettings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/malware-scan-settings",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_malware_scan_settings_input(DetectorId = DetectorId, ScanResourceCriteria = ScanResourceCriteria, EbsSnapshotPreservation = EbsSnapshotPreservation)
  output <- .guardduty$update_malware_scan_settings_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_malware_scan_settings <- guardduty_update_malware_scan_settings

#' Contains information on member accounts to be updated
#'
#' @description
#' Contains information on member accounts to be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_member_detectors/](https://www.paws-r-sdk.com/docs/guardduty_update_member_detectors/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID of the administrator account.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AccountIds &#91;required&#93; A list of member account IDs to be updated.
#' @param DataSources Describes which data sources will be updated.
#' @param Features A list of features that will be updated for the specified member
#' accounts.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_member_detectors
guardduty_update_member_detectors <- function(DetectorId, AccountIds, DataSources = NULL, Features = NULL) {
  op <- new_operation(
    name = "UpdateMemberDetectors",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/detector/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_member_detectors_input(DetectorId = DetectorId, AccountIds = AccountIds, DataSources = DataSources, Features = Features)
  output <- .guardduty$update_member_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_member_detectors <- guardduty_update_member_detectors

#' Configures the delegated administrator account with the provided values
#'
#' @description
#' Configures the delegated administrator account with the provided values. You must provide a value for either `autoEnableOrganizationMembers` or `autoEnable`, but not both.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_organization_configuration/](https://www.paws-r-sdk.com/docs/guardduty_update_organization_configuration/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that configures the delegated administrator.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param AutoEnable Represents whether to automatically enable member accounts in the
#' organization. This applies to only new member accounts, not the existing
#' member accounts. When a new account joins the organization, the chosen
#' features will be enabled for them by default.
#' 
#' Even though this is still supported, we recommend using
#' `AutoEnableOrganizationMembers` to achieve the similar results. You must
#' provide a value for either `autoEnableOrganizationMembers` or
#' `autoEnable`.
#' @param DataSources Describes which data sources will be updated.
#' @param Features A list of features that will be configured for the organization.
#' @param AutoEnableOrganizationMembers Indicates the auto-enablement configuration of GuardDuty for the member
#' accounts in the organization. You must provide a value for either
#' `autoEnableOrganizationMembers` or `autoEnable`.
#' 
#' Use one of the following configuration values for
#' `autoEnableOrganizationMembers`:
#' 
#' -   `NEW`: Indicates that when a new account joins the organization,
#'     they will have GuardDuty enabled automatically.
#' 
#' -   `ALL`: Indicates that all accounts in the organization have
#'     GuardDuty enabled automatically. This includes `NEW` accounts that
#'     join the organization and accounts that may have been suspended or
#'     removed from the organization in GuardDuty.
#' 
#'     It may take up to 24 hours to update the configuration for all the
#'     member accounts.
#' 
#' -   `NONE`: Indicates that GuardDuty will not be automatically enabled
#'     for any account in the organization. The administrator must manage
#'     GuardDuty for each account in the organization individually.
#' 
#'     When you update the auto-enable setting from `ALL` or `NEW` to
#'     `NONE`, this action doesn't disable the corresponding option for
#'     your existing accounts. This configuration will apply to the new
#'     accounts that join the organization. After you update the
#'     auto-enable settings, no new account will have the corresponding
#'     option as enabled.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_organization_configuration
guardduty_update_organization_configuration <- function(DetectorId, AutoEnable = NULL, DataSources = NULL, Features = NULL, AutoEnableOrganizationMembers = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/detector/{detectorId}/admin",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_organization_configuration_input(DetectorId = DetectorId, AutoEnable = AutoEnable, DataSources = DataSources, Features = Features, AutoEnableOrganizationMembers = AutoEnableOrganizationMembers)
  output <- .guardduty$update_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_organization_configuration <- guardduty_update_organization_configuration

#' Updates information about the publishing destination specified by the
#' destinationId
#'
#' @description
#' Updates information about the publishing destination specified by the `destinationId`.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_publishing_destination/](https://www.paws-r-sdk.com/docs/guardduty_update_publishing_destination/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the publishing destinations to
#' update.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to update.
#' @param DestinationProperties A `DestinationProperties` object that includes the `DestinationArn` and
#' `KmsKeyArn` of the publishing destination.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_publishing_destination
guardduty_update_publishing_destination <- function(DetectorId, DestinationId, DestinationProperties = NULL) {
  op <- new_operation(
    name = "UpdatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId, DestinationProperties = DestinationProperties)
  output <- .guardduty$update_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_publishing_destination <- guardduty_update_publishing_destination

#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' @description
#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' See [https://www.paws-r-sdk.com/docs/guardduty_update_threat_intel_set/](https://www.paws-r-sdk.com/docs/guardduty_update_threat_intel_set/) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose ThreatIntelSet
#' you want to update.
#' 
#' To find the `detectorId` in the current Region, see the Settings page in
#' the GuardDuty console, or run the
#' [`list_detectors`][guardduty_list_detectors] API.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Name The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Location The updated URI of the file that contains the ThreateIntelSet.
#' @param Activate The updated Boolean value that specifies whether the ThreateIntelSet is
#' active or not.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_threat_intel_set
guardduty_update_threat_intel_set <- function(DetectorId, ThreatIntelSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .guardduty$update_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_threat_intel_set <- guardduty_update_threat_intel_set
