% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_permission_associations}
\alias{ram_list_permission_associations}
\title{Lists information about the managed permission and its associations to
any resource shares that use this managed permission}
\usage{
ram_list_permission_associations(
  permissionArn = NULL,
  permissionVersion = NULL,
  associationStatus = NULL,
  resourceType = NULL,
  featureSet = NULL,
  defaultVersion = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{permissionArn}{Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the managed permission.}

\item{permissionVersion}{Specifies that you want to list only those associations with resource
shares that use this version of the managed permission. If you don't
provide a value for this parameter, then the operation returns
information about associations with resource shares that use any version
of the managed permission.}

\item{associationStatus}{Specifies that you want to list only those associations with resource
shares that match this status.}

\item{resourceType}{Specifies that you want to list only those associations with resource
shares that include at least one resource of this resource type.}

\item{featureSet}{Specifies that you want to list only those associations with resource
shares that have a \code{featureSet} with this value.}

\item{defaultVersion}{When \code{true}, specifies that you want to list only those associations
with resource shares that use the default version of the specified
managed permission.

When \code{false} (the default value), lists associations with resource
shares that use any version of the specified managed permission.}

\item{nextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}

\item{maxResults}{Specifies the total number of results that you want included on each
page of the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the number you specify, the \code{NextToken} response element is
returned with a value (not null). Include the specified value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that the service might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists information about the managed permission and its associations to any resource shares that use this managed permission. This lets you see which resource shares use which versions of the specified managed permission.

See \url{https://www.paws-r-sdk.com/docs/ram_list_permission_associations/} for full documentation.
}
\keyword{internal}
