% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_principals}
\alias{ram_list_principals}
\title{Lists the principals that you are sharing resources with or that are
sharing resources with you}
\usage{
ram_list_principals(
  resourceOwner,
  resourceArn = NULL,
  principals = NULL,
  resourceType = NULL,
  resourceShareArns = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{resourceOwner}{[required] Specifies that you want to list information for only resource shares
that match the following:
\itemize{
\item \strong{\code{SELF}} – principals that your account is sharing resources with
\item \strong{\code{OTHER-ACCOUNTS}} – principals that are sharing resources with
your account
}}

\item{resourceArn}{Specifies that you want to list principal information for the resource
share with the specified \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}.}

\item{principals}{Specifies that you want to list information for only the listed
principals.

You can include the following values:
\itemize{
\item An Amazon Web Services account ID, for example: \code{123456789012}
\item An \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of an organization in Organizations, for example:
\verb{organizations::123456789012:organization/o-exampleorgid}
\item An ARN of an organizational unit (OU) in Organizations, for example:
\verb{organizations::123456789012:ou/o-exampleorgid/ou-examplerootid-exampleouid123}
\item An ARN of an IAM role, for example:
\verb{iam::123456789012:role/rolename}
\item An ARN of an IAM user, for example: \verb{iam::123456789012user/username}
}

Not all resource types can be shared with IAM roles and users. For more
information, see \href{https://docs.aws.amazon.com/ram/latest/userguide/#permissions-rbp-supported-resource-types}{Sharing with IAM roles and users}
in the \emph{Resource Access Manager User Guide}.}

\item{resourceType}{Specifies that you want to list information for only principals
associated with resource shares that include the specified resource
type.

For a list of valid values, query the
\code{\link[=ram_list_resource_types]{list_resource_types}} operation.}

\item{resourceShareArns}{Specifies that you want to list information for only principals
associated with the resource shares specified by a list the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}.}

\item{nextToken}{Specifies that you want to receive the next page of results. Valid only
if you received a \code{NextToken} response in the previous request. If you
did, it indicates that more output is available. Set this parameter to
the value provided by the previous call's \code{NextToken} response to
request the next page of results.}

\item{maxResults}{Specifies the total number of results that you want included on each
page of the response. If you do not include this parameter, it defaults
to a value that is specific to the operation. If additional items exist
beyond the number you specify, the \code{NextToken} response element is
returned with a value (not null). Include the specified value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results. Note that the service might return fewer
results than the maximum even when there are more results available. You
should check \code{NextToken} after every operation to ensure that you
receive all of the results.}
}
\description{
Lists the principals that you are sharing resources with or that are sharing resources with you.

See \url{https://www.paws-r-sdk.com/docs/ram_list_principals/} for full documentation.
}
\keyword{internal}
