% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_group}
\alias{iam_update_group}
\title{Updates the name and/or the path of the specified IAM group}
\usage{
iam_update_group(GroupName, NewPath = NULL, NewGroupName = NULL)
}
\arguments{
\item{GroupName}{[required] Name of the IAM group to update. If you're changing the name of the
group, this is the original name.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{NewPath}{New path for the IAM group. Only include this if changing the group's
path.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{NewGroupName}{New name for the IAM group. Only include this if changing the group's
name.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both "MyResource" and "myresource".}
}
\description{
Updates the name and/or the path of the specified IAM group.

See \url{https://www.paws-r-sdk.com/docs/iam_update_group/} for full documentation.
}
\keyword{internal}
