% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_simulate_principal_policy}
\alias{iam_simulate_principal_policy}
\title{Simulate how a set of IAM policies attached to an IAM entity works with
a list of API operations and Amazon Web Services resources to determine
the policies' effective permissions}
\usage{
iam_simulate_principal_policy(
  PolicySourceArn,
  PolicyInputList = NULL,
  PermissionsBoundaryPolicyInputList = NULL,
  ActionNames,
  ResourceArns = NULL,
  ResourcePolicy = NULL,
  ResourceOwner = NULL,
  CallerArn = NULL,
  ContextEntries = NULL,
  ResourceHandlingOption = NULL,
  MaxItems = NULL,
  Marker = NULL
)
}
\arguments{
\item{PolicySourceArn}{[required] The Amazon Resource Name (ARN) of a user, group, or role whose policies
you want to include in the simulation. If you specify a user, group, or
role, the simulation includes all policies that are associated with that
entity. If you specify a user, the simulation also includes all policies
that are attached to any groups the user belongs to.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{PolicyInputList}{An optional list of additional policy documents to include in the
simulation. Each document is specified as a string containing the
complete, valid JSON text of an IAM policy.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{PermissionsBoundaryPolicyInputList}{The IAM permissions boundary policy to simulate. The permissions
boundary sets the maximum permissions that the entity can have. You can
input only one permissions boundary when you pass a policy to this
operation. An IAM entity can only have one permissions boundary in
effect at a time. For example, if a permissions boundary is attached to
an entity and you pass in a different permissions boundary policy using
this parameter, then the new permissions boundary policy is used for the
simulation. For more information about permissions boundaries, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html}{Permissions boundaries for IAM entities}
in the \emph{IAM User Guide}. The policy input is specified as a string
containing the complete, valid JSON text of a permissions boundary
policy.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{ActionNames}{[required] A list of names of API operations to evaluate in the simulation. Each
operation is evaluated for each resource. Each operation must include
the service identifier, such as \code{iam:CreateUser}.}

\item{ResourceArns}{A list of ARNs of Amazon Web Services resources to include in the
simulation. If this parameter is not provided, then the value defaults
to \code{*} (all resources). Each API in the \code{ActionNames} parameter is
evaluated for each resource in this list. The simulation determines the
access result (allowed or denied) of each combination and reports it in
the response. You can simulate resources that don't exist in your
account.

The simulation does not automatically retrieve policies for the
specified resources. If you want to include a resource policy in the
simulation, then you must include the policy as a string in the
\code{ResourcePolicy} parameter.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.

Simulation of resource-based policies isn't supported for IAM roles.}

\item{ResourcePolicy}{A resource-based policy to include in the simulation provided as a
string. Each resource in the simulation is treated as if it had this
policy attached. You can include only one resource-based policy in a
simulation.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}

Simulation of resource-based policies isn't supported for IAM roles.}

\item{ResourceOwner}{An Amazon Web Services account ID that specifies the owner of any
simulated resource that does not identify its owner in the resource ARN.
Examples of resource ARNs include an S3 bucket or object. If
\code{ResourceOwner} is specified, it is also used as the account owner of
any \code{ResourcePolicy} included in the simulation. If the \code{ResourceOwner}
parameter is not specified, then the owner of the resources and the
resource policy defaults to the account of the identity provided in
\code{CallerArn}. This parameter is required only if you specify a
resource-based policy and account that owns the resource is different
from the account that owns the simulated calling user \code{CallerArn}.}

\item{CallerArn}{The ARN of the IAM user that you want to specify as the simulated caller
of the API operations. If you do not specify a \code{CallerArn}, it defaults
to the ARN of the user that you specify in \code{PolicySourceArn}, if you
specified a user. If you include both a \code{PolicySourceArn} (for example,
\verb{arn:aws:iam::123456789012:user/David}) and a \code{CallerArn} (for example,
\verb{arn:aws:iam::123456789012:user/Bob}), the result is that you simulate
calling the API operations as Bob, as if Bob had David's policies.

You can specify only the ARN of an IAM user. You cannot specify the ARN
of an assumed role, federated user, or a service principal.

\code{CallerArn} is required if you include a \code{ResourcePolicy} and the
\code{PolicySourceArn} is not the ARN for an IAM user. This is required so
that the resource-based policy's \code{Principal} element has a value to use
in evaluating the policy.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}

\item{ContextEntries}{A list of context keys and corresponding values for the simulation to
use. Whenever a context key is evaluated in one of the simulated IAM
permissions policies, the corresponding value is supplied.}

\item{ResourceHandlingOption}{Specifies the type of simulation to run. Different API operations that
support resource-based policies require different combinations of
resources. By specifying the type of simulation to run, you enable the
policy simulator to enforce the presence of the required resources to
ensure reliable simulation results. If your simulation does not match
one of the following scenarios, then you can omit this parameter. The
following list shows each of the supported scenario values and the
resources that you must define to run the simulation.

Each of the EC2 scenarios requires that you specify instance, image, and
security group resources. If your scenario includes an EBS volume, then
you must specify that volume as a resource. If the EC2 scenario includes
VPC, then you must supply the network interface resource. If it includes
an IP subnet, then you must specify the subnet resource. For more
information on the EC2 scenario options, see \href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{Supported platforms}
in the \emph{Amazon EC2 User Guide}.
\itemize{
\item \strong{EC2-VPC-InstanceStore}

instance, image, security group, network interface
\item \strong{EC2-VPC-InstanceStore-Subnet}

instance, image, security group, network interface, subnet
\item \strong{EC2-VPC-EBS}

instance, image, security group, network interface, volume
\item \strong{EC2-VPC-EBS-Subnet}

instance, image, security group, network interface, subnet, volume
}}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you specify a user, then the simulation also includes all of the policies that are attached to groups that the user belongs to. You can simulate resources that don't exist in your account.

See \url{https://www.paws-r-sdk.com/docs/iam_simulate_principal_policy/} for full documentation.
}
\keyword{internal}
