% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_get_open_id_token}
\alias{cognitoidentity_get_open_id_token}
\title{Gets an OpenID token, using a known Cognito ID}
\usage{
cognitoidentity_get_open_id_token(IdentityId, Logins = NULL)
}
\arguments{
\item{IdentityId}{[required] A unique identifier in the format REGION:GUID.}

\item{Logins}{A set of optional name-value pairs that map provider names to provider
tokens. When using graph.facebook.com and www.amazon.com, supply the
access_token returned from the provider's authflow. For
accounts.google.com, an Amazon Cognito user pool provider, or any other
OpenID Connect provider, always include the \code{id_token}.}
}
\description{
Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by \code{\link[=cognitoidentity_get_id]{get_id}}. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentity_get_open_id_token/} for full documentation.
}
\keyword{internal}
