% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_untag_resource}
\alias{kms_untag_resource}
\title{Deletes tags from a customer managed key}
\usage{
kms_untag_resource(KeyId, TagKeys)
}
\arguments{
\item{KeyId}{[required] Identifies the KMS key from which you are removing tags.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{TagKeys}{[required] One or more tag keys. Specify only the tag keys, not the tag values.}
}
\description{
Deletes tags from a \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed key}. To delete a tag, specify the tag key and the KMS key.

See \url{https://paws-r.github.io/docs/kms/untag_resource.html} for full documentation.
}
\keyword{internal}
