% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_user}
\alias{iam_delete_user}
\title{Deletes the specified IAM user}
\usage{
iam_delete_user(UserName)
}
\arguments{
\item{UserName}{[required] The name of the user to delete.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}
}
\description{
Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user programmatically, you must delete the items attached to the user manually, or the deletion fails. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli}{Deleting an IAM user}. Before attempting to delete a user, remove the following items:

See \url{https://paws-r.github.io/docs/iam/delete_user.html} for full documentation.
}
\keyword{internal}
