% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_open_id_connect_provider}
\alias{iam_create_open_id_connect_provider}
\title{Creates an IAM entity to describe an identity provider (IdP) that
supports OpenID Connect (OIDC)}
\usage{
iam_create_open_id_connect_provider(
  Url,
  ClientIDList = NULL,
  ThumbprintList,
  Tags = NULL
)
}
\arguments{
\item{Url}{[required] The URL of the identity provider. The URL must begin with \verb{https://} and
should correspond to the \code{iss} claim in the provider's OpenID Connect ID
tokens. Per the OIDC standard, path components are allowed but query
parameters are not. Typically the URL consists of only a hostname, like
\verb{https://server.example.org} or \verb{https://example.com}. The URL should
not contain a port number.

You cannot register the same provider multiple times in a single Amazon
Web Services account. If you try to submit a URL that has already been
used for an OpenID Connect provider in the Amazon Web Services account,
you will get an error.}

\item{ClientIDList}{Provides a list of client IDs, also known as audiences. When a mobile or
web app registers with an OpenID Connect provider, they establish a
value that identifies the application. This is the value that's sent as
the \code{client_id} parameter on OAuth requests.

You can register multiple client IDs with the same provider. For
example, you might have multiple applications that use the same OIDC
provider. You cannot register more than 100 client IDs with a single IAM
OIDC provider.

There is no defined format for a client ID. The
\code{CreateOpenIDConnectProviderRequest} operation accepts client IDs up to
255 characters long.}

\item{ThumbprintList}{[required] A list of server certificate thumbprints for the OpenID Connect (OIDC)
identity provider's server certificates. Typically this list includes
only one entry. However, IAM lets you have up to five thumbprints for an
OIDC provider. This lets you maintain multiple thumbprints if the
identity provider is rotating certificates.

The server certificate thumbprint is the hex-encoded SHA-1 hash value of
the X.509 certificate used by the domain where the OpenID Connect
provider makes its keys available. It is always a 40-character string.

You must provide at least one thumbprint when creating an IAM OIDC
provider. For example, assume that the OIDC provider is
\code{server.example.com} and the provider stores its keys at
https://keys.server.example.com/openid-connect. In that case, the
thumbprint string would be the hex-encoded SHA-1 hash value of the
certificate used by \verb{https://keys.server.example.com.}

For more information about obtaining the OIDC provider thumbprint, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html}{Obtaining the thumbprint for an OpenID Connect provider}
in the \emph{IAM User Guide}.}

\item{Tags}{A list of tags that you want to attach to the new IAM OpenID Connect
(OIDC) provider. Each tag consists of a key name and an associated
value. For more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Creates an IAM entity to describe an identity provider (IdP) that supports \href{https://openid.net/connect/}{OpenID Connect (OIDC)}.

See \url{https://paws-r.github.io/docs/iam/create_open_id_connect_provider.html} for full documentation.
}
\keyword{internal}
