% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_attach_role_policy}
\alias{iam_attach_role_policy}
\title{Attaches the specified managed policy to the specified IAM role}
\usage{
iam_attach_role_policy(RoleName, PolicyArn)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) of the role to attach the policy to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to attach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}
}
\description{
Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the managed policy becomes part of the role's permission (access) policy.

See \url{https://paws-r.github.io/docs/iam/attach_role_policy.html} for full documentation.
}
\keyword{internal}
