% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_attach_group_policy}
\alias{iam_attach_group_policy}
\title{Attaches the specified managed policy to the specified IAM group}
\usage{
iam_attach_group_policy(GroupName, PolicyArn)
}
\arguments{
\item{GroupName}{[required] The name (friendly name, not ARN) of the group to attach the policy to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to attach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.}
}
\description{
Attaches the specified managed policy to the specified IAM group.

See \url{https://paws-r.github.io/docs/iam/attach_group_policy.html} for full documentation.
}
\keyword{internal}
