# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include identitystore_service.R
NULL

#' Retrieves the group metadata and attributes from GroupId in an identity
#' store
#'
#' @description
#' Retrieves the group metadata and attributes from `GroupId` in an identity store.
#'
#' See [https://paws-r.github.io/docs/identitystore/describe_group.html](https://paws-r.github.io/docs/identitystore/describe_group.html) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains number and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param GroupId &#91;required&#93; The identifier for a group in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_describe_group
identitystore_describe_group <- function(IdentityStoreId, GroupId) {
  op <- new_operation(
    name = "DescribeGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .identitystore$describe_group_input(IdentityStoreId = IdentityStoreId, GroupId = GroupId)
  output <- .identitystore$describe_group_output()
  config <- get_config()
  svc <- .identitystore$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$describe_group <- identitystore_describe_group

#' Retrieves the user metadata and attributes from UserId in an identity
#' store
#'
#' @description
#' Retrieves the user metadata and attributes from `UserId` in an identity store.
#'
#' See [https://paws-r.github.io/docs/identitystore/describe_user.html](https://paws-r.github.io/docs/identitystore/describe_user.html) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains number and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param UserId &#91;required&#93; The identifier for a user in the identity store.
#'
#' @keywords internal
#'
#' @rdname identitystore_describe_user
identitystore_describe_user <- function(IdentityStoreId, UserId) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .identitystore$describe_user_input(IdentityStoreId = IdentityStoreId, UserId = UserId)
  output <- .identitystore$describe_user_output()
  config <- get_config()
  svc <- .identitystore$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$describe_user <- identitystore_describe_user

#' Lists the attribute name and value of the group that you specified in
#' the search
#'
#' @description
#' Lists the attribute name and value of the group that you specified in the search. We only support `DisplayName` as a valid filter attribute path currently, and filter is required. This API returns minimum attributes, including `GroupId` and group `DisplayName` in the response.
#'
#' See [https://paws-r.github.io/docs/identitystore/list_groups.html](https://paws-r.github.io/docs/identitystore/list_groups.html) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains number and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in the [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] request to specify how many
#' results to return in one page. The length limit is 50 characters.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] API operations. This value is
#' generated by the identity store service. It is returned in the API
#' response if the total results are more than the size of one page. This
#' token is also returned when it is used in the API request to search for
#' the next page.
#' @param Filters A list of `Filter` objects, which is used in the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] request.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_groups
identitystore_list_groups <- function(IdentityStoreId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .identitystore$list_groups_input(IdentityStoreId = IdentityStoreId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .identitystore$list_groups_output()
  config <- get_config()
  svc <- .identitystore$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_groups <- identitystore_list_groups

#' Lists the attribute name and value of the user that you specified in the
#' search
#'
#' @description
#' Lists the attribute name and value of the user that you specified in the search. We only support `UserName` as a valid filter attribute path currently, and filter is required. This API returns minimum attributes, including `UserId` and `UserName` in the response.
#'
#' See [https://paws-r.github.io/docs/identitystore/list_users.html](https://paws-r.github.io/docs/identitystore/list_users.html) for full documentation.
#'
#' @param IdentityStoreId &#91;required&#93; The globally unique identifier for the identity store, such as
#' `d-1234567890`. In this example, `d-` is a fixed prefix, and
#' `1234567890` is a randomly generated string that contains number and
#' lower case letters. This value is generated at the time that a new
#' identity store is created.
#' @param MaxResults The maximum number of results to be returned per request. This parameter
#' is used in the [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] request to specify how many
#' results to return in one page. The length limit is 50 characters.
#' @param NextToken The pagination token used for the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] API operations. This value is
#' generated by the identity store service. It is returned in the API
#' response if the total results are more than the size of one page. This
#' token is also returned when it is used in the API request to search for
#' the next page.
#' @param Filters A list of `Filter` objects, which is used in the
#' [`list_users`][identitystore_list_users] and
#' [`list_groups`][identitystore_list_groups] request.
#'
#' @keywords internal
#'
#' @rdname identitystore_list_users
identitystore_list_users <- function(IdentityStoreId, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .identitystore$list_users_input(IdentityStoreId = IdentityStoreId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .identitystore$list_users_output()
  config <- get_config()
  svc <- .identitystore$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.identitystore$operations$list_users <- identitystore_list_users
