# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include guardduty_service.R
NULL

#' Accepts the invitation to be a member account and get monitored by a
#' GuardDuty administrator account that sent the invitation
#'
#' @description
#' Accepts the invitation to be a member account and get monitored by a GuardDuty administrator account that sent the invitation.
#'
#' See [https://paws-r.github.io/docs/guardduty/accept_administrator_invitation.html](https://paws-r.github.io/docs/guardduty/accept_administrator_invitation.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param AdministratorId &#91;required&#93; The account ID of the GuardDuty administrator account whose invitation
#' you're accepting.
#' @param InvitationId &#91;required&#93; The value that is used to validate the administrator account to the
#' member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_administrator_invitation
guardduty_accept_administrator_invitation <- function(DetectorId, AdministratorId, InvitationId) {
  op <- new_operation(
    name = "AcceptAdministratorInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/administrator",
    paginator = list()
  )
  input <- .guardduty$accept_administrator_invitation_input(DetectorId = DetectorId, AdministratorId = AdministratorId, InvitationId = InvitationId)
  output <- .guardduty$accept_administrator_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_administrator_invitation <- guardduty_accept_administrator_invitation

#' Accepts the invitation to be monitored by a GuardDuty administrator
#' account
#'
#' @description
#' Accepts the invitation to be monitored by a GuardDuty administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/accept_invitation.html](https://paws-r.github.io/docs/guardduty/accept_invitation.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param MasterId &#91;required&#93; The account ID of the GuardDuty administrator account whose invitation
#' you're accepting.
#' @param InvitationId &#91;required&#93; The value that is used to validate the administrator account to the
#' member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_accept_invitation
guardduty_accept_invitation <- function(DetectorId, MasterId, InvitationId) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$accept_invitation_input(DetectorId = DetectorId, MasterId = MasterId, InvitationId = InvitationId)
  output <- .guardduty$accept_invitation_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$accept_invitation <- guardduty_accept_invitation

#' Archives GuardDuty findings that are specified by the list of finding
#' IDs
#'
#' @description
#' Archives GuardDuty findings that are specified by the list of finding IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/archive_findings.html](https://paws-r.github.io/docs/guardduty/archive_findings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to archive.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to archive.
#'
#' @keywords internal
#'
#' @rdname guardduty_archive_findings
guardduty_archive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "ArchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/archive",
    paginator = list()
  )
  input <- .guardduty$archive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$archive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$archive_findings <- guardduty_archive_findings

#' Creates a single Amazon GuardDuty detector
#'
#' @description
#' Creates a single Amazon GuardDuty detector. A detector is a resource that represents the GuardDuty service. To start using GuardDuty, you must create a detector in each Region where you enable the service. You can have only one detector per account per Region. All data sources are enabled in a new detector by default.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_detector.html](https://paws-r.github.io/docs/guardduty/create_detector.html) for full documentation.
#'
#' @param Enable &#91;required&#93; A Boolean value that specifies whether the detector is to be enabled.
#' @param ClientToken The idempotency token for the create request.
#' @param FindingPublishingFrequency A value that specifies how frequently updated findings are exported.
#' @param DataSources Describes which data sources will be enabled for the detector.
#' @param Tags The tags to be added to a new detector resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_detector
guardduty_create_detector <- function(Enable, ClientToken = NULL, FindingPublishingFrequency = NULL, DataSources = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDetector",
    http_method = "POST",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$create_detector_input(Enable = Enable, ClientToken = ClientToken, FindingPublishingFrequency = FindingPublishingFrequency, DataSources = DataSources, Tags = Tags)
  output <- .guardduty$create_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_detector <- guardduty_create_detector

#' Creates a filter using the specified finding criteria
#'
#' @description
#' Creates a filter using the specified finding criteria.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_filter.html](https://paws-r.github.io/docs/guardduty/create_filter.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector belonging to the GuardDuty account that you want
#' to create a filter for.
#' @param Name &#91;required&#93; The name of the filter. Minimum length of 3. Maximum length of 64. Valid
#' characters include alphanumeric characters, dot (.), underscore (_),
#' and dash (-). Spaces are not allowed.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria &#91;required&#93; Represents the criteria to be used in the filter for querying findings.
#' 
#' You can only use the following attributes to query findings:
#' 
#' -   accountId
#' 
#' -   region
#' 
#' -   confidence
#' 
#' -   id
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.outpostArn
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.resourceType
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.errorCode
#' 
#' -   service.action.awsApiCallAction.userAgent
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.localIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   resource.s3BucketDetails.publicAccess.effectivePermissions
#' 
#' -   resource.s3BucketDetails.name
#' 
#' -   resource.s3BucketDetails.tags.key
#' 
#' -   resource.s3BucketDetails.tags.value
#' 
#' -   resource.s3BucketDetails.type
#' 
#' -   service.archived
#' 
#'     When this attribute is set to TRUE, only archived findings are
#'     listed. When it's set to FALSE, only unarchived findings are listed.
#'     When this attribute is not set, all existing findings are listed.
#' 
#' -   service.resourceRole
#' 
#' -   severity
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: ISO 8601 string format: YYYY-MM-DDTHH:MM:SS.SSSZ or
#'     YYYY-MM-DDTHH:MM:SSZ depending on whether the value contains
#'     milliseconds.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new filter resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_filter
guardduty_create_filter <- function(DetectorId, Name, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$create_filter_input(DetectorId = DetectorId, Name = Name, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_filter <- guardduty_create_filter

#' Creates a new IPSet, which is called a trusted IP list in the console
#' user interface
#'
#' @description
#' Creates a new IPSet, which is called a trusted IP list in the console user interface. An IPSet is a list of IP addresses that are trusted for secure communication with Amazon Web Services infrastructure and applications. GuardDuty doesn't generate findings for IP addresses that are included in IPSets. Only users from the administrator account can use this operation.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_ip_set.html](https://paws-r.github.io/docs/guardduty/create_ip_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' create an IPSet for.
#' @param Name &#91;required&#93; The user-friendly name to identify the IPSet.
#' 
#' Allowed characters are alphanumerics, spaces, hyphens (-), and
#' underscores (_).
#' @param Format &#91;required&#93; The format of the file that contains the IPSet.
#' @param Location &#91;required&#93; The URI of the file that contains the IPSet.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded IPSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new IP set resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_ip_set
guardduty_create_ip_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$create_ip_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_ip_set <- guardduty_create_ip_set

#' Creates member accounts of the current Amazon Web Services account by
#' specifying a list of Amazon Web Services account IDs
#'
#' @description
#' Creates member accounts of the current Amazon Web Services account by specifying a list of Amazon Web Services account IDs. This step is a prerequisite for managing the associated member accounts either by invitation or through an organization.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_members.html](https://paws-r.github.io/docs/guardduty/create_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' associate member accounts with.
#' @param AccountDetails &#91;required&#93; A list of account ID and email address pairs of the accounts that you
#' want to associate with the GuardDuty administrator account.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_members
guardduty_create_members <- function(DetectorId, AccountDetails) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$create_members_input(DetectorId = DetectorId, AccountDetails = AccountDetails)
  output <- .guardduty$create_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_members <- guardduty_create_members

#' Creates a publishing destination to export findings to
#'
#' @description
#' Creates a publishing destination to export findings to. The resource to export findings to must exist before you use this operation.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_publishing_destination.html](https://paws-r.github.io/docs/guardduty/create_publishing_destination.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the GuardDuty detector associated with the publishing
#' destination.
#' @param DestinationType &#91;required&#93; The type of resource for the publishing destination. Currently only
#' Amazon S3 buckets are supported.
#' @param DestinationProperties &#91;required&#93; The properties of the publishing destination, including the ARNs for the
#' destination and the KMS key used for encryption.
#' @param ClientToken The idempotency token for the request.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_publishing_destination
guardduty_create_publishing_destination <- function(DetectorId, DestinationType, DestinationProperties, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination",
    paginator = list()
  )
  input <- .guardduty$create_publishing_destination_input(DetectorId = DetectorId, DestinationType = DestinationType, DestinationProperties = DestinationProperties, ClientToken = ClientToken)
  output <- .guardduty$create_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_publishing_destination <- guardduty_create_publishing_destination

#' Generates example findings of types specified by the list of finding
#' types
#'
#' @description
#' Generates example findings of types specified by the list of finding types. If 'NULL' is specified for `findingTypes`, the API generates example findings of all supported finding types.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_sample_findings.html](https://paws-r.github.io/docs/guardduty/create_sample_findings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to create sample findings for.
#' @param FindingTypes The types of sample findings to generate.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_sample_findings
guardduty_create_sample_findings <- function(DetectorId, FindingTypes = NULL) {
  op <- new_operation(
    name = "CreateSampleFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/create",
    paginator = list()
  )
  input <- .guardduty$create_sample_findings_input(DetectorId = DetectorId, FindingTypes = FindingTypes)
  output <- .guardduty$create_sample_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_sample_findings <- guardduty_create_sample_findings

#' Creates a new ThreatIntelSet
#'
#' @description
#' Creates a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP addresses. GuardDuty generates findings based on ThreatIntelSets. Only users of the administrator account can use this operation.
#'
#' See [https://paws-r.github.io/docs/guardduty/create_threat_intel_set.html](https://paws-r.github.io/docs/guardduty/create_threat_intel_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' create a threatIntelSet for.
#' @param Name &#91;required&#93; A user-friendly ThreatIntelSet name displayed in all findings that are
#' generated by activity that involves IP addresses included in this
#' ThreatIntelSet.
#' @param Format &#91;required&#93; The format of the file that contains the ThreatIntelSet.
#' @param Location &#91;required&#93; The URI of the file that contains the ThreatIntelSet.
#' @param Activate &#91;required&#93; A Boolean value that indicates whether GuardDuty is to start using the
#' uploaded ThreatIntelSet.
#' @param ClientToken The idempotency token for the create request.
#' @param Tags The tags to be added to a new threat list resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_create_threat_intel_set
guardduty_create_threat_intel_set <- function(DetectorId, Name, Format, Location, Activate, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$create_threat_intel_set_input(DetectorId = DetectorId, Name = Name, Format = Format, Location = Location, Activate = Activate, ClientToken = ClientToken, Tags = Tags)
  output <- .guardduty$create_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$create_threat_intel_set <- guardduty_create_threat_intel_set

#' Declines invitations sent to the current member account by Amazon Web
#' Services accounts specified by their account IDs
#'
#' @description
#' Declines invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/decline_invitations.html](https://paws-r.github.io/docs/guardduty/decline_invitations.html) for full documentation.
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the Amazon Web Services accounts that sent
#' invitations to the current member account that you want to decline
#' invitations from.
#'
#' @keywords internal
#'
#' @rdname guardduty_decline_invitations
guardduty_decline_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitation/decline",
    paginator = list()
  )
  input <- .guardduty$decline_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$decline_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$decline_invitations <- guardduty_decline_invitations

#' Deletes an Amazon GuardDuty detector that is specified by the detector
#' ID
#'
#' @description
#' Deletes an Amazon GuardDuty detector that is specified by the detector ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_detector.html](https://paws-r.github.io/docs/guardduty/delete_detector.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_detector
guardduty_delete_detector <- function(DetectorId) {
  op <- new_operation(
    name = "DeleteDetector",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$delete_detector_input(DetectorId = DetectorId)
  output <- .guardduty$delete_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_detector <- guardduty_delete_detector

#' Deletes the filter specified by the filter name
#'
#' @description
#' Deletes the filter specified by the filter name.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_filter.html](https://paws-r.github.io/docs/guardduty/delete_filter.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter that you want to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_filter
guardduty_delete_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$delete_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$delete_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_filter <- guardduty_delete_filter

#' Deletes the IPSet specified by the ipSetId
#'
#' @description
#' Deletes the IPSet specified by the `ipSetId`. IPSets are called trusted IP lists in the console user interface.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_ip_set.html](https://paws-r.github.io/docs/guardduty/delete_ip_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the IPSet.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_ip_set
guardduty_delete_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$delete_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_ip_set <- guardduty_delete_ip_set

#' Deletes invitations sent to the current member account by Amazon Web
#' Services accounts specified by their account IDs
#'
#' @description
#' Deletes invitations sent to the current member account by Amazon Web Services accounts specified by their account IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_invitations.html](https://paws-r.github.io/docs/guardduty/delete_invitations.html) for full documentation.
#'
#' @param AccountIds &#91;required&#93; A list of account IDs of the Amazon Web Services accounts that sent
#' invitations to the current member account that you want to delete
#' invitations from.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_invitations
guardduty_delete_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitation/delete",
    paginator = list()
  )
  input <- .guardduty$delete_invitations_input(AccountIds = AccountIds)
  output <- .guardduty$delete_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_invitations <- guardduty_delete_invitations

#' Deletes GuardDuty member accounts (to the current GuardDuty
#' administrator account) specified by the account IDs
#'
#' @description
#' Deletes GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_members.html](https://paws-r.github.io/docs/guardduty/delete_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to delete.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_members
guardduty_delete_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/delete",
    paginator = list()
  )
  input <- .guardduty$delete_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$delete_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_members <- guardduty_delete_members

#' Deletes the publishing definition with the specified destinationId
#'
#' @description
#' Deletes the publishing definition with the specified `destinationId`.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_publishing_destination.html](https://paws-r.github.io/docs/guardduty/delete_publishing_destination.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to delete.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_publishing_destination
guardduty_delete_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DeletePublishingDestination",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$delete_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$delete_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_publishing_destination <- guardduty_delete_publishing_destination

#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' @description
#' Deletes the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/delete_threat_intel_set.html](https://paws-r.github.io/docs/guardduty/delete_threat_intel_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to delete.
#'
#' @keywords internal
#'
#' @rdname guardduty_delete_threat_intel_set
guardduty_delete_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "DeleteThreatIntelSet",
    http_method = "DELETE",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$delete_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$delete_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$delete_threat_intel_set <- guardduty_delete_threat_intel_set

#' Returns a list of malware scans
#'
#' @description
#' Returns a list of malware scans.
#'
#' See [https://paws-r.github.io/docs/guardduty/describe_malware_scans.html](https://paws-r.github.io/docs/guardduty/describe_malware_scans.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the request is associated with.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param FilterCriteria Represents the criteria to be used in the filter for describing scan
#' entries.
#' @param SortCriteria Represents the criteria used for sorting scan entries.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_malware_scans
guardduty_describe_malware_scans <- function(DetectorId, NextToken = NULL, MaxResults = NULL, FilterCriteria = NULL, SortCriteria = NULL) {
  op <- new_operation(
    name = "DescribeMalwareScans",
    http_method = "POST",
    http_path = "/detector/{detectorId}/malware-scans",
    paginator = list()
  )
  input <- .guardduty$describe_malware_scans_input(DetectorId = DetectorId, NextToken = NextToken, MaxResults = MaxResults, FilterCriteria = FilterCriteria, SortCriteria = SortCriteria)
  output <- .guardduty$describe_malware_scans_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_malware_scans <- guardduty_describe_malware_scans

#' Returns information about the account selected as the delegated
#' administrator for GuardDuty
#'
#' @description
#' Returns information about the account selected as the delegated administrator for GuardDuty.
#'
#' See [https://paws-r.github.io/docs/guardduty/describe_organization_configuration.html](https://paws-r.github.io/docs/guardduty/describe_organization_configuration.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to retrieve information about the delegated
#' administrator from.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_organization_configuration
guardduty_describe_organization_configuration <- function(DetectorId) {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/detector/{detectorId}/admin",
    paginator = list()
  )
  input <- .guardduty$describe_organization_configuration_input(DetectorId = DetectorId)
  output <- .guardduty$describe_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_organization_configuration <- guardduty_describe_organization_configuration

#' Returns information about the publishing destination specified by the
#' provided destinationId
#'
#' @description
#' Returns information about the publishing destination specified by the provided `destinationId`.
#'
#' See [https://paws-r.github.io/docs/guardduty/describe_publishing_destination.html](https://paws-r.github.io/docs/guardduty/describe_publishing_destination.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the publishing destination
#' to retrieve.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to retrieve.
#'
#' @keywords internal
#'
#' @rdname guardduty_describe_publishing_destination
guardduty_describe_publishing_destination <- function(DetectorId, DestinationId) {
  op <- new_operation(
    name = "DescribePublishingDestination",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$describe_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId)
  output <- .guardduty$describe_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$describe_publishing_destination <- guardduty_describe_publishing_destination

#' Disables an Amazon Web Services account within the Organization as the
#' GuardDuty delegated administrator
#'
#' @description
#' Disables an Amazon Web Services account within the Organization as the GuardDuty delegated administrator.
#'
#' See [https://paws-r.github.io/docs/guardduty/disable_organization_admin_account.html](https://paws-r.github.io/docs/guardduty/disable_organization_admin_account.html) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services Account ID for the organizations account to be
#' disabled as a GuardDuty delegated administrator.
#'
#' @keywords internal
#'
#' @rdname guardduty_disable_organization_admin_account
guardduty_disable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/disable",
    paginator = list()
  )
  input <- .guardduty$disable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disable_organization_admin_account <- guardduty_disable_organization_admin_account

#' Disassociates the current GuardDuty member account from its
#' administrator account
#'
#' @description
#' Disassociates the current GuardDuty member account from its administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/disassociate_from_administrator_account.html](https://paws-r.github.io/docs/guardduty/disassociate_from_administrator_account.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_administrator_account
guardduty_disassociate_from_administrator_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromAdministratorAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/administrator/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_from_administrator_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_administrator_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_administrator_account <- guardduty_disassociate_from_administrator_account

#' Disassociates the current GuardDuty member account from its
#' administrator account
#'
#' @description
#' Disassociates the current GuardDuty member account from its administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/disassociate_from_master_account.html](https://paws-r.github.io/docs/guardduty/disassociate_from_master_account.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_from_master_account
guardduty_disassociate_from_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/detector/{detectorId}/master/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_from_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_from_master_account <- guardduty_disassociate_from_master_account

#' Disassociates GuardDuty member accounts (to the current GuardDuty
#' administrator account) specified by the account IDs
#'
#' @description
#' Disassociates GuardDuty member accounts (to the current GuardDuty administrator account) specified by the account IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/disassociate_members.html](https://paws-r.github.io/docs/guardduty/disassociate_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to disassociate from the administrator account.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' disassociate from the administrator account.
#'
#' @keywords internal
#'
#' @rdname guardduty_disassociate_members
guardduty_disassociate_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/disassociate",
    paginator = list()
  )
  input <- .guardduty$disassociate_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$disassociate_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$disassociate_members <- guardduty_disassociate_members

#' Enables an Amazon Web Services account within the organization as the
#' GuardDuty delegated administrator
#'
#' @description
#' Enables an Amazon Web Services account within the organization as the GuardDuty delegated administrator.
#'
#' See [https://paws-r.github.io/docs/guardduty/enable_organization_admin_account.html](https://paws-r.github.io/docs/guardduty/enable_organization_admin_account.html) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services Account ID for the organization account to be
#' enabled as a GuardDuty delegated administrator.
#'
#' @keywords internal
#'
#' @rdname guardduty_enable_organization_admin_account
guardduty_enable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin/enable",
    paginator = list()
  )
  input <- .guardduty$enable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .guardduty$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$enable_organization_admin_account <- guardduty_enable_organization_admin_account

#' Provides the details for the GuardDuty administrator account associated
#' with the current GuardDuty member account
#'
#' @description
#' Provides the details for the GuardDuty administrator account associated with the current GuardDuty member account.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_administrator_account.html](https://paws-r.github.io/docs/guardduty/get_administrator_account.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_administrator_account
guardduty_get_administrator_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetAdministratorAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/administrator",
    paginator = list()
  )
  input <- .guardduty$get_administrator_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_administrator_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_administrator_account <- guardduty_get_administrator_account

#' Retrieves an Amazon GuardDuty detector specified by the detectorId
#'
#' @description
#' Retrieves an Amazon GuardDuty detector specified by the detectorId.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_detector.html](https://paws-r.github.io/docs/guardduty/get_detector.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that you want to get.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_detector
guardduty_get_detector <- function(DetectorId) {
  op <- new_operation(
    name = "GetDetector",
    http_method = "GET",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$get_detector_input(DetectorId = DetectorId)
  output <- .guardduty$get_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_detector <- guardduty_get_detector

#' Returns the details of the filter specified by the filter name
#'
#' @description
#' Returns the details of the filter specified by the filter name.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_filter.html](https://paws-r.github.io/docs/guardduty/get_filter.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param FilterName &#91;required&#93; The name of the filter you want to get.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_filter
guardduty_get_filter <- function(DetectorId, FilterName) {
  op <- new_operation(
    name = "GetFilter",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$get_filter_input(DetectorId = DetectorId, FilterName = FilterName)
  output <- .guardduty$get_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_filter <- guardduty_get_filter

#' Describes Amazon GuardDuty findings specified by finding IDs
#'
#' @description
#' Describes Amazon GuardDuty findings specified by finding IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_findings.html](https://paws-r.github.io/docs/guardduty/get_findings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to retrieve.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to retrieve.
#' @param SortCriteria Represents the criteria used for sorting findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings
guardduty_get_findings <- function(DetectorId, FindingIds, SortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/get",
    paginator = list()
  )
  input <- .guardduty$get_findings_input(DetectorId = DetectorId, FindingIds = FindingIds, SortCriteria = SortCriteria)
  output <- .guardduty$get_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings <- guardduty_get_findings

#' Lists Amazon GuardDuty findings statistics for the specified detector ID
#'
#' @description
#' Lists Amazon GuardDuty findings statistics for the specified detector ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_findings_statistics.html](https://paws-r.github.io/docs/guardduty/get_findings_statistics.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings' statistics you want to retrieve.
#' @param FindingStatisticTypes &#91;required&#93; The types of finding statistics to retrieve.
#' @param FindingCriteria Represents the criteria that is used for querying findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_findings_statistics
guardduty_get_findings_statistics <- function(DetectorId, FindingStatisticTypes, FindingCriteria = NULL) {
  op <- new_operation(
    name = "GetFindingsStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/statistics",
    paginator = list()
  )
  input <- .guardduty$get_findings_statistics_input(DetectorId = DetectorId, FindingStatisticTypes = FindingStatisticTypes, FindingCriteria = FindingCriteria)
  output <- .guardduty$get_findings_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_findings_statistics <- guardduty_get_findings_statistics

#' Retrieves the IPSet specified by the ipSetId
#'
#' @description
#' Retrieves the IPSet specified by the `ipSetId`.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_ip_set.html](https://paws-r.github.io/docs/guardduty/get_ip_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the IPSet is associated with.
#' @param IpSetId &#91;required&#93; The unique ID of the IPSet to retrieve.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_ip_set
guardduty_get_ip_set <- function(DetectorId, IpSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$get_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId)
  output <- .guardduty$get_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_ip_set <- guardduty_get_ip_set

#' Returns the count of all GuardDuty membership invitations that were sent
#' to the current member account except the currently accepted invitation
#'
#' @description
#' Returns the count of all GuardDuty membership invitations that were sent to the current member account except the currently accepted invitation.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_invitations_count.html](https://paws-r.github.io/docs/guardduty/get_invitations_count.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_invitations_count
guardduty_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitation/count",
    paginator = list()
  )
  input <- .guardduty$get_invitations_count_input()
  output <- .guardduty$get_invitations_count_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_invitations_count <- guardduty_get_invitations_count

#' Returns the details of the malware scan settings
#'
#' @description
#' Returns the details of the malware scan settings.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_malware_scan_settings.html](https://paws-r.github.io/docs/guardduty/get_malware_scan_settings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the scan setting is associated with.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_malware_scan_settings
guardduty_get_malware_scan_settings <- function(DetectorId) {
  op <- new_operation(
    name = "GetMalwareScanSettings",
    http_method = "GET",
    http_path = "/detector/{detectorId}/malware-scan-settings",
    paginator = list()
  )
  input <- .guardduty$get_malware_scan_settings_input(DetectorId = DetectorId)
  output <- .guardduty$get_malware_scan_settings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_malware_scan_settings <- guardduty_get_malware_scan_settings

#' Provides the details for the GuardDuty administrator account associated
#' with the current GuardDuty member account
#'
#' @description
#' Provides the details for the GuardDuty administrator account associated with the current GuardDuty member account.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_master_account.html](https://paws-r.github.io/docs/guardduty/get_master_account.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_master_account
guardduty_get_master_account <- function(DetectorId) {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/detector/{detectorId}/master",
    paginator = list()
  )
  input <- .guardduty$get_master_account_input(DetectorId = DetectorId)
  output <- .guardduty$get_master_account_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_master_account <- guardduty_get_master_account

#' Describes which data sources are enabled for the member account's
#' detector
#'
#' @description
#' Describes which data sources are enabled for the member account's detector.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_member_detectors.html](https://paws-r.github.io/docs/guardduty/get_member_detectors.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID for the administrator account.
#' @param AccountIds &#91;required&#93; The account ID of the member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_member_detectors
guardduty_get_member_detectors <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMemberDetectors",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/detector/get",
    paginator = list()
  )
  input <- .guardduty$get_member_detectors_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_member_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_member_detectors <- guardduty_get_member_detectors

#' Retrieves GuardDuty member accounts (of the current GuardDuty
#' administrator account) specified by the account IDs
#'
#' @description
#' Retrieves GuardDuty member accounts (of the current GuardDuty administrator account) specified by the account IDs.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_members.html](https://paws-r.github.io/docs/guardduty/get_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account whose members you
#' want to retrieve.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts that you want to
#' describe.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_members
guardduty_get_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/get",
    paginator = list()
  )
  input <- .guardduty$get_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_members <- guardduty_get_members

#' Provides the number of days left for each data source used in the free
#' trial period
#'
#' @description
#' Provides the number of days left for each data source used in the free trial period.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_remaining_free_trial_days.html](https://paws-r.github.io/docs/guardduty/get_remaining_free_trial_days.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty member account.
#' @param AccountIds A list of account identifiers of the GuardDuty member account.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_remaining_free_trial_days
guardduty_get_remaining_free_trial_days <- function(DetectorId, AccountIds = NULL) {
  op <- new_operation(
    name = "GetRemainingFreeTrialDays",
    http_method = "POST",
    http_path = "/detector/{detectorId}/freeTrial/daysRemaining",
    paginator = list()
  )
  input <- .guardduty$get_remaining_free_trial_days_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$get_remaining_free_trial_days_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_remaining_free_trial_days <- guardduty_get_remaining_free_trial_days

#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID
#'
#' @description
#' Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/get_threat_intel_set.html](https://paws-r.github.io/docs/guardduty/get_threat_intel_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID of the threatIntelSet that you want to get.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_threat_intel_set
guardduty_get_threat_intel_set <- function(DetectorId, ThreatIntelSetId) {
  op <- new_operation(
    name = "GetThreatIntelSet",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$get_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId)
  output <- .guardduty$get_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_threat_intel_set <- guardduty_get_threat_intel_set

#' Lists Amazon GuardDuty usage statistics over the last 30 days for the
#' specified detector ID
#'
#' @description
#' Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For more information, see [Understanding How Usage Costs are Calculated](https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations).
#'
#' See [https://paws-r.github.io/docs/guardduty/get_usage_statistics.html](https://paws-r.github.io/docs/guardduty/get_usage_statistics.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose usage
#' statistics you want to retrieve.
#' @param UsageStatisticType &#91;required&#93; The type of usage statistics to retrieve.
#' @param UsageCriteria &#91;required&#93; Represents the criteria used for querying usage.
#' @param Unit The currency unit you would like to view your usage statistics in.
#' Current valid values are USD.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the NextToken value returned from the
#' previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_get_usage_statistics
guardduty_get_usage_statistics <- function(DetectorId, UsageStatisticType, UsageCriteria, Unit = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUsageStatistics",
    http_method = "POST",
    http_path = "/detector/{detectorId}/usage/statistics",
    paginator = list()
  )
  input <- .guardduty$get_usage_statistics_input(DetectorId = DetectorId, UsageStatisticType = UsageStatisticType, UsageCriteria = UsageCriteria, Unit = Unit, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$get_usage_statistics_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$get_usage_statistics <- guardduty_get_usage_statistics

#' Invites other Amazon Web Services accounts (created as members of the
#' current Amazon Web Services account by CreateMembers) to enable
#' GuardDuty, and allow the current Amazon Web Services account to view and
#' manage these accounts' findings on their behalf as the GuardDuty
#' administrator account
#'
#' @description
#' Invites other Amazon Web Services accounts (created as members of the current Amazon Web Services account by CreateMembers) to enable GuardDuty, and allow the current Amazon Web Services account to view and manage these accounts' findings on their behalf as the GuardDuty administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/invite_members.html](https://paws-r.github.io/docs/guardduty/invite_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty account that you want to
#' invite members with.
#' @param AccountIds &#91;required&#93; A list of account IDs of the accounts that you want to invite to
#' GuardDuty as members.
#' @param DisableEmailNotification A Boolean value that specifies whether you want to disable email
#' notification to the accounts that you are inviting to GuardDuty as
#' members.
#' @param Message The invitation message that you want to send to the accounts that you're
#' inviting to GuardDuty as members.
#'
#' @keywords internal
#'
#' @rdname guardduty_invite_members
guardduty_invite_members <- function(DetectorId, AccountIds, DisableEmailNotification = NULL, Message = NULL) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/invite",
    paginator = list()
  )
  input <- .guardduty$invite_members_input(DetectorId = DetectorId, AccountIds = AccountIds, DisableEmailNotification = DisableEmailNotification, Message = Message)
  output <- .guardduty$invite_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$invite_members <- guardduty_invite_members

#' Lists detectorIds of all the existing Amazon GuardDuty detector
#' resources
#'
#' @description
#' Lists detectorIds of all the existing Amazon GuardDuty detector resources.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_detectors.html](https://paws-r.github.io/docs/guardduty/list_detectors.html) for full documentation.
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_detectors
guardduty_list_detectors <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDetectors",
    http_method = "GET",
    http_path = "/detector",
    paginator = list()
  )
  input <- .guardduty$list_detectors_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_detectors <- guardduty_list_detectors

#' Returns a paginated list of the current filters
#'
#' @description
#' Returns a paginated list of the current filters.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_filters.html](https://paws-r.github.io/docs/guardduty/list_filters.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the filter is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_filters
guardduty_list_filters <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "GET",
    http_path = "/detector/{detectorId}/filter",
    paginator = list()
  )
  input <- .guardduty$list_filters_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_filters_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_filters <- guardduty_list_filters

#' Lists Amazon GuardDuty findings for the specified detector ID
#'
#' @description
#' Lists Amazon GuardDuty findings for the specified detector ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_findings.html](https://paws-r.github.io/docs/guardduty/list_findings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector that specifies the GuardDuty service whose
#' findings you want to list.
#' @param FindingCriteria Represents the criteria used for querying findings. Valid values
#' include:
#' 
#' -   JSON field name
#' 
#' -   accountId
#' 
#' -   region
#' 
#' -   confidence
#' 
#' -   id
#' 
#' -   resource.accessKeyDetails.accessKeyId
#' 
#' -   resource.accessKeyDetails.principalId
#' 
#' -   resource.accessKeyDetails.userName
#' 
#' -   resource.accessKeyDetails.userType
#' 
#' -   resource.instanceDetails.iamInstanceProfile.id
#' 
#' -   resource.instanceDetails.imageId
#' 
#' -   resource.instanceDetails.instanceId
#' 
#' -   resource.instanceDetails.networkInterfaces.ipv6Addresses
#' 
#' -   resource.instanceDetails.networkInterfaces.privateIpAddresses.privateIpAddress
#' 
#' -   resource.instanceDetails.networkInterfaces.publicDnsName
#' 
#' -   resource.instanceDetails.networkInterfaces.publicIp
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupId
#' 
#' -   resource.instanceDetails.networkInterfaces.securityGroups.groupName
#' 
#' -   resource.instanceDetails.networkInterfaces.subnetId
#' 
#' -   resource.instanceDetails.networkInterfaces.vpcId
#' 
#' -   resource.instanceDetails.tags.key
#' 
#' -   resource.instanceDetails.tags.value
#' 
#' -   resource.resourceType
#' 
#' -   service.action.actionType
#' 
#' -   service.action.awsApiCallAction.api
#' 
#' -   service.action.awsApiCallAction.callerType
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.city.cityName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.awsApiCallAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.awsApiCallAction.serviceName
#' 
#' -   service.action.dnsRequestAction.domain
#' 
#' -   service.action.networkConnectionAction.blocked
#' 
#' -   service.action.networkConnectionAction.connectionDirection
#' 
#' -   service.action.networkConnectionAction.localPortDetails.port
#' 
#' -   service.action.networkConnectionAction.protocol
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.country.countryName
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.ipAddressV4
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asn
#' 
#' -   service.action.networkConnectionAction.remoteIpDetails.organization.asnOrg
#' 
#' -   service.action.networkConnectionAction.remotePortDetails.port
#' 
#' -   service.additionalInfo.threatListName
#' 
#' -   service.archived
#' 
#'     When this attribute is set to 'true', only archived findings are
#'     listed. When it's set to 'false', only unarchived findings are
#'     listed. When this attribute is not set, all existing findings are
#'     listed.
#' 
#' -   service.resourceRole
#' 
#' -   severity
#' 
#' -   type
#' 
#' -   updatedAt
#' 
#'     Type: Timestamp in Unix Epoch millisecond format: 1486685375000
#' @param SortCriteria Represents the criteria used for sorting findings.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_findings
guardduty_list_findings <- function(DetectorId, FindingCriteria = NULL, SortCriteria = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings",
    paginator = list()
  )
  input <- .guardduty$list_findings_input(DetectorId = DetectorId, FindingCriteria = FindingCriteria, SortCriteria = SortCriteria, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_findings <- guardduty_list_findings

#' Lists the IPSets of the GuardDuty service specified by the detector ID
#'
#' @description
#' Lists the IPSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the IPSets returned are the IPSets from the associated administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_ip_sets.html](https://paws-r.github.io/docs/guardduty/list_ip_sets.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the IPSet is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_ip_sets
guardduty_list_ip_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/ipset",
    paginator = list()
  )
  input <- .guardduty$list_ip_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_ip_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_ip_sets <- guardduty_list_ip_sets

#' Lists all GuardDuty membership invitations that were sent to the current
#' Amazon Web Services account
#'
#' @description
#' Lists all GuardDuty membership invitations that were sent to the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_invitations.html](https://paws-r.github.io/docs/guardduty/list_invitations.html) for full documentation.
#'
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_invitations
guardduty_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitation",
    paginator = list()
  )
  input <- .guardduty$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_invitations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_invitations <- guardduty_list_invitations

#' Lists details about all member accounts for the current GuardDuty
#' administrator account
#'
#' @description
#' Lists details about all member accounts for the current GuardDuty administrator account.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_members.html](https://paws-r.github.io/docs/guardduty/list_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector the member is associated with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 50. The maximum value is 50.
#' @param NextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the list action. For
#' subsequent calls to the action, fill nextToken in the request with the
#' value of NextToken from the previous response to continue listing data.
#' @param OnlyAssociated Specifies whether to only return associated members or to return all
#' members (including members who haven't been invited yet or have been
#' disassociated).
#'
#' @keywords internal
#'
#' @rdname guardduty_list_members
guardduty_list_members <- function(DetectorId, MaxResults = NULL, NextToken = NULL, OnlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/detector/{detectorId}/member",
    paginator = list()
  )
  input <- .guardduty$list_members_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken, OnlyAssociated = OnlyAssociated)
  output <- .guardduty$list_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_members <- guardduty_list_members

#' Lists the accounts configured as GuardDuty delegated administrators
#'
#' @description
#' Lists the accounts configured as GuardDuty delegated administrators.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_organization_admin_accounts.html](https://paws-r.github.io/docs/guardduty/list_organization_admin_accounts.html) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_organization_admin_accounts
guardduty_list_organization_admin_accounts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "GET",
    http_path = "/admin",
    paginator = list()
  )
  input <- .guardduty$list_organization_admin_accounts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_organization_admin_accounts <- guardduty_list_organization_admin_accounts

#' Returns a list of publishing destinations associated with the specified
#' detectorId
#'
#' @description
#' Returns a list of publishing destinations associated with the specified `detectorId`.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_publishing_destinations.html](https://paws-r.github.io/docs/guardduty/list_publishing_destinations.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to retrieve publishing destinations for.
#' @param MaxResults The maximum number of results to return in the response.
#' @param NextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_publishing_destinations
guardduty_list_publishing_destinations <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPublishingDestinations",
    http_method = "GET",
    http_path = "/detector/{detectorId}/publishingDestination",
    paginator = list()
  )
  input <- .guardduty$list_publishing_destinations_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_publishing_destinations_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_publishing_destinations <- guardduty_list_publishing_destinations

#' Lists tags for a resource
#'
#' @description
#' Lists tags for a resource. Tagging is currently supported for detectors, finding filters, IP sets, and threat intel sets, with a limit of 50 tags per resource. When invoked, this operation returns all assigned tags for a given resource.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_tags_for_resource.html](https://paws-r.github.io/docs/guardduty/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the given GuardDuty resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_tags_for_resource
guardduty_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .guardduty$list_tags_for_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_tags_for_resource <- guardduty_list_tags_for_resource

#' Lists the ThreatIntelSets of the GuardDuty service specified by the
#' detector ID
#'
#' @description
#' Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID. If you use this operation from a member account, the ThreatIntelSets associated with the administrator account are returned.
#'
#' See [https://paws-r.github.io/docs/guardduty/list_threat_intel_sets.html](https://paws-r.github.io/docs/guardduty/list_threat_intel_sets.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that the threatIntelSet is associated
#' with.
#' @param MaxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 50. The maximum value is
#' 50.
#' @param NextToken You can use this parameter to paginate results in the response. Set the
#' value of this parameter to null on your first call to the list action.
#' For subsequent calls to the action, fill nextToken in the request with
#' the value of NextToken from the previous response to continue listing
#' data.
#'
#' @keywords internal
#'
#' @rdname guardduty_list_threat_intel_sets
guardduty_list_threat_intel_sets <- function(DetectorId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListThreatIntelSets",
    http_method = "GET",
    http_path = "/detector/{detectorId}/threatintelset",
    paginator = list()
  )
  input <- .guardduty$list_threat_intel_sets_input(DetectorId = DetectorId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .guardduty$list_threat_intel_sets_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$list_threat_intel_sets <- guardduty_list_threat_intel_sets

#' Turns on GuardDuty monitoring of the specified member accounts
#'
#' @description
#' Turns on GuardDuty monitoring of the specified member accounts. Use this operation to restart monitoring of accounts that you stopped monitoring with the [`stop_monitoring_members`][guardduty_stop_monitoring_members] operation.
#'
#' See [https://paws-r.github.io/docs/guardduty/start_monitoring_members.html](https://paws-r.github.io/docs/guardduty/start_monitoring_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector of the GuardDuty administrator account
#' associated with the member accounts to monitor.
#' @param AccountIds &#91;required&#93; A list of account IDs of the GuardDuty member accounts to start
#' monitoring.
#'
#' @keywords internal
#'
#' @rdname guardduty_start_monitoring_members
guardduty_start_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StartMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/start",
    paginator = list()
  )
  input <- .guardduty$start_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$start_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$start_monitoring_members <- guardduty_start_monitoring_members

#' Stops GuardDuty monitoring for the specified member accounts
#'
#' @description
#' Stops GuardDuty monitoring for the specified member accounts. Use the [`start_monitoring_members`][guardduty_start_monitoring_members] operation to restart monitoring for those accounts.
#'
#' See [https://paws-r.github.io/docs/guardduty/stop_monitoring_members.html](https://paws-r.github.io/docs/guardduty/stop_monitoring_members.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector associated with the GuardDuty
#' administrator account that is monitoring member accounts.
#' @param AccountIds &#91;required&#93; A list of account IDs for the member accounts to stop monitoring.
#'
#' @keywords internal
#'
#' @rdname guardduty_stop_monitoring_members
guardduty_stop_monitoring_members <- function(DetectorId, AccountIds) {
  op <- new_operation(
    name = "StopMonitoringMembers",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/stop",
    paginator = list()
  )
  input <- .guardduty$stop_monitoring_members_input(DetectorId = DetectorId, AccountIds = AccountIds)
  output <- .guardduty$stop_monitoring_members_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$stop_monitoring_members <- guardduty_stop_monitoring_members

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://paws-r.github.io/docs/guardduty/tag_resource.html](https://paws-r.github.io/docs/guardduty/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the GuardDuty resource to apply a tag
#' to.
#' @param Tags &#91;required&#93; The tags to be added to a resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_tag_resource
guardduty_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .guardduty$tag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$tag_resource <- guardduty_tag_resource

#' Unarchives GuardDuty findings specified by the findingIds
#'
#' @description
#' Unarchives GuardDuty findings specified by the `findingIds`.
#'
#' See [https://paws-r.github.io/docs/guardduty/unarchive_findings.html](https://paws-r.github.io/docs/guardduty/unarchive_findings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the findings to unarchive.
#' @param FindingIds &#91;required&#93; The IDs of the findings to unarchive.
#'
#' @keywords internal
#'
#' @rdname guardduty_unarchive_findings
guardduty_unarchive_findings <- function(DetectorId, FindingIds) {
  op <- new_operation(
    name = "UnarchiveFindings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/unarchive",
    paginator = list()
  )
  input <- .guardduty$unarchive_findings_input(DetectorId = DetectorId, FindingIds = FindingIds)
  output <- .guardduty$unarchive_findings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$unarchive_findings <- guardduty_unarchive_findings

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://paws-r.github.io/docs/guardduty/untag_resource.html](https://paws-r.github.io/docs/guardduty/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource to remove tags from.
#' @param TagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname guardduty_untag_resource
guardduty_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .guardduty$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .guardduty$untag_resource_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$untag_resource <- guardduty_untag_resource

#' Updates the Amazon GuardDuty detector specified by the detectorId
#'
#' @description
#' Updates the Amazon GuardDuty detector specified by the detectorId.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_detector.html](https://paws-r.github.io/docs/guardduty/update_detector.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector to update.
#' @param Enable Specifies whether the detector is enabled or not enabled.
#' @param FindingPublishingFrequency An enum value that specifies how frequently findings are exported, such
#' as to CloudWatch Events.
#' @param DataSources Describes which data sources will be updated.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_detector
guardduty_update_detector <- function(DetectorId, Enable = NULL, FindingPublishingFrequency = NULL, DataSources = NULL) {
  op <- new_operation(
    name = "UpdateDetector",
    http_method = "POST",
    http_path = "/detector/{detectorId}",
    paginator = list()
  )
  input <- .guardduty$update_detector_input(DetectorId = DetectorId, Enable = Enable, FindingPublishingFrequency = FindingPublishingFrequency, DataSources = DataSources)
  output <- .guardduty$update_detector_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_detector <- guardduty_update_detector

#' Updates the filter specified by the filter name
#'
#' @description
#' Updates the filter specified by the filter name.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_filter.html](https://paws-r.github.io/docs/guardduty/update_filter.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update a filter.
#' @param FilterName &#91;required&#93; The name of the filter.
#' @param Description The description of the filter.
#' @param Action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param Rank Specifies the position of the filter in the list of current filters.
#' Also specifies the order in which this filter is applied to the
#' findings.
#' @param FindingCriteria Represents the criteria to be used in the filter for querying findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_filter
guardduty_update_filter <- function(DetectorId, FilterName, Description = NULL, Action = NULL, Rank = NULL, FindingCriteria = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/detector/{detectorId}/filter/{filterName}",
    paginator = list()
  )
  input <- .guardduty$update_filter_input(DetectorId = DetectorId, FilterName = FilterName, Description = Description, Action = Action, Rank = Rank, FindingCriteria = FindingCriteria)
  output <- .guardduty$update_filter_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_filter <- guardduty_update_filter

#' Marks the specified GuardDuty findings as useful or not useful
#'
#' @description
#' Marks the specified GuardDuty findings as useful or not useful.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_findings_feedback.html](https://paws-r.github.io/docs/guardduty/update_findings_feedback.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the findings to update feedback
#' for.
#' @param FindingIds &#91;required&#93; The IDs of the findings that you want to mark as useful or not useful.
#' @param Feedback &#91;required&#93; The feedback for the finding.
#' @param Comments Additional feedback about the GuardDuty findings.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_findings_feedback
guardduty_update_findings_feedback <- function(DetectorId, FindingIds, Feedback, Comments = NULL) {
  op <- new_operation(
    name = "UpdateFindingsFeedback",
    http_method = "POST",
    http_path = "/detector/{detectorId}/findings/feedback",
    paginator = list()
  )
  input <- .guardduty$update_findings_feedback_input(DetectorId = DetectorId, FindingIds = FindingIds, Feedback = Feedback, Comments = Comments)
  output <- .guardduty$update_findings_feedback_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_findings_feedback <- guardduty_update_findings_feedback

#' Updates the IPSet specified by the IPSet ID
#'
#' @description
#' Updates the IPSet specified by the IPSet ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_ip_set.html](https://paws-r.github.io/docs/guardduty/update_ip_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose IPSet you want
#' to update.
#' @param IpSetId &#91;required&#93; The unique ID that specifies the IPSet that you want to update.
#' @param Name The unique ID that specifies the IPSet that you want to update.
#' @param Location The updated URI of the file that contains the IPSet.
#' @param Activate The updated Boolean value that specifies whether the IPSet is active or
#' not.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_ip_set
guardduty_update_ip_set <- function(DetectorId, IpSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/ipset/{ipSetId}",
    paginator = list()
  )
  input <- .guardduty$update_ip_set_input(DetectorId = DetectorId, IpSetId = IpSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_ip_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_ip_set <- guardduty_update_ip_set

#' Updates the malware scan settings
#'
#' @description
#' Updates the malware scan settings.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_malware_scan_settings.html](https://paws-r.github.io/docs/guardduty/update_malware_scan_settings.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The unique ID of the detector that specifies the GuardDuty service where
#' you want to update scan settings.
#' @param ScanResourceCriteria Represents the criteria to be used in the filter for selecting resources
#' to scan.
#' @param EbsSnapshotPreservation An enum value representing possible snapshot preservations.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_malware_scan_settings
guardduty_update_malware_scan_settings <- function(DetectorId, ScanResourceCriteria = NULL, EbsSnapshotPreservation = NULL) {
  op <- new_operation(
    name = "UpdateMalwareScanSettings",
    http_method = "POST",
    http_path = "/detector/{detectorId}/malware-scan-settings",
    paginator = list()
  )
  input <- .guardduty$update_malware_scan_settings_input(DetectorId = DetectorId, ScanResourceCriteria = ScanResourceCriteria, EbsSnapshotPreservation = EbsSnapshotPreservation)
  output <- .guardduty$update_malware_scan_settings_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_malware_scan_settings <- guardduty_update_malware_scan_settings

#' Contains information on member accounts to be updated
#'
#' @description
#' Contains information on member accounts to be updated.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_member_detectors.html](https://paws-r.github.io/docs/guardduty/update_member_detectors.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detector ID of the administrator account.
#' @param AccountIds &#91;required&#93; A list of member account IDs to be updated.
#' @param DataSources Describes which data sources will be updated.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_member_detectors
guardduty_update_member_detectors <- function(DetectorId, AccountIds, DataSources = NULL) {
  op <- new_operation(
    name = "UpdateMemberDetectors",
    http_method = "POST",
    http_path = "/detector/{detectorId}/member/detector/update",
    paginator = list()
  )
  input <- .guardduty$update_member_detectors_input(DetectorId = DetectorId, AccountIds = AccountIds, DataSources = DataSources)
  output <- .guardduty$update_member_detectors_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_member_detectors <- guardduty_update_member_detectors

#' Updates the delegated administrator account with the values provided
#'
#' @description
#' Updates the delegated administrator account with the values provided.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_organization_configuration.html](https://paws-r.github.io/docs/guardduty/update_organization_configuration.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector to update the delegated administrator for.
#' @param AutoEnable &#91;required&#93; Indicates whether to automatically enable member accounts in the
#' organization.
#' @param DataSources Describes which data sources will be updated.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_organization_configuration
guardduty_update_organization_configuration <- function(DetectorId, AutoEnable, DataSources = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/detector/{detectorId}/admin",
    paginator = list()
  )
  input <- .guardduty$update_organization_configuration_input(DetectorId = DetectorId, AutoEnable = AutoEnable, DataSources = DataSources)
  output <- .guardduty$update_organization_configuration_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_organization_configuration <- guardduty_update_organization_configuration

#' Updates information about the publishing destination specified by the
#' destinationId
#'
#' @description
#' Updates information about the publishing destination specified by the `destinationId`.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_publishing_destination.html](https://paws-r.github.io/docs/guardduty/update_publishing_destination.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The ID of the detector associated with the publishing destinations to
#' update.
#' @param DestinationId &#91;required&#93; The ID of the publishing destination to update.
#' @param DestinationProperties A `DestinationProperties` object that includes the `DestinationArn` and
#' `KmsKeyArn` of the publishing destination.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_publishing_destination
guardduty_update_publishing_destination <- function(DetectorId, DestinationId, DestinationProperties = NULL) {
  op <- new_operation(
    name = "UpdatePublishingDestination",
    http_method = "POST",
    http_path = "/detector/{detectorId}/publishingDestination/{destinationId}",
    paginator = list()
  )
  input <- .guardduty$update_publishing_destination_input(DetectorId = DetectorId, DestinationId = DestinationId, DestinationProperties = DestinationProperties)
  output <- .guardduty$update_publishing_destination_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_publishing_destination <- guardduty_update_publishing_destination

#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID
#'
#' @description
#' Updates the ThreatIntelSet specified by the ThreatIntelSet ID.
#'
#' See [https://paws-r.github.io/docs/guardduty/update_threat_intel_set.html](https://paws-r.github.io/docs/guardduty/update_threat_intel_set.html) for full documentation.
#'
#' @param DetectorId &#91;required&#93; The detectorID that specifies the GuardDuty service whose ThreatIntelSet
#' you want to update.
#' @param ThreatIntelSetId &#91;required&#93; The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Name The unique ID that specifies the ThreatIntelSet that you want to update.
#' @param Location The updated URI of the file that contains the ThreateIntelSet.
#' @param Activate The updated Boolean value that specifies whether the ThreateIntelSet is
#' active or not.
#'
#' @keywords internal
#'
#' @rdname guardduty_update_threat_intel_set
guardduty_update_threat_intel_set <- function(DetectorId, ThreatIntelSetId, Name = NULL, Location = NULL, Activate = NULL) {
  op <- new_operation(
    name = "UpdateThreatIntelSet",
    http_method = "POST",
    http_path = "/detector/{detectorId}/threatintelset/{threatIntelSetId}",
    paginator = list()
  )
  input <- .guardduty$update_threat_intel_set_input(DetectorId = DetectorId, ThreatIntelSetId = ThreatIntelSetId, Name = Name, Location = Location, Activate = Activate)
  output <- .guardduty$update_threat_intel_set_output()
  config <- get_config()
  svc <- .guardduty$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.guardduty$operations$update_threat_intel_set <- guardduty_update_threat_intel_set
