% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_caller_identity}
\alias{sts_get_caller_identity}
\title{Returns details about the IAM user or role whose credentials are used to
call the operation}
\usage{
sts_get_caller_identity()
}
\description{
Returns details about the IAM user or role whose credentials are used to
call the operation.
}
\details{
No permissions are required to perform this operation. If an
administrator adds a policy to your IAM user or role that explicitly
denies access to the \code{sts:GetCallerIdentity} action, you can still
perform this operation. Permissions are not required because the same
information is returned when an IAM user or role is denied access. To
view an example response, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_access-denied-delete-mfa}{I Am Not Authorized to Perform: iam:DeleteVirtualMFADevice}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_caller_identity()
}
}

\examples{
\dontrun{
# This example shows a request and response made with the credentials for
# a user named Alice in the AWS account 123456789012.
svc$get_caller_identity()

# This example shows a request and response made with temporary
# credentials created by AssumeRole. The name of the assumed role is
# my-role-name, and the RoleSessionName is set to my-role-session-name.
svc$get_caller_identity()

# This example shows a request and response made with temporary
# credentials created by using GetFederationToken. The Name parameter is
# set to my-federated-user-name.
svc$get_caller_identity()
}

}
\keyword{internal}
