% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_verify}
\alias{kms_verify}
\title{Verifies a digital signature that was generated by the Sign operation}
\usage{
kms_verify(KeyId, Message, MessageType, Signature, SigningAlgorithm,
  GrantTokens)
}
\arguments{
\item{KeyId}{[required] Identifies the asymmetric CMK that will be used to verify the signature.
This must be the same CMK that was used to generate the signature. If
you specify a different CMK, the signature verification fails.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{Message}{[required] Specifies the message that was signed. You can submit a raw message of
up to 4096 bytes, or a hash digest of the message. If you submit a
digest, use the \code{MessageType} parameter with a value of \code{DIGEST}.

If the message specified here is different from the message that was
signed, the signature verification fails. A message and its hash digest
are considered to be the same message.}

\item{MessageType}{Tells AWS KMS whether the value of the \code{Message} parameter is a message
or message digest. The default value, RAW, indicates a message. To
indicate a message digest, enter \code{DIGEST}.

Use the \code{DIGEST} value only when the value of the \code{Message} parameter is
a message digest. If you use the \code{DIGEST} value with a raw message, the
security of the verification operation can be compromised.}

\item{Signature}{[required] The signature that the \code{Sign} operation generated.}

\item{SigningAlgorithm}{[required] The signing algorithm that was used to sign the message. If you submit a
different algorithm, the signature verification fails.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Verifies a digital signature that was generated by the Sign operation.
}
\details{
Verification confirms that an authorized user signed the message with
the specified CMK and signing algorithm, and the message hasn\'t changed
since it was signed. If the signature is verified, the value of the
\code{SignatureValid} field in the response is \code{True}. If the signature
verification fails, the \code{Verify} operation fails with an
\code{KMSInvalidSignatureException} exception.

A digital signature is generated by using the private key in an
asymmetric CMK. The signature is verified by using the public key in the
same asymmetric CMK. For information about symmetric and asymmetric
CMKs, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html}{Using Symmetric and Asymmetric CMKs}
in the \emph{AWS Key Management Service Developer Guide}.

To verify a digital signature, you can use the \code{Verify} operation.
Specify the same asymmetric CMK, message, and signing algorithm that
were used to produce the signature.

You can also verify the digital signature by using the public key of the
CMK outside of AWS KMS. Use the GetPublicKey operation to download the
public key in the asymmetric CMK and then use the public key to verify
the signature outside of AWS KMS. The advantage of using the \code{Verify}
operation is that it is performed within AWS KMS. As a result, it\'s
easy to call, the operation is performed within the FIPS boundary, it is
logged in AWS CloudTrail, and you can use key policy and IAM policy to
determine who is authorized to use the CMK to verify signatures.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$verify(
  KeyId = "string",
  Message = raw,
  MessageType = "RAW"|"DIGEST",
  Signature = raw,
  SigningAlgorithm = "RSASSA_PSS_SHA_256"|"RSASSA_PSS_SHA_384"|"RSASSA_PSS_SHA_512"|"RSASSA_PKCS1_V1_5_SHA_256"|"RSASSA_PKCS1_V1_5_SHA_384"|"RSASSA_PKCS1_V1_5_SHA_512"|"ECDSA_SHA_256"|"ECDSA_SHA_384"|"ECDSA_SHA_512",
  GrantTokens = list(
    "string"
  )
)
}
}

\keyword{internal}
