% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_login_profile}
\alias{iam_get_login_profile}
\title{Retrieves the user name and password-creation date for the specified IAM
user}
\usage{
iam_get_login_profile(UserName)
}
\arguments{
\item{UserName}{[required] The name of the user whose login profile you want to retrieve.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Retrieves the user name and password-creation date for the specified IAM
user. If the user has not been assigned a password, the operation
returns a 404 (\code{NoSuchEntity}) error.
}
\section{Request syntax}{
\preformatted{svc$get_login_profile(
  UserName = "string"
)
}
}

\examples{
\dontrun{
# The following command gets information about the password for the IAM
# user named Anika.
svc$get_login_profile(
  UserName = "Anika"
)
}

}
\keyword{internal}
