# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include shield_service.R
NULL

#' Authorizes the DDoS Response Team (DRT) to access the specified Amazon
#' S3 bucket containing your AWS WAF logs
#'
#' Authorizes the DDoS Response Team (DRT) to access the specified Amazon
#' S3 bucket containing your AWS WAF logs. You can associate up to 10
#' Amazon S3 buckets with your subscription.
#' 
#' To use the services of the DRT and make an `AssociateDRTLogBucket`
#' request, you must be subscribed to the [Business Support
#' plan](https://aws.amazon.com/premiumsupport/business-support/) or the
#' [Enterprise Support
#' plan](https://aws.amazon.com/premiumsupport/enterprise-support/).
#'
#' @usage
#' shield_associate_drt_log_bucket(LogBucket)
#'
#' @param LogBucket &#91;required&#93; The Amazon S3 bucket that contains your AWS WAF logs.
#'
#' @section Request syntax:
#' ```
#' svc$associate_drt_log_bucket(
#'   LogBucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_associate_drt_log_bucket
shield_associate_drt_log_bucket <- function(LogBucket) {
  op <- new_operation(
    name = "AssociateDRTLogBucket",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_drt_log_bucket_input(LogBucket = LogBucket)
  output <- .shield$associate_drt_log_bucket_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_drt_log_bucket <- shield_associate_drt_log_bucket

#' Authorizes the DDoS Response Team (DRT), using the specified role, to
#' access your AWS account to assist with DDoS attack mitigation during
#' potential attacks
#'
#' Authorizes the DDoS Response Team (DRT), using the specified role, to
#' access your AWS account to assist with DDoS attack mitigation during
#' potential attacks. This enables the DRT to inspect your AWS WAF
#' configuration and create or update AWS WAF rules and web ACLs.
#' 
#' You can associate only one `RoleArn` with your subscription. If you
#' submit an `AssociateDRTRole` request for an account that already has an
#' associated role, the new `RoleArn` will replace the existing `RoleArn`.
#' 
#' Prior to making the `AssociateDRTRole` request, you must attach the
#' [AWSShieldDRTAccessPolicy](https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy)
#' managed policy to the role you will specify in the request. For more
#' information see Attaching and Detaching IAM Policies. The role must also
#' trust the service principal ` drt.shield.amazonaws.com`. For more
#' information, see [IAM JSON Policy Elements:
#' Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
#' 
#' The DRT will have access only to your AWS WAF and Shield resources. By
#' submitting this request, you authorize the DRT to inspect your AWS WAF
#' and Shield configuration and create and update AWS WAF rules and web
#' ACLs on your behalf. The DRT takes these actions only if explicitly
#' authorized by you.
#' 
#' You must have the `iam:PassRole` permission to make an
#' `AssociateDRTRole` request. For more information, see [Granting a User
#' Permissions to Pass a Role to an AWS
#' Service](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html).
#' 
#' To use the services of the DRT and make an `AssociateDRTRole` request,
#' you must be subscribed to the [Business Support
#' plan](https://aws.amazon.com/premiumsupport/business-support/) or the
#' [Enterprise Support
#' plan](https://aws.amazon.com/premiumsupport/enterprise-support/).
#'
#' @usage
#' shield_associate_drt_role(RoleArn)
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role the DRT will use to access
#' your AWS account.
#' 
#' Prior to making the `AssociateDRTRole` request, you must attach the
#' [AWSShieldDRTAccessPolicy](https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy)
#' managed policy to this role. For more information see Attaching and
#' Detaching IAM Policies.
#'
#' @section Request syntax:
#' ```
#' svc$associate_drt_role(
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_associate_drt_role
shield_associate_drt_role <- function(RoleArn) {
  op <- new_operation(
    name = "AssociateDRTRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_drt_role_input(RoleArn = RoleArn)
  output <- .shield$associate_drt_role_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_drt_role <- shield_associate_drt_role

#' Adds health-based detection to the Shield Advanced protection for a
#' resource
#'
#' Adds health-based detection to the Shield Advanced protection for a
#' resource. Shield Advanced health-based detection uses the health of your
#' AWS resource to improve responsiveness and accuracy in attack detection
#' and mitigation.
#' 
#' You define the health check in Route 53 and then associate it with your
#' Shield Advanced protection. For more information, see [Shield Advanced
#' Health-Based
#' Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option)
#' in the [AWS WAF and AWS Shield Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' shield_associate_health_check(ProtectionId, HealthCheckArn)
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to add the health
#' check association to.
#' @param HealthCheckArn &#91;required&#93; The Amazon Resource Name (ARN) of the health check to associate with the
#' protection.
#'
#' @section Request syntax:
#' ```
#' svc$associate_health_check(
#'   ProtectionId = "string",
#'   HealthCheckArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_associate_health_check
shield_associate_health_check <- function(ProtectionId, HealthCheckArn) {
  op <- new_operation(
    name = "AssociateHealthCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_health_check_input(ProtectionId = ProtectionId, HealthCheckArn = HealthCheckArn)
  output <- .shield$associate_health_check_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_health_check <- shield_associate_health_check

#' Initializes proactive engagement and sets the list of contacts for the
#' DDoS Response Team (DRT) to use
#'
#' Initializes proactive engagement and sets the list of contacts for the
#' DDoS Response Team (DRT) to use. You must provide at least one phone
#' number in the emergency contact list.
#' 
#' After you have initialized proactive engagement using this call, to
#' disable or enable proactive engagement, use the calls
#' `DisableProactiveEngagement` and `EnableProactiveEngagement`.
#' 
#' This call defines the list of email addresses and phone numbers that the
#' DDoS Response Team (DRT) can use to contact you for escalations to the
#' DRT and to initiate proactive customer support.
#' 
#' The contacts that you provide in the request replace any contacts that
#' were already defined. If you already have contacts defined and want to
#' use them, retrieve the list using `DescribeEmergencyContactSettings` and
#' then provide it to this call.
#'
#' @usage
#' shield_associate_proactive_engagement_details(EmergencyContactList)
#'
#' @param EmergencyContactList &#91;required&#93; A list of email addresses and phone numbers that the DDoS Response Team
#' (DRT) can use to contact you for escalations to the DRT and to initiate
#' proactive customer support.
#' 
#' To enable proactive engagement, the contact list must include at least
#' one phone number.
#' 
#' The contacts that you provide here replace any contacts that were
#' already defined. If you already have contacts defined and want to use
#' them, retrieve the list using `DescribeEmergencyContactSettings` and
#' then provide it here.
#'
#' @section Request syntax:
#' ```
#' svc$associate_proactive_engagement_details(
#'   EmergencyContactList = list(
#'     list(
#'       EmailAddress = "string",
#'       PhoneNumber = "string",
#'       ContactNotes = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_associate_proactive_engagement_details
shield_associate_proactive_engagement_details <- function(EmergencyContactList) {
  op <- new_operation(
    name = "AssociateProactiveEngagementDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$associate_proactive_engagement_details_input(EmergencyContactList = EmergencyContactList)
  output <- .shield$associate_proactive_engagement_details_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$associate_proactive_engagement_details <- shield_associate_proactive_engagement_details

#' Enables AWS Shield Advanced for a specific AWS resource
#'
#' Enables AWS Shield Advanced for a specific AWS resource. The resource
#' can be an Amazon CloudFront distribution, Elastic Load Balancing load
#' balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an
#' Amazon Route 53 hosted zone.
#' 
#' You can add protection to only a single resource with each
#' CreateProtection request. If you want to add protection to multiple
#' resources at once, use the [AWS WAF
#' console](https://console.aws.amazon.com/waf/). For more information see
#' [Getting Started with AWS Shield
#' Advanced](https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html)
#' and [Add AWS Shield Advanced Protection to more AWS
#' Resources](https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html).
#'
#' @usage
#' shield_create_protection(Name, ResourceArn)
#'
#' @param Name &#91;required&#93; Friendly name for the `Protection` you are creating.
#' @param ResourceArn &#91;required&#93; The ARN (Amazon Resource Name) of the resource to be protected.
#' 
#' The ARN should be in one of the following formats:
#' 
#' -   For an Application Load Balancer:
#'     `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> `
#' 
#' -   For an Elastic Load Balancer (Classic Load Balancer):
#'     `arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/<i>load-balancer-name</i> `
#' 
#' -   For an AWS CloudFront distribution:
#'     `arn:aws:cloudfront::<i>account-id</i>:distribution/<i>distribution-id</i> `
#' 
#' -   For an AWS Global Accelerator accelerator:
#'     `arn:aws:globalaccelerator::<i>account-id</i>:accelerator/<i>accelerator-id</i> `
#' 
#' -   For Amazon Route 53:
#'     `arn:aws:route53:::hostedzone/<i>hosted-zone-id</i> `
#' 
#' -   For an Elastic IP address:
#'     `arn:aws:ec2:<i>region</i>:<i>account-id</i>:eip-allocation/<i>allocation-id</i> `
#'
#' @section Request syntax:
#' ```
#' svc$create_protection(
#'   Name = "string",
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_create_protection
shield_create_protection <- function(Name, ResourceArn) {
  op <- new_operation(
    name = "CreateProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$create_protection_input(Name = Name, ResourceArn = ResourceArn)
  output <- .shield$create_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$create_protection <- shield_create_protection

#' Activates AWS Shield Advanced for an account
#'
#' Activates AWS Shield Advanced for an account.
#' 
#' When you initally create a subscription, your subscription is set to be
#' automatically renewed at the end of the existing subscription period.
#' You can change this by submitting an `UpdateSubscription` request.
#'
#' @usage
#' shield_create_subscription()
#'
#' @section Request syntax:
#' ```
#' svc$create_subscription()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_create_subscription
shield_create_subscription <- function() {
  op <- new_operation(
    name = "CreateSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$create_subscription_input()
  output <- .shield$create_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$create_subscription <- shield_create_subscription

#' Deletes an AWS Shield Advanced Protection
#'
#' Deletes an AWS Shield Advanced Protection.
#'
#' @usage
#' shield_delete_protection(ProtectionId)
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to be deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_protection(
#'   ProtectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_delete_protection
shield_delete_protection <- function(ProtectionId) {
  op <- new_operation(
    name = "DeleteProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$delete_protection_input(ProtectionId = ProtectionId)
  output <- .shield$delete_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$delete_protection <- shield_delete_protection

#' Removes AWS Shield Advanced from an account
#'
#' Removes AWS Shield Advanced from an account. AWS Shield Advanced
#' requires a 1-year subscription commitment. You cannot delete a
#' subscription prior to the completion of that commitment.
#'
#' @usage
#' shield_delete_subscription()
#'
#' @section Request syntax:
#' ```
#' svc$delete_subscription()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_delete_subscription
shield_delete_subscription <- function() {
  op <- new_operation(
    name = "DeleteSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$delete_subscription_input()
  output <- .shield$delete_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$delete_subscription <- shield_delete_subscription

#' Describes the details of a DDoS attack
#'
#' Describes the details of a DDoS attack.
#'
#' @usage
#' shield_describe_attack(AttackId)
#'
#' @param AttackId &#91;required&#93; The unique identifier (ID) for the attack that to be described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_attack(
#'   AttackId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_describe_attack
shield_describe_attack <- function(AttackId) {
  op <- new_operation(
    name = "DescribeAttack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_attack_input(AttackId = AttackId)
  output <- .shield$describe_attack_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_attack <- shield_describe_attack

#' Returns the current role and list of Amazon S3 log buckets used by the
#' DDoS Response Team (DRT) to access your AWS account while assisting with
#' attack mitigation
#'
#' Returns the current role and list of Amazon S3 log buckets used by the
#' DDoS Response Team (DRT) to access your AWS account while assisting with
#' attack mitigation.
#'
#' @usage
#' shield_describe_drt_access()
#'
#' @section Request syntax:
#' ```
#' svc$describe_drt_access()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_describe_drt_access
shield_describe_drt_access <- function() {
  op <- new_operation(
    name = "DescribeDRTAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_drt_access_input()
  output <- .shield$describe_drt_access_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_drt_access <- shield_describe_drt_access

#' A list of email addresses and phone numbers that the DDoS Response Team
#' (DRT) can use to contact you if you have proactive engagement enabled,
#' for escalations to the DRT and to initiate proactive customer support
#'
#' A list of email addresses and phone numbers that the DDoS Response Team
#' (DRT) can use to contact you if you have proactive engagement enabled,
#' for escalations to the DRT and to initiate proactive customer support.
#'
#' @usage
#' shield_describe_emergency_contact_settings()
#'
#' @section Request syntax:
#' ```
#' svc$describe_emergency_contact_settings()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_describe_emergency_contact_settings
shield_describe_emergency_contact_settings <- function() {
  op <- new_operation(
    name = "DescribeEmergencyContactSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_emergency_contact_settings_input()
  output <- .shield$describe_emergency_contact_settings_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_emergency_contact_settings <- shield_describe_emergency_contact_settings

#' Lists the details of a Protection object
#'
#' Lists the details of a Protection object.
#'
#' @usage
#' shield_describe_protection(ProtectionId, ResourceArn)
#'
#' @param ProtectionId The unique identifier (ID) for the Protection object that is described.
#' When submitting the `DescribeProtection` request you must provide either
#' the `ResourceArn` or the `ProtectionID`, but not both.
#' @param ResourceArn The ARN (Amazon Resource Name) of the AWS resource for the Protection
#' object that is described. When submitting the `DescribeProtection`
#' request you must provide either the `ResourceArn` or the `ProtectionID`,
#' but not both.
#'
#' @section Request syntax:
#' ```
#' svc$describe_protection(
#'   ProtectionId = "string",
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_describe_protection
shield_describe_protection <- function(ProtectionId = NULL, ResourceArn = NULL) {
  op <- new_operation(
    name = "DescribeProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_protection_input(ProtectionId = ProtectionId, ResourceArn = ResourceArn)
  output <- .shield$describe_protection_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_protection <- shield_describe_protection

#' Provides details about the AWS Shield Advanced subscription for an
#' account
#'
#' Provides details about the AWS Shield Advanced subscription for an
#' account.
#'
#' @usage
#' shield_describe_subscription()
#'
#' @section Request syntax:
#' ```
#' svc$describe_subscription()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_describe_subscription
shield_describe_subscription <- function() {
  op <- new_operation(
    name = "DescribeSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$describe_subscription_input()
  output <- .shield$describe_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$describe_subscription <- shield_describe_subscription

#' Removes authorization from the DDoS Response Team (DRT) to notify
#' contacts about escalations to the DRT and to initiate proactive customer
#' support
#'
#' Removes authorization from the DDoS Response Team (DRT) to notify
#' contacts about escalations to the DRT and to initiate proactive customer
#' support.
#'
#' @usage
#' shield_disable_proactive_engagement()
#'
#' @section Request syntax:
#' ```
#' svc$disable_proactive_engagement()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_disable_proactive_engagement
shield_disable_proactive_engagement <- function() {
  op <- new_operation(
    name = "DisableProactiveEngagement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disable_proactive_engagement_input()
  output <- .shield$disable_proactive_engagement_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disable_proactive_engagement <- shield_disable_proactive_engagement

#' Removes the DDoS Response Team's (DRT) access to the specified Amazon S3
#' bucket containing your AWS WAF logs
#'
#' Removes the DDoS Response Team\'s (DRT) access to the specified Amazon
#' S3 bucket containing your AWS WAF logs.
#' 
#' To make a `DisassociateDRTLogBucket` request, you must be subscribed to
#' the [Business Support
#' plan](https://aws.amazon.com/premiumsupport/business-support/) or the
#' [Enterprise Support
#' plan](https://aws.amazon.com/premiumsupport/enterprise-support/).
#' However, if you are not subscribed to one of these support plans, but
#' had been previously and had granted the DRT access to your account, you
#' can submit a `DisassociateDRTLogBucket` request to remove this access.
#'
#' @usage
#' shield_disassociate_drt_log_bucket(LogBucket)
#'
#' @param LogBucket &#91;required&#93; The Amazon S3 bucket that contains your AWS WAF logs.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_drt_log_bucket(
#'   LogBucket = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_drt_log_bucket
shield_disassociate_drt_log_bucket <- function(LogBucket) {
  op <- new_operation(
    name = "DisassociateDRTLogBucket",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_drt_log_bucket_input(LogBucket = LogBucket)
  output <- .shield$disassociate_drt_log_bucket_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_drt_log_bucket <- shield_disassociate_drt_log_bucket

#' Removes the DDoS Response Team's (DRT) access to your AWS account
#'
#' Removes the DDoS Response Team\'s (DRT) access to your AWS account.
#' 
#' To make a `DisassociateDRTRole` request, you must be subscribed to the
#' [Business Support
#' plan](https://aws.amazon.com/premiumsupport/business-support/) or the
#' [Enterprise Support
#' plan](https://aws.amazon.com/premiumsupport/enterprise-support/).
#' However, if you are not subscribed to one of these support plans, but
#' had been previously and had granted the DRT access to your account, you
#' can submit a `DisassociateDRTRole` request to remove this access.
#'
#' @usage
#' shield_disassociate_drt_role()
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_drt_role()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_drt_role
shield_disassociate_drt_role <- function() {
  op <- new_operation(
    name = "DisassociateDRTRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_drt_role_input()
  output <- .shield$disassociate_drt_role_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_drt_role <- shield_disassociate_drt_role

#' Removes health-based detection from the Shield Advanced protection for a
#' resource
#'
#' Removes health-based detection from the Shield Advanced protection for a
#' resource. Shield Advanced health-based detection uses the health of your
#' AWS resource to improve responsiveness and accuracy in attack detection
#' and mitigation.
#' 
#' You define the health check in Route 53 and then associate or
#' disassociate it with your Shield Advanced protection. For more
#' information, see [Shield Advanced Health-Based
#' Detection](https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option)
#' in the [AWS WAF and AWS Shield Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' shield_disassociate_health_check(ProtectionId, HealthCheckArn)
#'
#' @param ProtectionId &#91;required&#93; The unique identifier (ID) for the Protection object to remove the
#' health check association from.
#' @param HealthCheckArn &#91;required&#93; The Amazon Resource Name (ARN) of the health check that is associated
#' with the protection.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_health_check(
#'   ProtectionId = "string",
#'   HealthCheckArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_disassociate_health_check
shield_disassociate_health_check <- function(ProtectionId, HealthCheckArn) {
  op <- new_operation(
    name = "DisassociateHealthCheck",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$disassociate_health_check_input(ProtectionId = ProtectionId, HealthCheckArn = HealthCheckArn)
  output <- .shield$disassociate_health_check_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$disassociate_health_check <- shield_disassociate_health_check

#' Authorizes the DDoS Response Team (DRT) to use email and phone to notify
#' contacts about escalations to the DRT and to initiate proactive customer
#' support
#'
#' Authorizes the DDoS Response Team (DRT) to use email and phone to notify
#' contacts about escalations to the DRT and to initiate proactive customer
#' support.
#'
#' @usage
#' shield_enable_proactive_engagement()
#'
#' @section Request syntax:
#' ```
#' svc$enable_proactive_engagement()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_enable_proactive_engagement
shield_enable_proactive_engagement <- function() {
  op <- new_operation(
    name = "EnableProactiveEngagement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$enable_proactive_engagement_input()
  output <- .shield$enable_proactive_engagement_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$enable_proactive_engagement <- shield_enable_proactive_engagement

#' Returns the SubscriptionState, either Active or Inactive
#'
#' Returns the `SubscriptionState`, either `Active` or `Inactive`.
#'
#' @usage
#' shield_get_subscription_state()
#'
#' @section Request syntax:
#' ```
#' svc$get_subscription_state()
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_get_subscription_state
shield_get_subscription_state <- function() {
  op <- new_operation(
    name = "GetSubscriptionState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$get_subscription_state_input()
  output <- .shield$get_subscription_state_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$get_subscription_state <- shield_get_subscription_state

#' Returns all ongoing DDoS attacks or all DDoS attacks during a specified
#' time period
#'
#' Returns all ongoing DDoS attacks or all DDoS attacks during a specified
#' time period.
#'
#' @usage
#' shield_list_attacks(ResourceArns, StartTime, EndTime, NextToken,
#'   MaxResults)
#'
#' @param ResourceArns The ARN (Amazon Resource Name) of the resource that was attacked. If
#' this is left blank, all applicable resources for this account will be
#' included.
#' @param StartTime The start of the time period for the attacks. This is a `timestamp`
#' type. The sample request above indicates a `number` type because the
#' default used by WAF is Unix time in seconds. However any valid
#' [timestamp
#' format](http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types)
#' is allowed.
#' @param EndTime The end of the time period for the attacks. This is a `timestamp` type.
#' The sample request above indicates a `number` type because the default
#' used by WAF is Unix time in seconds. However any valid [timestamp
#' format](http://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#parameter-types)
#' is allowed.
#' @param NextToken The `ListAttacksRequest.NextMarker` value from a previous call to
#' `ListAttacksRequest`. Pass null if this is the first call.
#' @param MaxResults The maximum number of AttackSummary objects to be returned. If this is
#' left blank, the first 20 results will be returned.
#' 
#' This is a maximum value; it is possible that AWS WAF will return the
#' results in smaller batches. That is, the number of AttackSummary objects
#' returned could be less than `MaxResults`, even if there are still more
#' AttackSummary objects yet to return. If there are more AttackSummary
#' objects to return, AWS WAF will always also return a `NextToken`.
#'
#' @section Request syntax:
#' ```
#' svc$list_attacks(
#'   ResourceArns = list(
#'     "string"
#'   ),
#'   StartTime = list(
#'     FromInclusive = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ToExclusive = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   EndTime = list(
#'     FromInclusive = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ToExclusive = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_list_attacks
shield_list_attacks <- function(ResourceArns = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAttacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$list_attacks_input(ResourceArns = ResourceArns, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .shield$list_attacks_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_attacks <- shield_list_attacks

#' Lists all Protection objects for the account
#'
#' Lists all Protection objects for the account.
#'
#' @usage
#' shield_list_protections(NextToken, MaxResults)
#'
#' @param NextToken The `ListProtectionsRequest.NextToken` value from a previous call to
#' `ListProtections`. Pass null if this is the first call.
#' @param MaxResults The maximum number of Protection objects to be returned. If this is left
#' blank the first 20 results will be returned.
#' 
#' This is a maximum value; it is possible that AWS WAF will return the
#' results in smaller batches. That is, the number of Protection objects
#' returned could be less than `MaxResults`, even if there are still more
#' Protection objects yet to return. If there are more Protection objects
#' to return, AWS WAF will always also return a `NextToken`.
#'
#' @section Request syntax:
#' ```
#' svc$list_protections(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_list_protections
shield_list_protections <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProtections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$list_protections_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .shield$list_protections_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$list_protections <- shield_list_protections

#' Updates the details of the list of email addresses and phone numbers
#' that the DDoS Response Team (DRT) can use to contact you if you have
#' proactive engagement enabled, for escalations to the DRT and to initiate
#' proactive customer support
#'
#' Updates the details of the list of email addresses and phone numbers
#' that the DDoS Response Team (DRT) can use to contact you if you have
#' proactive engagement enabled, for escalations to the DRT and to initiate
#' proactive customer support.
#'
#' @usage
#' shield_update_emergency_contact_settings(EmergencyContactList)
#'
#' @param EmergencyContactList A list of email addresses and phone numbers that the DDoS Response Team
#' (DRT) can use to contact you if you have proactive engagement enabled,
#' for escalations to the DRT and to initiate proactive customer support.
#' 
#' If you have proactive engagement enabled, the contact list must include
#' at least one phone number.
#'
#' @section Request syntax:
#' ```
#' svc$update_emergency_contact_settings(
#'   EmergencyContactList = list(
#'     list(
#'       EmailAddress = "string",
#'       PhoneNumber = "string",
#'       ContactNotes = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_update_emergency_contact_settings
shield_update_emergency_contact_settings <- function(EmergencyContactList = NULL) {
  op <- new_operation(
    name = "UpdateEmergencyContactSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_emergency_contact_settings_input(EmergencyContactList = EmergencyContactList)
  output <- .shield$update_emergency_contact_settings_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_emergency_contact_settings <- shield_update_emergency_contact_settings

#' Updates the details of an existing subscription
#'
#' Updates the details of an existing subscription. Only enter values for
#' parameters you want to change. Empty parameters are not updated.
#'
#' @usage
#' shield_update_subscription(AutoRenew)
#'
#' @param AutoRenew When you initally create a subscription, `AutoRenew` is set to
#' `ENABLED`. If `ENABLED`, the subscription will be automatically renewed
#' at the end of the existing subscription period. You can change this by
#' submitting an `UpdateSubscription` request. If the `UpdateSubscription`
#' request does not included a value for `AutoRenew`, the existing value
#' for `AutoRenew` remains unchanged.
#'
#' @section Request syntax:
#' ```
#' svc$update_subscription(
#'   AutoRenew = "ENABLED"|"DISABLED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname shield_update_subscription
shield_update_subscription <- function(AutoRenew = NULL) {
  op <- new_operation(
    name = "UpdateSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .shield$update_subscription_input(AutoRenew = AutoRenew)
  output <- .shield$update_subscription_output()
  config <- get_config()
  svc <- .shield$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.shield$operations$update_subscription <- shield_update_subscription
