% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_update_geo_match_set}
\alias{waf_update_geo_match_set}
\title{Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet}
\usage{
waf_update_geo_match_set(GeoMatchSetId, ChangeToken, Updates)
}
\arguments{
\item{GeoMatchSetId}{[required] The \code{GeoMatchSetId} of the GeoMatchSet that you want to update.
\code{GeoMatchSetId} is returned by CreateGeoMatchSet and by
ListGeoMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{GeoMatchSetUpdate} objects that you want to insert into or
delete from an GeoMatchSet. For more information, see the applicable
data types:
\itemize{
\item GeoMatchSetUpdate: Contains \code{Action} and \code{GeoMatchConstraint}
\item GeoMatchConstraint: Contains \code{Type} and \code{Value}

You can have only one \code{Type} and \code{Value} per \code{GeoMatchConstraint}.
To add multiple countries, include multiple \code{GeoMatchSetUpdate}
objects in your request.
}}
}
\description{
Inserts or deletes GeoMatchConstraint objects in an \code{GeoMatchSet}. For
each \code{GeoMatchConstraint} object, you specify the following values:
}
\details{
\itemize{
\item Whether to insert or delete the object from the array. If you want
to change an \code{GeoMatchConstraint} object, you delete the existing
object and add a new one.
\item The \code{Type}. The only valid value for \code{Type} is \code{Country}.
\item The \code{Value}, which is a two character code for the country to add to
the \code{GeoMatchConstraint} object. Valid codes are listed in
GeoMatchConstraint\\$Value.
}

To create and configure an \code{GeoMatchSet}, perform the following steps:
\enumerate{
\item Submit a CreateGeoMatchSet request.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateGeoMatchSet request.
\item Submit an \code{UpdateGeoMatchSet} request to specify the country that
you want AWS WAF to watch for.
}

When you update an \code{GeoMatchSet}, you specify the country that you want
to add and/or the country that you want to delete. If you want to change
a country, you delete the existing country and add the new one.

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_geo_match_set(
  GeoMatchSetId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      GeoMatchConstraint = list(
        Type = "Country",
        Value = "AF"|"AX"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BQ"|"BA"|"BW"|"BV"|"BR"|"IO"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CG"|"CD"|"CK"|"CR"|"CI"|"HR"|"CU"|"CW"|"CY"|"CZ"|"DK"|"DJ"|"DM"|"DO"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"GF"|"PF"|"TF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GP"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HM"|"VA"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KP"|"KR"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MQ"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"NF"|"MP"|"NO"|"OM"|"PK"|"PW"|"PS"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"GS"|"SS"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TL"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"UG"|"UA"|"AE"|"GB"|"US"|"UM"|"UY"|"UZ"|"VU"|"VE"|"VN"|"VG"|"VI"|"WF"|"EH"|"YE"|"ZM"|"ZW"
      )
    )
  )
)
}
}

\keyword{internal}
