% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_alias}
\alias{kms_create_alias}
\title{Creates a display name for a customer managed customer master key (CMK)}
\usage{
kms_create_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] Specifies the alias name. This value must begin with \verb{alias/} followed
by a name, such as \code{alias/ExampleAlias}. The alias name cannot begin
with \verb{alias/aws/}. The \verb{alias/aws/} prefix is reserved for AWS managed
CMKs.}

\item{TargetKeyId}{[required] Identifies the CMK to which the alias refers. Specify the key ID or the
Amazon Resource Name (ARN) of the CMK. You cannot specify another alias.
For help finding the key ID and ARN, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn}{Finding the Key ID and ARN}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Creates a display name for a customer managed customer master key (CMK).
You can use an alias to identify a CMK in cryptographic operations, such
as Encrypt and GenerateDataKey. You can change the CMK associated with
the alias at any time.
}
\details{
Aliases are easier to remember than key IDs. They can also help to
simplify your applications. For example, if you use an alias in your
code, you can change the CMK your code uses by associating a given alias
with a different CMK.

To run the same code in multiple AWS regions, use an alias in your code,
such as \code{alias/ApplicationKey}. Then, in each AWS Region, create an
\code{alias/ApplicationKey} alias that is associated with a CMK in that
Region. When you run your code, it uses the \code{alias/ApplicationKey} CMK
for that AWS Region without any Region-specific code.

This operation does not return a response. To get the alias that you
created, use the ListAliases operation.

To use aliases successfully, be aware of the following information.
\itemize{
\item Each alias points to only one CMK at a time, although a single CMK
can have multiple aliases. The alias and its associated CMK must be
in the same AWS account and Region.
\item You can associate an alias with any customer managed CMK in the same
AWS account and Region. However, you do not have permission to
associate an alias with an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMK}
or an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk}{AWS owned CMK}.
\item To change the CMK associated with an alias, use the UpdateAlias
operation. The current CMK and the new CMK must be the same type
(both symmetric or both asymmetric) and they must have the same key
usage (\code{ENCRYPT_DECRYPT} or \code{SIGN_VERIFY}). This restriction
prevents cryptographic errors in code that uses aliases.
\item The alias name must begin with \verb{alias/} followed by a name, such as
\code{alias/ExampleAlias}. It can contain only alphanumeric characters,
forward slashes (/), underscores (\\_), and dashes (-). The alias
name cannot begin with \verb{alias/aws/}. The \verb{alias/aws/} prefix is
reserved for \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMKs}.
\item The alias name must be unique within an AWS Region. However, you can
use the same alias name in multiple Regions of the same AWS account.
Each instance of the alias is associated with a CMK in its Region.
\item After you create an alias, you cannot change its alias name.
However, you can use the DeleteAlias operation to delete the alias
and then create a new alias with the desired name.
\item You can use an alias name or alias ARN to identify a CMK in AWS KMS
cryptographic operations and in the DescribeKey operation. However,
you cannot use alias names or alias ARNs in API operations that
manage CMKs, such as DisableKey or GetKeyPolicy. For information
about the valid CMK identifiers for each AWS KMS API operation, see
the descriptions of the \code{KeyId} parameter in the API operation
documentation.
}

Because an alias is not a property of a CMK, you can delete and change
the aliases of a CMK without affecting the CMK. Also, aliases do not
appear in the response from the DescribeKey operation. To get the
aliases and alias ARNs of CMKs in each AWS account and Region, use the
ListAliases operation.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_alias(
  AliasName = "string",
  TargetKeyId = "string"
)
}
}

\examples{
\dontrun{
# The following example creates an alias for the specified customer master
# key (CMK).
svc$create_alias(
  AliasName = "alias/ExampleAlias",
  TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
