% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_update_assessment_target}
\alias{inspector_update_assessment_target}
\title{Updates the assessment target that is specified by the ARN of the
assessment target}
\usage{
inspector_update_assessment_target(assessmentTargetArn,
  assessmentTargetName, resourceGroupArn)
}
\arguments{
\item{assessmentTargetArn}{[required] The ARN of the assessment target that you want to update.}

\item{assessmentTargetName}{[required] The name of the assessment target that you want to update.}

\item{resourceGroupArn}{The ARN of the resource group that is used to specify the new resource
group to associate with the assessment target.}
}
\description{
Updates the assessment target that is specified by the ARN of the
assessment target.
}
\details{
If resourceGroupArn is not specified, all EC2 instances in the current
AWS account and region are included in the assessment target.
}
\section{Request syntax}{
\preformatted{svc$update_assessment_target(
  assessmentTargetArn = "string",
  assessmentTargetName = "string",
  resourceGroupArn = "string"
)
}
}

\examples{
# Updates the assessment target that is specified by the ARN of the
# assessment target.
\donttest{svc$update_assessment_target(
  assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX",
  assessmentTargetName = "Example",
  resourceGroupArn = "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-yNbgL5Pt"
)}

}
\keyword{internal}
