% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_roles}
\alias{iam_list_roles}
\title{Lists the IAM roles that have the specified path prefix}
\usage{
iam_list_roles(PathPrefix, Marker, MaxItems)
}
\arguments{
\item{PathPrefix}{The path prefix for filtering the results. For example, the prefix
\verb{/application_abc/component_xyz/} gets all roles whose path starts with
\verb{/application_abc/component_xyz/}.

This parameter is optional. If it is not included, it defaults to a
slash (/), listing all roles. This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists the IAM roles that have the specified path prefix. If there are
none, the operation returns an empty list. For more information about
roles, go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html}{Working with Roles}.
}
\details{
You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters.
}
\section{Request syntax}{
\preformatted{svc$list_roles(
  PathPrefix = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
