% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_re_encrypt}
\alias{kms_re_encrypt}
\title{Encrypts data on the server side with a new customer master key (CMK)
without exposing the plaintext of the data on the client side}
\usage{
kms_re_encrypt(CiphertextBlob, SourceEncryptionContext,
  DestinationKeyId, DestinationEncryptionContext, GrantTokens)
}
\arguments{
\item{CiphertextBlob}{[required] Ciphertext of the data to reencrypt.}

\item{SourceEncryptionContext}{Encryption context used to encrypt and decrypt the data specified in the
\code{CiphertextBlob} parameter.}

\item{DestinationKeyId}{[required] A unique identifier for the CMK that is used to reencrypt the data.

To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
name, or alias ARN. When using an alias name, prefix it with \code{"alias/"}.
To specify a CMK in a different AWS account, you must use the key ARN or
alias ARN.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
get the alias name and alias ARN, use ListAliases.}

\item{DestinationEncryptionContext}{Encryption context to use when the data is reencrypted.}

\item{GrantTokens}{A list of grant tokens.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token}{Grant Tokens}
in the \emph{AWS Key Management Service Developer Guide}.}
}
\description{
Encrypts data on the server side with a new customer master key (CMK)
without exposing the plaintext of the data on the client side. The data
is first decrypted and then reencrypted. You can also use this operation
to change the encryption context of a ciphertext.
}
\details{
You can reencrypt data using CMKs in different AWS accounts.

Unlike other operations, \code{ReEncrypt} is authorized twice, once as
\code{ReEncryptFrom} on the source CMK and once as \code{ReEncryptTo} on the
destination CMK. We recommend that you include the \code{"kms:ReEncrypt*"}
permission in your \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html}{key policies}
to permit reencryption from or to the CMK. This permission is
automatically included in the key policy when you create a CMK through
the console. But you must include it manually when you create a CMK
programmatically or when you set a key policy with the PutKeyPolicy
operation.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$re_encrypt(
  CiphertextBlob = raw,
  SourceEncryptionContext = list(
    "string"
  ),
  DestinationKeyId = "string",
  DestinationEncryptionContext = list(
    "string"
  ),
  GrantTokens = list(
    "string"
  )
)
}
}

\examples{
# The following example reencrypts data with the specified CMK.
\donttest{svc$re_encrypt(
  CiphertextBlob = "<binary data>",
  DestinationKeyId = "0987dcba-09fe-87dc-65ba-ab0987654321"
)}

}
\keyword{internal}
