% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_update_user_attributes}
\alias{cognitoidentityprovider_admin_update_user_attributes}
\title{Updates the specified user's attributes, including developer attributes,
as an administrator}
\usage{
cognitoidentityprovider_admin_update_user_attributes(UserPoolId,
  Username, UserAttributes)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to update user
attributes.}

\item{Username}{[required] The user name of the user for whom you want to update user attributes.}

\item{UserAttributes}{[required] An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \code{custom:} prefix to the
attribute name.}
}
\description{
Updates the specified user's attributes, including developer
attributes, as an administrator. Works on any user.
}
\details{
For custom attributes, you must prepend the \code{custom:} prefix to the
attribute name.

In addition to updating user attributes, this API can also be used to
mark phone and email as verified.

Requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_update_user_attributes(
  UserPoolId = "string",
  Username = "string",
  UserAttributes = list(
    list(
      Name = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
