% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_federation_token}
\alias{sts_get_federation_token}
\title{Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) for a federated user}
\usage{
sts_get_federation_token(Name, Policy, PolicyArns, DurationSeconds)
}
\arguments{
\item{Name}{[required] The name of the federated user. The name is used as an identifier for
the temporary security credentials (such as \code{Bob}). For example, you can
reference the federated user name in a resource-based policy, such as in
an Amazon S3 bucket policy.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{Policy}{An IAM policy in JSON format that you want to use as an inline session
policy.

You must pass an inline or managed \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{session policy}
to this operation. You can pass a single JSON policy document to use as
an inline session policy. You can also specify up to 10 managed policies
to use as managed session policies.

This parameter is optional. However, if you do not pass any session
policies, then the resulting federated user session has no permissions.
The only exception is when the credentials are used to access a resource
that has a resource-based policy that specifically references the
federated user session in the \code{Principal} element of the policy.

When you pass session policies, the session permissions are the
intersection of the IAM user policies and the session policies that you
pass. This gives you a way to further restrict the permissions for a
federated user. You cannot use session policies to grant more
permissions than those that are defined in the permissions policy of the
IAM user. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The plain text that you use for both inline and managed session policies
shouldn't exceed 2048 characters. The JSON policy characters can be any
ASCII character from the space character to the end of the valid
character list (\code{U+0020} through \code{U+00FF}). It can also include the tab
(\code{U+0009}), linefeed (\code{U+000A}), and carriage return (\code{U+000D}) characters.

The characters in this parameter count towards the 2048 character
session policy guideline. However, an AWS conversion compresses the
session policies into a packed binary format that has a separate limit.
This is the enforced limit. The \code{PackedPolicySize} response element
indicates by percentage how close the policy is to the upper size limit.}

\item{PolicyArns}{The Amazon Resource Names (ARNs) of the IAM managed policies that you
want to use as a managed session policy. The policies must exist in the
same account as the IAM user that is requesting federated access.

You must pass an inline or managed \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{session policy}
to this operation. You can pass a single JSON policy document to use as
an inline session policy. You can also specify up to 10 managed policies
to use as managed session policies. The plain text that you use for both
inline and managed session policies shouldn't exceed 2048 characters.
You can provide up to 10 managed policy ARNs. For more information about
ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the AWS General Reference.

This parameter is optional. However, if you do not pass any session
policies, then the resulting federated user session has no permissions.
The only exception is when the credentials are used to access a resource
that has a resource-based policy that specifically references the
federated user session in the \code{Principal} element of the policy.

When you pass session policies, the session permissions are the
intersection of the IAM user policies and the session policies that you
pass. This gives you a way to further restrict the permissions for a
federated user. You cannot use session policies to grant more
permissions than those that are defined in the permissions policy of the
IAM user. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The characters in this parameter count towards the 2048 character
session policy guideline. However, an AWS conversion compresses the
session policies into a packed binary format that has a separate limit.
This is the enforced limit. The \code{PackedPolicySize} response element
indicates by percentage how close the policy is to the upper size limit.}

\item{DurationSeconds}{The duration, in seconds, that the session should last. Acceptable
durations for federation sessions range from 900 seconds (15 minutes) to
129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the
default. Sessions obtained using AWS account root user credentials are
restricted to a maximum of 3,600 seconds (one hour). If the specified
duration is longer than one hour, the session obtained by using root
user credentials defaults to one hour.}
}
\description{
Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) for a federated user.
A typical use is in a proxy application that gets temporary security
credentials on behalf of distributed applications inside a corporate
network. You must call the \code{GetFederationToken} operation using the
long-term security credentials of an IAM user. As a result, this call is
appropriate in contexts where those credentials can be safely stored,
usually in a server-based application. For a comparison of
\code{GetFederationToken} with the other API operations that produce
temporary credentials, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS API operations}
in the \emph{IAM User Guide}.
}
\details{
You can create a mobile-based or browser-based app that can authenticate
users using a web identity provider like Login with Amazon, Facebook,
Google, or an OpenID Connect-compatible identity provider. In this case,
we recommend that you use \href{http://aws.amazon.com/cognito/}{Amazon Cognito} or \code{AssumeRoleWithWebIdentity}.
For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity}{Federation Through a Web-based Identity Provider}.

You can also call \code{GetFederationToken} using the security credentials of
an AWS account root user, but we do not recommend it. Instead, we
recommend that you create an IAM user for the purpose of the proxy
application. Then attach a policy to the IAM user that limits federated
users to only the actions and resources that they need to access. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html}{IAM Best Practices}
in the \emph{IAM User Guide}.

The temporary credentials are valid for the specified duration, from 900
seconds (15 minutes) up to a maximum of 129,600 seconds (36 hours). The
default is 43,200 seconds (12 hours). Temporary credentials that are
obtained by using AWS account root user credentials have a maximum
duration of 3,600 seconds (1 hour).

The temporary security credentials created by \code{GetFederationToken} can
be used to make API calls to any AWS service with the following
exceptions:
\itemize{
\item You cannot use these credentials to call any IAM API operations.
\item You cannot call any STS API operations except \code{GetCallerIdentity}.
}

\strong{Permissions}

You must pass an inline or managed \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{session policy}
to this operation. You can pass a single JSON policy document to use as
an inline session policy. You can also specify up to 10 managed policies
to use as managed session policies. The plain text that you use for both
inline and managed session policies shouldn't exceed 2048 characters.

Though the session policy parameters are optional, if you do not pass a
policy, then the resulting federated user session has no permissions.
The only exception is when the credentials are used to access a resource
that has a resource-based policy that specifically references the
federated user session in the \code{Principal} element of the policy. When
you pass session policies, the session permissions are the intersection
of the IAM user policies and the session policies that you pass. This
gives you a way to further restrict the permissions for a federated
user. You cannot use session policies to grant more permissions than
those that are defined in the permissions policy of the IAM user. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}. For information about using
\code{GetFederationToken} to create temporary security credentials, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getfederationtoken}{GetFederationToken---Federation Through a Custom Identity Broker}.
}
\section{Request syntax}{
\preformatted{svc$get_federation_token(
  Name = "string",
  Policy = "string",
  PolicyArns = list(
    list(
      arn = "string"
    )
  ),
  DurationSeconds = 123
)
}
}

\examples{
# 
\donttest{svc$get_federation_token(
  DurationSeconds = 3600L,
  Name = "Bob",
  Policy = "{\\"Version\\":\\"2012-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"Stmt1\\",\\"Effect\\":..."
)}

}
\keyword{internal}
