% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_create_protection}
\alias{shield_create_protection}
\title{Enables AWS Shield Advanced for a specific AWS resource}
\usage{
shield_create_protection(Name, ResourceArn)
}
\arguments{
\item{Name}{[required] Friendly name for the \code{Protection} you are creating.}

\item{ResourceArn}{[required] The ARN (Amazon Resource Name) of the resource to be protected.

The ARN should be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\code{arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id }
\item For an Elastic Load Balancer (Classic Load Balancer):
\code{arn:aws:elasticloadbalancing:region:account-id:loadbalancer/load-balancer-name }
\item For an AWS CloudFront distribution:
\code{arn:aws:cloudfront::account-id:distribution/distribution-id }
\item For an AWS Global Accelerator accelerator:
\code{arn:aws:globalaccelerator::account-id:accelerator/accelerator-id }
\item For Amazon Route 53: \code{arn:aws:route53:::hostedzone/hosted-zone-id }
\item For an Elastic IP address:
\code{arn:aws:ec2:region:account-id:eip-allocation/allocation-id }
}}
}
\value{
A list with the following syntax:\preformatted{list(
  ProtectionId = "string"
)
}
}
\description{
Enables AWS Shield Advanced for a specific AWS resource. The resource
can be an Amazon CloudFront distribution, Elastic Load Balancing load
balancer, AWS Global Accelerator accelerator, Elastic IP Address, or an
Amazon Route 53 hosted zone.

You can add protection to only a single resource with each
CreateProtection request. If you want to add protection to multiple
resources at once, use the AWS WAF console. For more information see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html}{Getting Started with AWS Shield Advanced}
and \href{https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html}{Add AWS Shield Advanced Protection to more AWS Resources}.
}
\section{Request syntax}{
\preformatted{svc$create_protection(
  Name = "string",
  ResourceArn = "string"
)
}
}

\keyword{internal}
