% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie_operations.R
\name{macie_disassociate_s3_resources}
\alias{macie_disassociate_s3_resources}
\title{Removes specified S3 resources from being monitored by Amazon Macie
Classic}
\usage{
macie_disassociate_s3_resources(memberAccountId, associatedS3Resources)
}
\arguments{
\item{memberAccountId}{The ID of the Amazon Macie Classic member account whose resources you
want to remove from being monitored by Amazon Macie Classic.}

\item{associatedS3Resources}{[required] The S3 resources (buckets or prefixes) that you want to remove from
being monitored and classified by Amazon Macie Classic.}
}
\value{
A list with the following syntax:\preformatted{list(
  failedS3Resources = list(
    list(
      failedItem = list(
        bucketName = "string",
        prefix = "string"
      ),
      errorCode = "string",
      errorMessage = "string"
    )
  )
)
}
}
\description{
Removes specified S3 resources from being monitored by Amazon Macie
Classic. If memberAccountId isn't specified, the action removes
specified S3 resources from Macie Classic for the current master
account. If memberAccountId is specified, the action removes specified
S3 resources from Macie Classic for the specified member account.
}
\section{Request syntax}{
\preformatted{svc$disassociate_s3_resources(
  memberAccountId = "string",
  associatedS3Resources = list(
    list(
      bucketName = "string",
      prefix = "string"
    )
  )
)
}
}

\keyword{internal}
