% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_service_linked_role}
\alias{iam_delete_service_linked_role}
\title{Submits a service-linked role deletion request and returns a
DeletionTaskId, which you can use to check the status of the deletion}
\usage{
iam_delete_service_linked_role(RoleName)
}
\arguments{
\item{RoleName}{[required] The name of the service-linked role to be deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  DeletionTaskId = "string"
)
}
}
\description{
Submits a service-linked role deletion request and returns a
\code{DeletionTaskId}, which you can use to check the status of the deletion.
Before you call this operation, confirm that the role has no active
sessions and that any resources used by the role in the linked service
are deleted. If you call this operation more than once for the same
service-linked role and an earlier deletion task is not complete, then
the \code{DeletionTaskId} of the earlier request is returned.

If you submit a deletion request for a service-linked role whose linked
service is still accessing a resource, then the deletion task fails. If
it fails, the
\code{\link[=iam_get_service_linked_role_deletion_status]{get_service_linked_role_deletion_status}}
API operation returns the reason for the failure, usually including the
resources that must be deleted. To delete the service-linked role, you
must first remove those resources from the linked service and then
submit the deletion request again. Resources are specific to the service
that is linked to the role. For more information about removing
resources from a service, see the \href{https://docs.aws.amazon.com/}{AWS documentation} for your service.

For more information about service-linked roles, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role}{Roles Terms and Concepts: AWS Service-Linked Role}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_service_linked_role(
  RoleName = "string"
)
}
}

\keyword{internal}
